/*
  Optimizer
  Global Header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#ifndef _GLOBAL_H_
#define _GLOBAL_H_

// Version number
#define VERSION "0.0.9f"

// Global constants
#define MaxSize     256

// List defines / Debug defines
#define IDLIST        1
#define STRLIST       2
#define EXTLIST       4
#define VARLIST       8
#define GBLLIST      16
#define ALL          32

// Field defines
#define EMPTY         0
#define LABEL         1
#define OPCODE        2
#define SRC           4
#define DEST          8

// Processor Defines
#define I486          0
#define PENTIUM       1
#define PENTIUMMMX    2
#define PENTIUMPRO    4
#define PENTIUMII     8

// Size defines
#define NOSIZE        0
#define BYTE          1
#define WORD          2
#define LONG          4
#define SHORT         8
#define QUAD         16
#define TERA         32

// Output format defines
#define GAS           0
#define NASM          1

struct protoYYSTYPE {
  unsigned int flag;
  char label[MaxSize];
  unsigned int opcode;
  unsigned int size;
  char src[MaxSize];
  char dest[MaxSize];
};

#define YYSTYPE struct protoYYSTYPE

// Register defines
#define REG32         0
#define REG16         1
#define REG8          2
#define FREG          4
#define MMXREG        8
#define SREG         16
#define NOREG        32

#endif

