#include <unistd.h>  /* for R_OK */
#include <tcl.h>
#include <tk.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include "camltk.h"


/* 
 * Dealing with signals: when a signal handler is defined in Caml,
 * the actual execution of the signal handler upon reception of the
 * signal is delayed until we are sure we are out of the GC.
 * If a signal occurs during the MainLoop, we would have to wait
 *  the next event for the handler to be invoked.
 * The following function will invoke a pending signal handler if any,
 * and we put in on a regular timer.
 */

#define SIGNAL_INTERVAL 300

int signal_events = 0; /* do we have a pending timer */

void invoke_pending_caml_signals (clientdata) 
     ClientData clientdata;
{
  signal_events = 0;
  enter_blocking_section(); /* triggers signal handling */
  /* Rearm timer */
  Tk_CreateTimerHandler(SIGNAL_INTERVAL, invoke_pending_caml_signals, NULL);
  signal_events = 1;
  leave_blocking_section();
}

/* Now the real Tk stuff */

static Tk_Window mainWindow;

#define RCNAME ".camltkrc"
#define CAMLCB "camlcb"

/* Initialisation, based on tkMain.c */
value camltk_opentk(display, name) /* ML */
     value display,name;
{
  /* Create an interpreter, dies if error */
  cltclinterp = Tcl_CreateInterp();
  /* Create the camlcallback command */
  Tcl_CreateCommand(cltclinterp,
		    CAMLCB, CamlCBCmd, 
		    (ClientData)NULL,(Tcl_CmdDeleteProc *)NULL);
  if (Tcl_Init(cltclinterp) != TCL_OK)
    tk_error(cltclinterp->result);
  Tcl_SetVar(cltclinterp, "argv0", name, TCL_GLOBAL_ONLY);
  if (Tk_Init(cltclinterp) != TCL_OK)
    tk_error(cltclinterp->result);

   /* Retrieve the main window */
   mainWindow = Tk_MainWindow(cltclinterp);
   if (NULL == mainWindow)
     tk_error(cltclinterp->result);

   Tk_GeometryRequest(mainWindow,200,200);

  /* This is required by "unknown" and thus autoload */
  Tcl_SetVar(cltclinterp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);
  /* Our hack for implementing break in callbacks */
  Tcl_SetVar(cltclinterp, "BreakBindingsSequence", "0", TCL_GLOBAL_ONLY);

  /* Load the traditional rc file */
  {
    char *home = getenv("HOME");
    if (home != NULL) {
      char *f = stat_alloc(strlen(home)+strlen(RCNAME)+2);
      f[0]='\0';
      strcat(f, home);
      strcat(f, "/");
      strcat(f, RCNAME);
      if (0 == access(f,R_OK)) 
	if (TCL_OK != Tcl_EvalFile(cltclinterp,f)) {
	  stat_free(f);
	  tk_error(cltclinterp->result);
	};
      stat_free(f);
    }
  }

  return Val_unit;
}

