/*
 * file that facilitates C++ program debugging.
 *
 * Copyright 1995 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * NON-COMMERCIAL purpose and without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies, and that the name of Gray Watson not be used in
 * advertising or publicity pertaining to distribution of the document
 * or software without specific, written prior permission.
 *
 * Please see the PERMISSIONS file or contact the author for information
 * about commercial licenses.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@letters.com
 */

/*
 * This file is used to effectively redirect new to the more familiar
 * malloc and delete to the more familiar free so they can be debugged
 * with the debug malloc library..  They also give the known error
 * behavior, too.
 *
 * Compile and link this in with the C++ program you want to debug.
 *
 * NOTE: I am not a C++ hacker so feedback in the form of other hints
 * and ideas for C++ users would be much appreciated.
 */
 
extern "C" {
#include <stdlib.h>
#define DMALLOC_DISABLE
#include "dmalloc.h"
#include "return.h"
}

/*
 * An overload function for the C++ new.
 */
void *
operator new(size_t n)
{
  SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
  return _malloc_leap(_dmalloc_file, _dmalloc_line, n);
}

/*
 * An overload function for the C++ new[].
 */
void *
operator new[](size_t n)
{
  SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
  return _malloc_leap(_dmalloc_file, _dmalloc_line, n);
}

/*
 * An overload function for the C++ delete.
 */
void
operator delete(void *cp)
{
  SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
  _free_leap(_dmalloc_file, _dmalloc_line, cp);
}
