package biss;

import java.util.Enumeration;
import java.util.Vector;

public class QueueTester
{

public static void add ( Queue q, int i ) {
	String s = String.valueOf( (char) (65 + i));
	System.out.println( "------------------ + " + s);
	q.append( s); dump(q);
}

public static void dump ( Queue q ) {
	int i;

	System.out.println( "C: " + q.Capacity + ", R: " + q.Read 
	                    + ", W: " + q.Write + ", S:" + q.size()
		                    + ", e: " + q.IsEmpty);
	for ( i=0; i<q.Capacity; i++ ) {
		Object o = q.Buf[i];
		if ( o == null ) o = "-";
		System.out.print( " " + o);
	}
	System.out.print( "   ");
	enum(q);
}

public static void enum ( Queue q ) {
	System.out.print( "[");
	for ( Enumeration e=q.elements(); e.hasMoreElements(); ){
		System.out.print( e.nextElement() );
		if ( e.hasMoreElements() )
			System.out.print( ",");
		else
			break;
	}
	System.out.println( "]");
}

public static void main ( String args[] ) {
	// testPerformance();
	// testFunction();
	// testExceptions();
	testContains();
}

public static void remove( Queue q) {
	System.out.print( "------------------ - ");
	System.out.println( q.getNext());
	dump(q);
}

public static void testContains () {
	System.out.println( "\n================================ contains");
	Queue q = new Queue(3);
	int i = 0;
	System.out.println( "contains C: " + q.contains( "C"));
	add(q, i++);
	System.out.println( "contains C: " +q.contains( "C"));
	add(q, i++);
	System.out.println( "contains C: " +q.contains( "C"));
	remove(q);
	System.out.println( "contains B: " +q.contains( "B"));
	add(q, i++);
	System.out.println( "contains C: " +q.contains( "C"));
	add(q,i++);
	System.out.println( "contains A: " +q.contains( "A"));
	System.out.println( "contains C: " +q.contains( "C"));
	System.out.println( "contains D: " +q.contains( "D"));
}

public static void testExceptions() {
	System.out.println( "\n================================ exceptions");
	int i=0;

	Queue q = new Queue(3);
	add( q, i++);
	add( q, i++);

	// test NoSuchElementException
	try {
		Object o;
		Enumeration e;
		for ( e=q.elements(), o=e.nextElement();; o=e.nextElement())
			System.out.println(o);
	}
	catch ( Throwable x ) { x.printStackTrace(); }

	// test EmptyQueueException
	try {
		remove( q);
		remove( q);
		remove( q);
	}
	catch ( Throwable x ) { x.printStackTrace(); }

	q = new Queue(2);
	dump( q);
	try {
		q.getNext();
	}
	catch ( Throwable x ) { x.printStackTrace(); }

}

public static void testFunction () {
	System.out.println( "\n================================ functionality");
	int i = 0, j;
	Queue q = new Queue(2);
	add( q, i++); add( q, i++);
	remove(q);
	add( q, i++); add( q, i++);
	remove(q);
	remove(q);
	remove(q);
	//    remove(q);  // exception
	for ( j=0; j<5; j++ ) add( q, i++);
}

public static void testPerformance () {
	System.out.println( "\n============================== performance");

	int j, i=0;
	Queue q;

	q = new Queue( 80);
	long t1, t2;
	for ( j=0; j<5; j++ ) q.append( "Y");
	t1 = System.currentTimeMillis();
	for ( j=0; j<5000; j++ ) {
		q.append( "X");
		q.getNext();
	}
	t2 = System.currentTimeMillis();
	System.out.println( "Queue: " + (t2-t1));

	Vector v = new Vector(80);
	for ( j=0; j<5; j++ ) v.addElement( "Y");
	t1 = System.currentTimeMillis();
	for ( j=0; j<5000; j++ ) {
		v.addElement( "X");
		v.firstElement();
		v.removeElementAt(0);
	}
	t2 = System.currentTimeMillis();
	System.out.println( "Vector: " + (t2-t1));
}
}
