package biss.jde;

import biss.awt.Awt;
import biss.awt.GraphicsLib;
import biss.awt.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.BitSet;

/**
 * helper library providing various draw methods for jde views
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class DrawSupport
  implements Mod
{
	static Image Attr1[];
	static int Cx;
	static int Cy;
	static Font FRegular = Awt.SysFont;
	static Font FSmall = Jde.SmallFont;
	static Font FSmallFix = Jde.SmallFixFont;
	static FontMetrics FmRegular;
	static FontMetrics FmSmall;
	static FontMetrics FmSmallFix;
	static int FwRegular[];
	static int FwSmall[];
	static Toolkit Tk;
	static int YOffset;
	static Font FFixed = Awt.FixedFont;
	static FontMetrics FmFixed;

static {
	Tk = Awt.DefToolkit;

	FmRegular = Tk.getFontMetrics( FRegular);
	FwRegular = FmRegular.getWidths();

	FmSmall   = Tk.getFontMetrics( FSmall);
	FwSmall   = FmSmall.getWidths();

	FmSmallFix = Tk.getFontMetrics( FSmallFix);
	FmFixed = Tk.getFontMetrics( FFixed);

	Cy        = FmRegular.getHeight();
	Cx        = FwRegular['n'];
	YOffset   = Cy - FmRegular.getDescent();

	//    initImages();
}

static void drawAttr1 ( Graphics g, Rectangle r, Color clr, BitSet mods ) {

	int d  = r.height / 2;
	int dd = (r.height - d) / 2; 

	int x = r.x + dd;
	int y = r.y + dd;

	g.setColor( Jde.AccessClr );
	if ( mods.get( STATIC ) ) {
		if ( mods.get( PUBLIC) )
			g.fillRect( x, y, d, d);
		else if ( mods.get( PROTECTED ) )
			g.fillRect( x, y, d, d / 2);
		else if ( mods.get( PRIVATE ) )
			;
		else {
			int px[] = { x, x+d, x,   x };
			int py[] = { y, y,   y+d, y };
			g.fillPolygon( px, py, 4);
		}
		g.setColor( clr);
		g.drawRect( x, y, d, d);
	}
	else {
		if ( mods.get( PUBLIC) )
			g.fillOval( x, y, d, d);
		else if ( mods.get( PROTECTED ) )
			g.fillArc( x, y, d, d, 0, 180);
		else if ( mods.get( PRIVATE ) )
			;
		else {
			g.fillArc( x, y, d, d, 45, 180);
		}
		g.setColor( clr);
		g.drawOval( x, y, d, d );
	}

	drawCommonAddAttrs( g, r, d, dd, mods );
}

static void drawCUFileInfo ( List p, String fileInfo,
                      boolean isExpanded, int nObservers ) {
	Graphics g = p.DrawGraphics;
	Rectangle r = p.DrawRect;

	g.setColor( getLibDrawClr( p, isExpanded, nObservers));
	g.setFont( FSmallFix);
	g.drawString( fileInfo, r.x + 32*Cx, r.y + YOffset);
}

static void drawCULibEntry ( List p, String pckg,
                      String name, int nTypes,
                      boolean isExpanded, int nObservers ) {

	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;

	int       y = r.y + YOffset;

	g.setColor( getLibDrawClr( p, isExpanded, nObservers));
	g.setFont( FRegular);
	g.drawString( name, r.x + 2, y);

	g.setFont( FSmall);
	g.drawString( Integer.toString(nTypes), r.x+21*Cx, y);

	if ( pckg != null )
		g.drawString( pckg, r.x + 23*Cx, y);
}

static void drawCntr ( List p, String id, String head ) { 
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;

	int y = r.y + YOffset;
	int x = r.x + 2;

	g.setColor( p.DrawClrFore);
	g.setFont( FRegular);
	g.drawString( id, x, y);

	if ( head != null ){
		g.setColor( Color.gray);
		g.drawString( head, x, y);
	}
}

static void drawCntrStats ( List p, String s ) {
	Graphics g = p.DrawGraphics;
	Rectangle r = p.DrawRect;

	int x = p.getDrawWidth() - FmSmallFix.stringWidth( s) - 3;
	g.setFont( FSmallFix);
	g.setColor( p.DrawClrFore);
	g.drawString( s, x, r.y + YOffset);
}

static void drawCommonAddAttrs ( Graphics g, Rectangle r, int d, int dd,
                          BitSet mods ) {
	int x, y, y1;

	if ( mods.get( FINAL) ){
		x = r.x + d + dd + 2;
		y = r.y + d + dd - 1;
		g.fillRect( x, y, 3, 3);
	}

	if ( mods.get( SYNCHRONIZED ) ) {
		x = r.x + d + dd + 2;
		y = r.y + dd;
		y1 = y + d/2;
		g.drawLine( x, y, x, y1);
		x += 2;
		g.drawLine( x, y, x, y1);
	}
}

static void drawData ( List p, String type, String name,
                String arrayDim, String initExpr, BitSet mods ){
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;

	int   x = r.x + 6*Cx + Cy;
	int   y = r.y + YOffset;

	drawAttr1( g, r, p.DrawClrFore, mods );

	g.setFont( FSmall);
	drawTypeStr( g, type, x - Cx, y, x - 2*Cy);

	g.setFont( FRegular);
	g.drawString( name, x, y);

	if ( arrayDim != null || initExpr != null ) {
		x += FmRegular.stringWidth( name) + Cx;
		g.setFont( FSmall);

		if ( arrayDim != null ) {
			g.drawString( arrayDim, x, y);
			x += arrayDim.length() * Cx;
		}

		if ( initExpr != null ) {
			g.drawString( "=", x, y);
			x += Cx;
			g.drawString( initExpr, x, y);
		}
	}
}

static void drawFoldedStmt ( List p, String key, String spec,
                      String prologLabel ) {
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;
	Color     clr = p.DrawClrFore;

	int x = r.x + Cx;
	int y = r.y + YOffset;
	int cx = FmFixed.charWidth(' ');

	g.setFont( FFixed);
	g.setColor( Jde.KeywordClr);
	g.drawString( key, x, y);

	g.setColor( p.DrawClrFore);
	g.drawString( spec, x + (cx * (key.length()+1)), y);

	if ( prologLabel != null ) {
		g.setFont( FSmall);
		g.setColor( Jde.CommentClr);
		g.drawString( prologLabel, x + (cx * (key.length()+spec.length()+3)), y);
	}
}

static void drawImport ( List p, String s ) {
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;

	g.setFont( FSmall);
	g.drawString( s, r.x + 2, r.y + YOffset);
}

static void drawLibTypeDecl ( List p, String name,
                       String pckgName, String fname, 
                       BitSet mods, boolean isIF,
                       boolean isExpanded, int nObservers ) {
	Color clr = getLibDrawClr( p, isExpanded, nObservers);
	drawTypeDecl( p, name, mods, isIF, clr);

	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;
	int y = r.y + YOffset;

	g.setColor( clr);
	g.setFont( FSmall );
	if ( pckgName != null )
		g.drawString( pckgName, r.x + 23 * Cx, y);

	g.drawString( fname, r.x + 32*Cx, y);
}

static void drawMethod ( List p, String type, String name,
                  String parm, BitSet mods ){
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;
	Color     clr = p.DrawClrFore;

	int   x = r.x + 6*Cx + Cy;
	int   y = r.y + YOffset;

	Color shapeClr = mods.get(ABSTRACT)? Jde.AbstractClr : p.DrawClrFore;
	drawAttr1( g, r, shapeClr, mods);

	g.setColor( p.DrawClrFore);
	g.setFont( FSmall);
	drawTypeStr( g, type, x - Cx, y, x - 2*Cy);

	if ( mods.get( NATIVE) )
		g.drawString( "c", r.x + 2*Cx, y);

	g.setFont( FRegular);
	g.drawString( name, x, y);

	g.setColor( clr);
	g.setFont( FSmall);
	g.drawString( parm, x + FmRegular.stringWidth( name) + Cx, y);
}

static void drawTypeDecl ( List p, String s, 
                    BitSet mods, boolean isIF, Color textClr ) {
	int x, y, d, dd;
	Rectangle r = p.DrawRect;
	Graphics  g = p.DrawGraphics;

	d  = r.height / 2+ 1;
	dd = r.height / 4;
	y = r.y + dd;
	x = r.x + dd;
	Color shapeClr = mods.get(ABSTRACT)? Jde.AbstractClr : p.DrawClrFore;

	g.setColor( Jde.AccessClr );
	if ( isIF ) {
		int xd2 = x + d/2;
		int yd = y+d;
		int u[] = { xd2, x+d, xd2, x, xd2 };
		int v[] = { y, y, yd, yd, y };
		if ( mods.get( PUBLIC) )
			g.fillPolygon( u, v, 4);
		g.setColor( shapeClr);
		g.drawPolygon( u, v, 5);
	}
	else {
		if ( mods.get( PUBLIC) )
			g.fillRect( x, y, d, d);
		g.setColor( shapeClr);
		g.drawRect( x, y, d, d);
	}

	drawCommonAddAttrs( g, r, d, dd, mods );

	g.setFont( FRegular);
	g.setColor( textClr);
	g.drawString( s, r.x + r.height + dd, r.y + YOffset);        
}

static void drawTypeStr ( Graphics g, String s, int x, int y, int width ) {
	int   w = 0, w1;
	int   i;
	char  a[] = s.toCharArray();


	for ( i=0; i<a.length; i++ ) {
		w1 = w + FwSmall[ a[i]];
		if ( w1 > width ){
			g.drawChars( a, 0, i, x - w, y);
			g.drawString( ".", x, y);
			return;
		}
		else
			w = w1;
	}

	g.drawChars( a, 0, i, x - w, y);
}

static Color getLibDrawClr ( List p, boolean isExpanded, int nObservers ) {
	if ( isExpanded ) {
		if ( p.DrawingSelected )
			return Color.orange;
		else {
			if ( nObservers > 0 )
				return Jde.ActiveCUClr;
			else
				return Jde.CacheCUClr;
		}
	}
	return p.DrawClrFore;
}

static void initImages () {
	Attr1 = new Image [9];
	for ( int j=1; j<=8; j++ )
		Attr1[j] = Tk.getImage( "images/m" + j + ".gif");
}
}
