package biss.awt;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

/**
 * replaces java.awt.MenuItem
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class MenuItem
{
	public static MenuItem Disposer = new MenuItem( ">dispose<");
	final public static int MI_CHECKED = 2;
	final public static int MI_DISABLED = 1;
	String Selector = null;
	public static MenuItem Separator = new MenuItem( "---");
	int State = 0;
	Vector SubItems = null;
	String Text = null;
	Point PMn = null;
	char MnKey = 0;
	static FontMetrics Fm;

static {
	Fm = Awt.getFontMetrics( Awt.MenuFont);
}

public MenuItem( String txt ){
	this( txt, null);
}

public MenuItem( String txt, String sel ){
	Text = txt;
	splitLabel();
	Selector = (sel != null) ? sel : Text;
}

public MenuItem addSubItem( MenuItem mi){
	if ( SubItems == null)
		SubItems = new Vector( 5);
	SubItems.addElement( mi);
	return mi;
}

public MenuItem addSubItem( String txt){
	return addSubItem( txt, null);
}

public MenuItem addSubItem( String txt, String sel) {
	return addSubItem( new MenuItem( txt, sel));
}

public void check(){
	State |= MI_CHECKED;
}

public void disable(){
	State |= MI_DISABLED;
}

void drawAt( Graphics g, int x, int y){
	Color c = isDisabled() ? Awt.InactiveClr : Awt.MenuForeClr;
	g.setColor( c);
	g.drawString( Text, x, y);
	if ( PMn != null)
		g.drawLine( x+PMn.x, y+2, x+PMn.y, y+2);
}

void drawAt( Graphics g, int x, int y, boolean highLight ) {

	if ( highLight ) {
		GraphicsLib.flashText( g, Text, x, y);
	}
	else {
		g.setColor( isDisabled() ? Awt.InactiveClr : Awt.MenuForeClr );
		g.drawString( Text, x, y);
	}

	if ( PMn != null)
		g.drawLine( x+PMn.x, y+2, x+PMn.y, y+2);
}

public void enable(){
	State &= ~MI_DISABLED;
}

public String getSelector(){
	return Selector;
}

public String getText(){
	return Text;
}

public boolean isChecked(){
	return ( (State & MI_CHECKED) != 0);
}

public boolean isDisabled(){
	return ( (State & MI_DISABLED) != 0);
}

public boolean isSeparator(){
	return Separator.equals( this);
}

public void setCheck( boolean state){
	if ( state) check();
	else        uncheck();
}

public void setEnable( boolean state){
	if ( state) enable();
	else        disable();
}

void splitLabel() {
	char mn = '~';
	String rStr;
	int xb, xe, idx = Text.indexOf( mn);

	if ( idx > -1){
		rStr = Text.substring( 0, idx);
		xb = Fm.stringWidth( rStr);
		Text = rStr + Text.substring( idx+1);
		xe = xb + Fm.charWidth( Text.charAt( idx));
		MnKey = Text.charAt( idx);
		PMn = new Point( xb, xe);
	}
}

public int state(){
	return State;
}

public void uncheck(){
	State &= ~MI_CHECKED;
}
}
