package biss.awt;

import biss.CommandQueue;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;

/**
 * horizontal scrollbar ( replaces java.awt.Scrollbar)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class HScrollBar
  extends ScrollBar
{

public HScrollBar () {
	super( 0, 0, 0);
}

public HScrollBar ( int min, int max, int pos) {
	super( min, max, pos);
}

public void mouse1Drag( Event evt) {

	if ( DragOffs > 0)
		setPosition((int)((double)(evt.x - DragOffs - Height) *
	                  Max / ((Width - 2 * Height) - SliderRect.width)));
}

public void mouseDownScroll (Event evt) {

	if ( SliderRect.inside( evt.x, evt.y)){
		DragOffs = evt.x - SliderRect.x;
		ScrollOp = 5;
	}
	else if ( (evt.x < Height) && (Pos > Min) ){
		ScrollOp = 1;
		LoopDir = 1;
		redrawSpins();
		Delay = true;
		CommandQueue.append( this);
	}
	else if ( (evt.x > Width - Height) && (Pos < Max) ){
		ScrollOp = 2;
		LoopDir = 2;
		redrawSpins();
		Delay = true;
		CommandQueue.append( this);
	}
	else if ( evt.x < SliderRect.x)
		ScrollOp = 3;
	else if ( evt.x > SliderRect.x + SliderRect.width)
		ScrollOp = 4;

}

public Dimension preferredSize(){
	return new Dimension( 10*Awt.SysFontWidth, Awt.SysFontHeight);
}

protected void redrawSlider( Graphics g) {
	if ( Width <= 0 )
		return;

	int b = FBorder.Ext;
	int h = Height - b;
	int w = Width - 2*h;

	if ( (SliderRect.width > 0) && (SliderRect.width < w) ) {
		g.setColor( getBackground());
		int x, d = SliderRect.x - h;
		int hh = h-b;
		if ( d > 0 )
			g.fillRect( h, b, d, hh);
		x = SliderRect.x + SliderRect.width;
		d = Width - h - x;
		if ( d > 0 )
			g.fillRect( x, b, d, hh);

		GraphicsLib.paint3dBox( g, SliderRect.x, SliderRect.y,
		                        SliderRect.width, SliderRect.height,
		                        false, Awt.ButtonBackClr);
	}
	else {
		g.setColor( getBackground() );
		g.fillRect( h, b, w, h-b);
	}
}

protected void redrawSpins( Graphics g) {
	int b = FBorder.Ext;
	int h = Height - 2*b;

	if ( ScrollOp == 1 )
		GraphicsLib.paintButton( g, b, b, h, h, false, Awt.ButtonBackClr);
	else
		GraphicsLib.paint3dBox( g, b, b, h, h, false, Awt.ButtonBackClr);

	if ( ScrollOp == 2 )
		GraphicsLib.paintButton( g, Width-b-h, b, h, h, false, Awt.ButtonBackClr);
	else
		GraphicsLib.paint3dBox( g, Width-b-h, b, h, h, false, Awt.ButtonBackClr);
}

protected void updatePageInc() {
	if ( AutoPageInc)
		PageInc = Width / StepPels;
}

protected void updateSliderPos() {
	int h = Height - FBorder.Ext;

	SliderRect.x = (int)(((double)Pos / Max) *
	                     ( (Width - 2*h) - SliderRect.width)) + h;
}

protected void updateSliderRect() {
	int b = FBorder.Ext;
	int h = Height - b;
	int tl = Width - 2*h;
	int bl, sPos;

	bl = Math.max( h, (int)(((double)(PageInc + 1) * tl / (Max - Min + 1))));
	if ( bl < tl) {
		sPos = (int)(((double)Pos / Max) * ( tl - bl)) + h;
		SliderRect.reshape ( sPos, b, bl, h-b);
	}
	else
		SliderRect.reshape( 0, 0, 0, 0);
}
}
