package biss.awt;

import biss.CommandQueue;
import java.awt.Component;
import java.awt.Insets;

/**
 * window-modal dialog base. Modal behavior is implemented
 * just with respect to the user interface, not with respect to
 * method execution (i.e. the function creating a "modal" dialog
 * will not be suspended until the created object dies). The (owner)
 * window which utilizes the dialog will be disabled until the
 * dialog is closed. Each time the owner is brought to top, the
 * dialog will be brought to top too (overlaying its owner).
 * This "modal" behavior is much more robust than suspending
 * the caller (it does not stop painting etc.). Suspending the
 * caller always means a recursive downstep of the event dispatcher loop
 * of the GUI system (X11, presentation manager etc.) which always
 * puts it into some kind of an inconsistent state.
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
abstract public class DialogWindow
  extends TopWindow
{
	Object ContextData = null;
	boolean WasCanceled = true;
	TopWindow Owner = null;
	Layouter Lo = new Layouter( this);

public DialogWindow( String title, TopWindow owner) {
	super( title);

	if ( owner != null){
		Owner = owner;
		Owner.setOverlay( this);
	}
}

public void dispose(){
	resetOwner();
	super.dispose();
}

public Object getContextData() {
	return ContextData;
}

public void openCentered () {
	if ( isShowing() )
		return;

	if ( tbHeight() == 0)
		pack();

	centerToScreen();
	show();
}

void packClient ( int cx, int cy) {
	if ( isShowing() )
		return;
	pack();
	Insets is = insets();
	resize( cx + is.left + is.right, cy + is.top + is.bottom );
}

void packClientDlgUnits ( int cx, int cy) {
	packClient( (cx*Awt.DlgXUnit+5)/10, (cy*Awt.DlgYUnit+5)/10);
}

public void process () {
	WasCanceled = false;
	dispose();
}

void resetOwner () {
	if ( Owner != null ) {
		Owner.resetOverlay();
		Owner.restoreFocus();
		Owner = null;
	}
}

public void setContextData( Object obj) {
	ContextData = obj;
}

public void toFront() {

	// DialogWindows floating to top should auomatically get
	// the focus (which is forwarded to the DefComponent by the TopWindow.gotFocus())

	if ( EventHandler.SingleInstWnd == null) {
		super.toFront();

		if ( ActiveTopWindow != this  )
			requestFocus();
	}
}

public boolean wasCanceled () {
	return WasCanceled;
}
}
