package biss;

import java.io.File;

public class Biss
{
	public static PackageProperties Values = new PackageProperties( "biss");
/**
 * Either "american" or "german". Specifies the language to use
 * (e.g. for StringDicts)
 */
	public static String Language;
/**
 * This is a global variable to store paths where applications
 * should look for ressources (e.g. image files, data files etc.)
 */
	public static String[] EnvPaths;

/**
 * package property class for package biss
 * currently provides some information to support internationalization
 * and global file lookup
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
static {
	Language = Values.getString( "Language", "american");
	EnvPaths = Values.getPaths( "EnvPaths", ".");
}

public static File getEnvFile (String filename) {
	File gf = new File( filename);
	if ( gf.exists() )    
		return gf;

	for ( int i=0; i<EnvPaths.length; i++){
		gf = new File( EnvPaths[i] + File.separator + filename);
		if ( gf.exists() )
			return gf;
	}
	return null;
}

public static void insertEnvPath ( String pathName) {
	String[] np = new String[ EnvPaths.length + 1];
	np[0] = pathName;
	for ( int idx = 1; idx < np.length; idx++)
		np[idx] = EnvPaths[idx - 1];
	EnvPaths = np;
}

public static void insertEnvPaths ( String[] pathNames) {
	int nl      = EnvPaths.length + pathNames.length;
	int idx     = 0;
	String[] np = new String[ nl];

	for ( ; idx < pathNames.length; idx++)
		np[idx] = pathNames[idx];
	for ( ; idx < nl; idx++)
		np[idx] = EnvPaths[idx - pathNames.length];

	EnvPaths = np;
}

public static boolean langAmerican() {
	return Language.equals( "american");
}

public static boolean langGerman() {
	return Language.equals( "german");
}
}
