/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/tools/if_not_there.c                 */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Aug  8 08:43:47 1995                          */
/*    Last change :  Tue Aug  8 09:25:37 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Execute a command line a file doesn't exist (used in             */
/*    conjunction with `if_mach').                                     */
/*=====================================================================*/
#include <stdio.h>

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    usage ...                                                        */
/*---------------------------------------------------------------------*/
void
usage()
{
   puts( "usage: if_not_there <file> <command>" );
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    main ...                                                         */
/*---------------------------------------------------------------------*/
int
main( int argc, char **argv )
{
   FILE * f;
   
   if( argc < 3 )
   {
      usage();
      exit( -1 );
   }
   else
   {
      if( (f = fopen( argv[ 1 ], "rb" )) || (f = fopen( argv[ 1 ], "r" )) )
      {
         fclose( f );
	 exit( 0 );
      }
      else
      {
	 execvp( argv[ 2 ], argv + 2 );
         exit( 0 );
      }
   }
}

