;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime/Rgc/grammar.scm              */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr  3 15:50:20 1992                          */
;*    Last change :  Sat Feb 14 08:59:05 1998 (serrano)                */
;*                                                                     */
;*    La compilation des automates                                     */
;*---------------------------------------------------------------------*/
  
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __rgc_grammar

   (import  (__error                   "Llib/error.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__rgc_trap                "Rgc/trap.scm")
	    (__rgc_automata            "Rgc/automata.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (build-regular-grammar ns ua tt)))

;*---------------------------------------------------------------------*/
;*    build-regular-grammar ...                                        */
;*    (int x states) x sexp x vector --> lambda                        */
;*---------------------------------------------------------------------*/
(define (build-regular-grammar nb-states.states usr-action* t-trap)
   (let ((nb-states  (car nb-states.states))
	 (states     (cdr nb-states.states))
	 (nb-actions (length usr-action*)))
      (pre-trap t-trap)
      `(let ((current-context 0))
	  (lambda (input-port)
	     (labels ((context new-context
			       (set! current-context
				     (if (null? new-context)
					 '()
					 (car new-context))))
		      (the-fixnum () (input-port-get-fixnum input-port))
		      (the-flonum () (input-port-get-flonum input-port))
		      (the-length () (input-port-get-length input-port))
		      (the-string () (input-port-get-string input-port))
		      (the-small-string () (input-port-get-small-string
					    input-port))
		      (the-symbol () (input-port-get-symbol input-port))
		      (the-keyword () (input-port-get-keyword input-port))
		      (the-failing-char ()
					(input-port-steal-char input-port))
		      (automata (rule)
				,(build-automata nb-states states t-trap))
		      (ignore ()
			      (input-port-reset-annexe! input-port)
			      (let ((rule (automata 0)))
				 (input-port-ajust-cursor input-port)
				 (case rule
				    ,@(let loop ((indice  (-fx nb-actions 1))
						 (action* (cdr usr-action*)))
					 (if (null? action*)
					     '()
					     (cons
					      `((,indice)
						,(car action*))
					      (loop (-fx indice 1)
						    (cdr action*)))))
				    (else
				     (if (input-port-token-too-large?
					  input-port)
					 (error "regular-grammar"
						"token too large"
						(unspecified)))
				     ,(car usr-action*))))))
		(ignore))))))
	      


