;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/R5rs/usual5.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  William Clinger                                   */
;*    Creation    :  Sat Mar 21 17:25:41 1998                          */
;*    Last change :  Mon Mar 23 08:38:06 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*  The usual macros, adapted from Jonathan's Version 2 implementation.*/
;*  DEFINE is handled primitively, since top-level DEFINE has a side   */
;*  effect on the global syntactic environment, and internal           */
;*  definitions have to be handled specially anyway.                   */
;*                                                                     */
;*  The LETREC* scope rule is used here to protect these macros against*/
;*  redefinition of LAMBDA etc.  The scope rule is changed to LETREC at*/
;*  the end of this file.                                              */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r5_syntax_usual
   
   (use    (__type                       "Llib/type.scm")
           (__error                      "Llib/error.scm")
           (__bigloo                     "Llib/bigloo.scm")
           (__tvector                    "Llib/tvector.scm")
           (__structure                  "Llib/struct.scm")
           (__tvector                    "Llib/tvector.scm")
           (__bexit                      "Llib/bexit.scm")
            
           (__reader                     "Read/reader.scm")

           (__rgc                        "Rgc/runtime.scm")
            
           (__r4_numbers_6_5             "Ieee/number.scm")
           (__r4_numbers_6_5_fixnum      "Ieee/fixnum.scm")
           (__r4_numbers_6_5_flonum      "Ieee/flonum.scm")
           (__r4_characters_6_6          "Ieee/char.scm")
           (__r4_equivalence_6_2         "Ieee/equiv.scm")
           (__r4_booleans_6_1            "Ieee/boolean.scm")
           (__r4_symbols_6_4             "Ieee/symbol.scm")
           (__r4_strings_6_7             "Ieee/string.scm")
           (__r4_pairs_and_lists_6_3     "Ieee/pair-list.scm")
           (__r4_input_6_10_2            "Ieee/input.scm")
           (__r4_control_features_6_9    "Ieee/control.scm")
           (__r4_vectors_6_8             "Ieee/vector.scm")
           (__r4_ports_6_10_1            "Ieee/port.scm")
           (__r4_output_6_10_3           "Ieee/output.scm")
   
	   (__r5_syntax_expand           "R5rs/expand5.scm"))

   (export (initialize-usual-syntax!)))

;*---------------------------------------------------------------------*/
;*    initialize-usual-syntax! ...                                     */
;*---------------------------------------------------------------------*/
(define (initialize-usual-syntax!)
   (define-syntax-scope 'letrec*)

   (let* ((p (open-input-string
"(

(define-syntax let
  (syntax-rules ()
    ((let ((?name ?val) ...) ?body ?body1 ...)
     ((lambda (?name ...) ?body ?body1 ...) ?val ...))
    ((let ?tag ((?name ?val) ...) ?body ?body1 ...)
     ((letrec ((?tag (lambda (?name ...) ?body ?body1 ...)))
        ?tag)
      ?val ...))))

(define-syntax let*
  (syntax-rules ()
    ((let* () ?body ?body1 ...)
     (let () ?body ?body1 ...))
    ((let* ((?name1 ?val1) (?name ?val) ...) ?body ?body1 ...)
     (let ((?name1 ?val1)) (let* ((?name ?val) ...) ?body ?body1 ...)))
    ((let* ?tag ((?name ?val) ...) ?body ?body1 ...)
     ((letrec ((?tag (lambda (?name ...) ?body ?body1 ...)))
        ?tag)
      ?val ...))))

(define-syntax letrec
  (syntax-rules ()
    ((letrec ((?name ?val) ...) ?body ?body2 ...)
     (let ((?name '*) ...)
       (set! ?name ?val)
       ...
       ?body ?body2 ...))))

(define-syntax and
  (syntax-rules ()
    ((and) #t)
    ((and ?e) ?e)
    ((and ?e1 ?e2 ?e3 ...)
     (if ?e1 (and ?e2 ?e3 ...) #f))))

(define-syntax or
  (syntax-rules ()
    ((or) #f)
    ((or ?e) ?e)
    ((or ?e1 ?e2 ?e3 ...)
     (let ((temp ?e1))
       (if temp temp (or ?e2 ?e3 ...))))))

(define-syntax cond
  (syntax-rules (else =>)
    ((cond (else ?result ?result2 ...))
     (begin ?result ?result2 ...))
    
    ((cond (?test => ?result))
     (let ((temp ?test))
       (if temp (?result temp))))
    
    ((cond (?test)) ?test)
    
    ((cond (?test ?result ?result2 ...))
     (if ?test (begin ?result ?result2 ...)))
    
    ((cond (?test => ?result) ?clause ?clause2 ...)
     (let ((temp ?test))
       (if temp (?result temp) (cond ?clause ?clause2 ...))))
    
    ((cond (?test) ?clause ?clause2 ...)
     (or ?test (cond ?clause ?clause2 ...)))
    
    ((cond (?test ?result ?result2 ...)
           ?clause ?clause2 ...)
     (if ?test
         (begin ?result ?result2 ...)
         (cond ?clause ?clause2 ...)))))

(define-syntax do
  (syntax-rules ()
    ((do (?bindings0 ...) ?clause0 ?body0 ...)
     (letrec-syntax
       ((do-aux
         (___ (syntax-rules ()
                ((do-aux () ((?name ?init ?step) ...) ?clause ?body ...)
                 (letrec ((loop (lambda (?name ...)
                                  (cond ?clause
                                        (else
                                         (begin ?body ...)
                                         (loop ?step ...))))))
                   (loop ?init ...)))
                ((do-aux ((?name ?init ?step) ?todo ...)
                         (?bindings ...)
                         ?clause
                         ?body ...)
                 (do-aux (?todo ...)
                         (?bindings ... (?name ?init ?step))
                         ?clause
                         ?body ...))
                ((do-aux ((?name ?init) ?todo ...)
                         (?bindings ...)
                         ?clause
                         ?body ...)
                 (do-aux (?todo ...)
                         (?bindings ... (?name ?init ?name))
                         ?clause
                         ?body ...))))))
       (do-aux (?bindings0 ...) () ?clause0 ?body0 ...)))))

(define-syntax delay
  (syntax-rules ()
    ((delay ?e) (make-promise (lambda () ?e)))))

(define-syntax case
  (syntax-rules (else)
    ((case ?e1 (else ?body ?body2 ...))
     (begin ?e1 ?body ?body2 ...))
    ((case ?e1 (?z ?body ?body2 ...))
     (if (memv ?e1 '?z) (begin ?body ?body2 ...)))
    ((case ?e1 ?clause1 ?clause2 ?clause3 ...)
     (letrec-syntax
       ((case-aux
          (___ (syntax-rules ()
                ((case-aux ?temp (else ?body ?body2 ...))
                 (begin ?body ?body2 ...))
                ((case-aux ?temp (?z ?body ?body2 ...))
                 (if (memv ?temp '?z) (begin ?body ?body2 ...)))
                ((case-aux ?temp (?z ?body ?body2 ...) ?c1 ?c2 ...)
                 (if (memv ?temp '?z)
                     (begin ?body ?body2 ...)
                     (case-aux ?temp ?c1 ?c2 ...)))))))
       (let ((temp ?e1))
         (case-aux temp ?clause1 ?clause2 ?clause3 ...))))))

(begin
 
 (define-syntax finalize-quasiquote letrec
   (syntax-rules (quote unquote unquote-splicing)
    ((finalize-quasiquote quote ?arg ?return)
     (interpret-continuation ?return (quote ?arg)))
    ((finalize-quasiquote unquote ?arg ?return)
     (interpret-continuation ?return ?arg))
    ((finalize-quasiquote unquote-splicing ?arg ?return)
     (syntax-error \",@ in illegal context\" ?arg))
    ((finalize-quasiquote ?mode ?arg ?return)
     (interpret-continuation ?return (?mode . ?arg)))))
 
 (define-syntax descend-quasiquote letrec
   (syntax-rules (quasiquote unquote unquote-splicing)
    ((descend-quasiquote `?y ?x ?level ?return)
     (descend-quasiquote-pair ?x ?x (?level) ?return))
    ((descend-quasiquote ,?y ?x () ?return)
     (interpret-continuation ?return unquote ?y))
    ((descend-quasiquote ,?y ?x (?level) ?return)
     (descend-quasiquote-pair ?x ?x ?level ?return))
    ((descend-quasiquote ,@?y ?x () ?return)
     (interpret-continuation ?return unquote-splicing ?y))
    ((descend-quasiquote ,@?y ?x (?level) ?return)
     (descend-quasiquote-pair ?x ?x ?level ?return))
    ((descend-quasiquote (?y . ?z) ?x ?level ?return)
     (descend-quasiquote-pair ?x ?x ?level ?return))
    ((descend-quasiquote #(?y ...) ?x ?level ?return)
     (descend-quasiquote-vector ?x ?x ?level ?return))
    ((descend-quasiquote ?y ?x ?level ?return)
     (interpret-continuation ?return quote ?x))))
 
 (define-syntax descend-quasiquote-pair letrec
   (syntax-rules (quote unquote unquote-splicing)
    ((descend-quasiquote-pair (?carx . ?cdrx) ?x ?level ?return)
     (descend-quasiquote ?carx ?carx ?level (1 ?cdrx ?x ?level ?return)))))
 
 (define-syntax descend-quasiquote-vector letrec
   (syntax-rules (quote)
    ((descend-quasiquote-vector #(?y ...) ?x ?level ?return)
     (descend-quasiquote (?y ...) (?y ...) ?level (6 ?x ?return)))))
 
 (define-syntax interpret-continuation letrec
   (syntax-rules (quote unquote unquote-splicing)
    ((interpret-continuation (-1) ?e) ?e)
    ((interpret-continuation (0) ?mode ?arg)
     (finalize-quasiquote ?mode ?arg (-1)))    
    ((interpret-continuation (1 ?cdrx ?x ?level ?return) ?car-mode ?car-arg)
     (descend-quasiquote ?cdrx
                         ?cdrx
                         ?level
                         (2 ?car-mode ?car-arg ?x ?return)))    
    ((interpret-continuation (2 quote ?car-arg ?x ?return) quote ?cdr-arg)
     (interpret-continuation ?return quote ?x))    
    ((interpret-continuation (2 unquote-splicing ?car-arg ?x ?return) quote ())
     (interpret-continuation ?return unquote ?car-arg))
    ((interpret-continuation (2 unquote-splicing ?car-arg ?x ?return)
                             ?cdr-mode ?cdr-arg)
     (finalize-quasiquote ?cdr-mode ?cdr-arg (3 ?car-arg ?return)))  
    ((interpret-continuation (2 ?car-mode ?car-arg ?x ?return)
                             ?cdr-mode ?cdr-arg)
     (finalize-quasiquote ?car-mode ?car-arg (4 ?cdr-mode ?cdr-arg ?return)))
      
    ((interpret-continuation (3 ?car-arg ?return) ?e)
     (interpret-continuation ?return append (?car-arg ?e)))
    ((interpret-continuation (4 ?cdr-mode ?cdr-arg ?return) ?e1)
     (finalize-quasiquote ?cdr-mode ?cdr-arg (5 ?e1 ?return)))
    ((interpret-continuation (5 ?e1 ?return) ?e2)
     (interpret-continuation ?return cons (?e1 ?e2)))
    ((interpret-continuation (6 ?x ?return) quote ?arg)
     (interpret-continuation ?return quote ?x))
    ((interpret-continuation (6 ?x ?return) ?mode ?arg)
     (finalize-quasiquote ?mode ?arg (7 ?return)))
    ((interpret-continuation (7 ?return) ?e)
     (interpret-continuation ?return list->vector (?e)))))
 
 (define-syntax quasiquote letrec
   (syntax-rules ()
    ((quasiquote ?x)
     (descend-quasiquote ?x ?x () (0)))))
 )

(define-syntax let*-syntax
  (syntax-rules ()
    ((let*-syntax () ?body)
     (let-syntax () ?body))
    ((let*-syntax ((?name1 ?val1) (?name ?val) ...) ?body)
     (let-syntax ((?name1 ?val1)) (let*-syntax ((?name ?val) ...) ?body)))))

            )"))
      (l (read p)))
   (close-input-port p)
   (for-each (lambda (form)
                (internal-expand-syntax form))
             l))

(define-syntax-scope 'letrec))
