;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/expand.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov  3 09:57:39 1994                          */
;*    Last change :  Sat Feb 28 18:23:42 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    La macro expansion de l'interprete                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expand
   
   (import  (__type                    "Llib/type.scm")
	    (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    (__os                      "Llib/os.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")

	    (__evenv                   "Eval/evenv.scm")
	    (__macro                   "Eval/macro.scm"))

   (export  (expand      <expression>)
	    (expand-once <expression>)))

;*---------------------------------------------------------------------*/
;*    expand ...                                                       */
;*---------------------------------------------------------------------*/
(define (expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    expand-once ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-eval-expander*)
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let ((id (car (parse-formal-ident (car x)))))
		    (let ((b (get-eval-expander id)))
		       (if b
			   b
			   *application-eval-expander*))))
		(else
		 *application-eval-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    *identifier-eval-expander* ...                                   */
;*---------------------------------------------------------------------*/
(define (*identifier-eval-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-eval-expander* ...                                  */
;*---------------------------------------------------------------------*/
(define (*application-eval-expander* x e)
   (let loop ((x x))
      (cond
	 ((null? x)
	  '())
	 ((not (pair? x))
	  (error "application" "Illegal form" x))
	 (else
	  (cons (e (car x) e) (loop (cdr x)))))))

;*---------------------------------------------------------------------*/
;*    parse-formal-ident ...                                           */
;*---------------------------------------------------------------------*/
(define (parse-formal-ident ident)
   (let* ((string (symbol->string ident))
	  (len    (string-length string)))
      (let loop ((walker     0)
		 (id-stop    0)
		 (type-start 0))
	 (cond
	    ((=fx walker len)
	     (cond
		((and (=fx id-stop 0)
		      (>fx type-start 0))
		 ;; this empty name variable can be usefull to declare
		 ;; prototype so it is legal.
		 (cons (string->symbol "")
		       (string->symbol (substring string type-start len))))
		((=fx id-stop 0)
		 (cons ident '()))
		((=fx type-start len)
		 ;; empty type are eroneous
		 (error #f "Illegal formal identifier" ident))
		(else
		 (cons (string->symbol
			(substring string 0 id-stop))
		       (string->symbol
			(substring string type-start len))))))
	    ((and (char=? (string-ref string walker) #\:)
		  (<fx walker (-fx len 1))
		  (char=? (string-ref string (+fx walker 1)) #\:))
	     (if (>fx type-start 0)
		 (error #f "Illegal formal identifier" ident)
		 (loop (+fx walker 2)
		       walker
		       (+fx walker 2))))
	    (else
	     (loop (+fx walker 1)
		   id-stop
		   type-start))))))
