/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/foreign.c            */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 19 08:45:22 1993                          */
/*    Last change :  Thu Jul 18 12:00:08 1996 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion de l'interface etrangere                              */
/*=====================================================================*/
#include <bigloo1.9c.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    cobj_to_foreign ...                                              */
/*---------------------------------------------------------------------*/
obj_t
cobj_to_foreign( id, cobj )
obj_t          id;
unsigned long  cobj;
{
   obj_t handle;

   handle = GC_MALLOC( FOREIGN_SIZE );
   
   handle->foreign_t.header = MAKE_HEADER( FOREIGN_TYPE, FOREIGN_SIZE );
   handle->foreign_t.cobj   = (void *)cobj;
   handle->foreign_t.id     = id;

   return BREF( handle );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    obj_to_cobj ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
obj_to_cobj( obj )
obj_t obj;
{
   if( INTEGERP( obj ) )
      return (obj_t)CINT( obj );
   if( BOOLEANP( obj ) )
      return (obj_t)((long)CBOOL( obj ));
   if( STRINGP( obj ) )
      return (obj_t)BSTRING_TO_STRING( obj );
   if( CHARP( obj ) )
      return (obj_t)((long)CCHAR( obj ));
   if( FOREIGNP( obj ) )
      return (obj_t)FOREIGN_TO_COBJ( obj );
   if( REALP( obj ) )
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Can't cast a real to foreign" ),
			  obj);
   else
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Illegal object type" ),
			  obj);
}
 
