;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;<font size="-3"><pre>
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Roman/roman.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Tue Dec 22 08:44:51 1992                          */
;*    Last change :  Thu Mar  6 09:32:12 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Reading and computing on Roman numbers                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module roman (main main))

;*---------------------------------------------------------------------*/
;*    roman->arabic ...                                                */
;*---------------------------------------------------------------------*/
(define (roman->arabic r)
   (define (chiffre.roman->arabic chiffre)
      (case chiffre
	 ((#\m #\M) 1000)
	 ((#\d #\D) 500)
	 ((#\c #\C) 100)
	 ((#\l #\L) 50)
	 ((#\x #\X) 10)
	 ((#\v #\V) 5)
	 ((#\i #\I) 1)
	 (else
	  (error "chiffre" "Illegal char" chiffre))))
   (let ((len (string-length r)))
      (let loop ((indice 0))
      (cond
	 ((= indice len)
	  0)
	 ((= indice (- len 1))
	  (chiffre.roman->arabic (string-ref r indice)))
	 (else
	  (let ((x (chiffre.roman->arabic (string-ref r indice)))
		(y (chiffre.roman->arabic (string-ref r (+ 1 indice)))))
	     (if (< x y)
		 (+ (- x) (loop (+ 1 indice)))
		 (+ x (loop (+ 1 indice))))))))))

;*---------------------------------------------------------------------*/
;*    grammar-roman ...                                                */
;*---------------------------------------------------------------------*/
(define grammar-roman
   (let ((par-open 0))
      (regular-grammar ((arabic  (>-< #\0 #\9))
			(roman (in #\i #\I #\v #\V #\x #\X #\l #\L
				    #\c #\C #\d #\D #\m #\M)))
	 ((+ (in #\space #\newline #\tab))
	  (ignore))
	 ((+ arabic)
	  (string->integer (the-string)))
	 ((+ roman)
	  (roman->arabic (the-string)))
	 ((#\()
	  (let ((open-key par-open))
	     (set! par-open (+ 1 par-open))
	     (context 'pair)
	     (let loop-pair ((walk (ignore))) 
		(cond
		   ((= open-key par-open)
		    '())
		   (else
		    (cons walk (loop-pair (ignore))))))))
	 ((#\))
	  (set! par-open (- par-open 1))
	  (if (< par-open 0)
	      (begin
		 (set! par-open 0)
		 (ignore))
	      #f))
	 ((in #\+ #\- #\* #\\)
	  (string->symbol (the-string)))
	 (else
	  (let ((char (the-failing-char)))
	     (if (eof-object? char)
		 char
		 (error "grammar-roman" "Illegal char" char)))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((prompt ":-) "))
      (display prompt)
      (let loop ((exp (read/rp grammar-roman (current-input-port))))
	 (if (eof-object? exp)
	     'done
	     (begin
		(display* (eval exp) #\Newline prompt)
		(loop (read/rp grammar-roman (current-input-port))))))))
;</pre></font>
