;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;<font size="-3"><pre>
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Process/process.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  SERRANO Manuel                                    */
;*    Creation    :  Thu Mar  6 09:57:09 1997                          */
;*    Last change :  Thu Mar  6 10:06:04 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Forking and waiting Unix processes                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module sys-example
   (extern (include "sys/types.h")
	   (include "wait.h")
	   (include "unistd.h")
	   (type pid int "pid_t")
	   (type int* (pointer int) "int *")

	   (macro sleep::uint (uint) "sleep")
	   (macro wait::pid (int*) "wait")
	   (macro fork::pid () "fork")))

;*---------------------------------------------------------------------*/
;*    fib ...                                                          */
;*---------------------------------------------------------------------*/
(define (fib x)
   (if (< x 2)
       1
       (+fx (fib (-fx x 1)) (fib (-fx x 2)))))
 
;*---------------------------------------------------------------------*/
;*    A top-level form                                                 */
;*---------------------------------------------------------------------*/
(let ((pid (fork)))
   (if (= pid 0)
       ;; the child process
       (begin
	  (print "child process, started...")
	  (sleep 5)
	  (print "child done."))
       ;; the parent process
       (begin
	  (print "parent process, waiting...")
	  (let ((res (fib 30)))
	     (let* ((status::int* (make-int* 0))
		    (pid::pid (wait status)))
		(if (< pid 0)
		    (error "***ERROR: "
			   "Illegal process termination"
			   pid)
		    (print "parent: " res)))))))
;</pre></font>

