;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Foreign/cptr.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun  6 12:23:13 1996                          */
;*    Last change :  Thu Apr  3 14:18:49 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C ptr accessors creations                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module foreign_cpointer
   (include "Tools/trace.sch")
   (import  type_tools
	    type_type
	    tools_shape
	    tools_misc
	    foreign_ctype
	    foreign_access
	    module_module))
   
;*---------------------------------------------------------------------*/
;*    make-ctype-accesses! ::cptr ...                                  */
;*---------------------------------------------------------------------*/
(define-method (make-ctype-accesses! what::cptr who::type)
   (trace (expand 3) "make-ctype-accesses(cptr): " (shape what) " " (shape who)
	  #\Newline)
   (let* ((btype                (cptr-btype what))
	  (id                   (type-id who))
	  (wid                  (type-id what))
	  (bid                  (type-id btype))
	  (id->bid              (symbol-append id '-> bid))
	  (bid->id              (symbol-append bid '-> id))
	  (bid?                 (symbol-append id '?))
	  (bid?-bool            (symbol-append bid? '::bool))
	  (name                 (type-name who))
	  (name-sans-$          (string-sans-$ name))
	  (point-to             (cptr-point-to what))
	  (point-to-id          (type-id point-to))
	  (point-to-name        (type-name point-to))
	  (point-to-name-sans-$ (string-sans-$ point-to-name)))
      
      ;; the two conversion allocation fonctions (they are not
      ;; simple coercion because the first one allocate and the
      ;; second one destructurate).
      (define (mk-id->bid)
	 `(macro ,bid ,id->bid (symbol ,id) "cobj_to_foreign"))

      (define (mk-bid->id)
	 (let ((mname (string-append "(" name-sans-$ ")FOREIGN_TO_COBJ")))
	    `(macro ,id ,bid->id (,bid) ,mname)))

      ;; the predicate
      (define (mk-bid?)
	 `(define-inline (,bid?-bool o::obj)
	     (if (foreign? o)
		 (eq? (foreign-id o) ',bid)
		 #f)))

      ;; equality (using ==)
      (define (mk-=id)
	 `(define-inline (,(symbol-append '= id '::bool)
			  ,(symbol-append 'o1 4dots id)
			  ,(symbol-append 'o2 4dots id))
	     (pragma::bool "($1 == $2)" o1 o2)))

      ;; null-test
      (define (mk-id-null?)
	 `(define-inline (,(symbol-append id '-null?::bool)
			  ,(symbol-append 'o 4dots id))
	     (pragma::bool
	      ,(string-append "($1 == (" name-sans-$ ")0L)") o)))
      
      ;; the user allocation form without initialization
      (define (make-make-id)
	 (define (make-cptr-make-id)
	    `(define-inline (,(symbol-append 'make- id 4dots id) len::long)
		(,(symbol-append 'pragma 4dots id)
		 ,(string-append "(" name-sans-$ ")GC_MALLOC( "
				 "sizeof( " point-to-name-sans-$ " )"
				 " * $1 )")
		 len)))
	 (define (make-carray-make-id)
	    `(define-inline (,(symbol-append 'make- id 4dots id))
		(,(symbol-append 'pragma 4dots id)
		 ,(string-append "(" name-sans-$ ")GC_MALLOC( "
				 "sizeof( " (type-size who) " ))"))))
	 (if (or (and (cptr-array? what) (eq? who what))
		 (and (calias? who) (calias-array? who)))
	     (make-carray-make-id) 
	     (make-cptr-make-id)))

      ;; the getter and setter
      (define (getter-&-setter)
	 (let ((ref-id      (symbol-append id '-ref))
	       (set-id      (symbol-append id '-set!))
	       (ref-type-id (if (cstruct? point-to)
				(symbol-append point-to-id '*)
				point-to-id))
	       (ref-fmt     (if (cstruct? point-to)
				(string-append "&(((" name-sans-$
					       ")($1))[ $2 ])")
				(string-append "((" name-sans-$
					       ")($1))[ $2 ]")))
	       (set-fmt     (if (cstruct? point-to)
				(string-append
				 "(((" name-sans-$
				 ")($1))[ $2 ] = *($3), BUNSPEC)")
				(string-append
				 "(((" name-sans-$
				 ")($1))[ $2 ] = $3, BUNSPEC)"))))
	    (list
	     `(define-inline (,(symbol-append ref-id 4dots ref-type-id)
			      ,(symbol-append 'o 4dots id)
			      i::long)
		 (,(symbol-append 'pragma 4dots ref-type-id)
		  ,ref-fmt
		  o
		  i))
	     `(define-inline (,(symbol-append set-id '::obj)
			      ,(symbol-append 'o 4dots id)
			      i::long
			      ,(symbol-append 'v 4dots ref-type-id))
		 (pragma
		  ,set-fmt
		  o
		  i
		  v)))))
      
      ;; we declare the coercion operations ...
      (produce-module-clause! `(foreign ,(mk-id->bid) ,(mk-bid->id)))
      ;; and the predicate
      (produce-module-clause! `(static (inline ,bid?-bool ::obj)))
      (produce-module-clause! `(pragma (,bid? (predicate-of ,wid))))
      
      (cons* (make-make-id)
	     (mk-=id)
	     (mk-id-null?)
	     (mk-bid?)
	     (getter-&-setter))))
      
