;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cfa/stack.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jun 27 10:24:15 1996                          */
;*    Last change :  Wed Aug  7 14:16:01 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The mapping of heap allocations to stack allocations.            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_stack
   (include "Tools/trace.sch")
   (import  engine_param
	    tools_speek
	    tools_shape
	    type_type
	    ast_var
	    ast_node
	    cfa_info
	    cfa_iterate
	    cfa_loose
	    inline_inline
	    inline_walk)
   (export  (stack-optimization?::bool)
	    (heap->stack! globals globals)
	    (generic stack!::node ::node)
	    (stack*! node*)
	    (node-heap->stack!::node ::app ::bool)))

;*---------------------------------------------------------------------*/
;*    stack-optimization? ...                                          */
;*---------------------------------------------------------------------*/
(define (stack-optimization?)
   (and *optim-stack?* *inlining?*))

;*---------------------------------------------------------------------*/
;*    heap->stack! ...                                                 */
;*---------------------------------------------------------------------*/
(define (heap->stack! roots globals)
   (if (stack-optimization?)
       (begin
	  (verbose 1 "   . Heap -> Stack" #\newline)
	  (set-looser! 'stack)
	  (trace cfa
		 "--------------------------------------"
		 #\Newline "Stack optimization! :" #\Newline
		 #\Newline)
	  (cfa-iterate! roots)
	  ;; we setup the inlining 
	  (inline-setup! 'all)
	  (for-each (lambda (global)
		       (let ((fun (global-value global)))
			  (sfun-body-set! fun (stack! (sfun-body fun)))))
		    globals)
	  (trace cfa "--------------------------------------" #\Newline)
	  (verb-stat)
	  globals)))

;*---------------------------------------------------------------------*/
;*    node-heap->stack! ...                                            */
;*---------------------------------------------------------------------*/
(define (node-heap->stack! node::app stackable?)
   (with-access::app node (fun)
      (let* ((v (var-variable fun))
	     (f (variable-value v)))
	 (if (global? (fun-stack-allocator f))
	     (if stackable?
		 (begin
		    (stack-stat-succeed (variable-id v))
		    (set! fun (duplicate::var fun
				 (variable (fun-stack-allocator f))))
		    ;; we inline to have correct definition
		    ;; of stack allocators (otherwise we could call a
		    ;; function which is, of course, incorrect).
		    (inline-node node 1 '()))
		 (begin
		    (stack-stat-fail (variable-id v))
		    node))
	     node))))

;*---------------------------------------------------------------------*/
;*    *statistics* ...                                                 */
;*---------------------------------------------------------------------*/
(define *statistics* '())

;*---------------------------------------------------------------------*/
;*    stack-stat-succeed ...                                           */
;*---------------------------------------------------------------------*/
(define (stack-stat-succeed kind)
   (let ((cell (assq kind *statistics*)))
      (if (pair? cell)
	  (set-car! (cdr cell) (+fx 1 (cadr cell)))
	  (set! *statistics* (cons (cons kind (cons 1 0)) *statistics*)))))

;*---------------------------------------------------------------------*/
;*    stack-stat-fail ...                                              */
;*---------------------------------------------------------------------*/
(define (stack-stat-fail kind)
   (let ((cell (assq kind *statistics*)))
      (if (pair? cell)
	  (set-cdr! (cdr cell) (+fx 1 (cddr cell)))
	  (set! *statistics* (cons (cons kind (cons 0 1)) *statistics*)))))

;*---------------------------------------------------------------------*/
;*    verb-stat ...                                                    */
;*---------------------------------------------------------------------*/
(define (verb-stat)
   (for-each (lambda (stat)
		(verbose 2 "       "
			 (string-downcase! (symbol->string (car stat)))
			 ": " (cadr stat) " (of " (+fx (cadr stat) (cddr stat))
			 #\) #\Newline))
	     *statistics*))

;*---------------------------------------------------------------------*/
;*    stack! ...                                                       */
;*---------------------------------------------------------------------*/
(define-generic (stack!::node node::node))

;*---------------------------------------------------------------------*/
;*    stack! ::atom ...                                                */
;*---------------------------------------------------------------------*/
(define-method (stack! node::atom)
   node)

;*---------------------------------------------------------------------*/
;*    stack! ::kwote ...                                               */
;*---------------------------------------------------------------------*/
(define-method (stack! node::kwote)
   node)

;*---------------------------------------------------------------------*/
;*    stack! ::var ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (stack! node::var)
   node)

;*---------------------------------------------------------------------*/
;*    stack! ::closure ...                                             */
;*---------------------------------------------------------------------*/
(define-method (stack! node::closure)
   node)

;*---------------------------------------------------------------------*/
;*    stack! ::sequence ...                                            */
;*---------------------------------------------------------------------*/
(define-method (stack! node::sequence)
   (with-access::sequence node (nodes)
      (stack*! nodes)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::app-ly ...                                               */
;*---------------------------------------------------------------------*/
(define-method (stack! node::app-ly)
   (with-access::app-ly node (fun arg)
      (set! fun (stack! fun))
      (set! arg (stack! arg))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::funcall ...                                             */
;*---------------------------------------------------------------------*/
(define-method (stack! node::funcall)
   (with-access::funcall node (fun args)
      (set! fun (stack! fun))
      (stack*! args)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::pragma ...                                              */
;*---------------------------------------------------------------------*/
(define-method (stack! node::pragma)
   (with-access::pragma node (args)
      (stack*! args)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::cast ...                                                */
;*---------------------------------------------------------------------*/
(define-method (stack! node::cast)
   (with-access::cast node (arg)
      (stack! arg)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::setq ...                                                */
;*---------------------------------------------------------------------*/
(define-method (stack! node::setq)
   (with-access::setq node (var value)
      (set! value (stack! value))
      (set! var (stack! var))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::conditional ...                                         */
;*---------------------------------------------------------------------*/
(define-method (stack! node::conditional)
   (with-access::conditional node (test true false)
       (set! test (stack! test))
       (set! true (stack! true))
       (set! false (stack! false))
       node))

;*---------------------------------------------------------------------*/
;*    stack! ::fail ...                                                */
;*---------------------------------------------------------------------*/
(define-method (stack! node::fail)
   (with-access::fail node (type proc msg obj)
      (set! proc (stack! proc))
      (set! msg (stack! msg))
      (set! obj (stack! obj))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::select ...                                              */
;*---------------------------------------------------------------------*/
(define-method (stack! node::select)
   (with-access::select node (clauses test)
      (set! test (stack! test))
      (for-each (lambda (clause)
		   (set-cdr! clause (stack! (cdr clause))))
		clauses)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::let-fun ...                                             */
;*---------------------------------------------------------------------*/
(define-method (stack! node::let-fun)
   (with-access::let-fun node (body locals)
      (for-each (lambda (local)
		   (let ((fun (local-value local)))
		      (sfun-body-set! fun (stack! (sfun-body fun)))))
		locals)
      (set! body (stack! body))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::let-var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (stack! node::let-var)
   (with-access::let-var node (body bindings)
      (set! body (stack! body))
      (for-each (lambda (binding)
		   (set-cdr! binding (stack! (cdr binding))))
		bindings)
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::set-ex-it ...                                           */
;*---------------------------------------------------------------------*/
(define-method (stack! node::set-ex-it)
   (with-access::set-ex-it node (var body)
      (set! body (stack! body))
      (set! var (stack! var))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::jump-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (stack! node::jump-ex-it)
   (with-access::jump-ex-it node (exit value)
      (set! exit (stack! exit))
      (set! value (stack! value))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::make-box ...                                            */
;*---------------------------------------------------------------------*/
(define-method (stack! node::make-box)
   (with-access::make-box node (value)
      (set! value (stack! value))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::box-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (stack! node::box-set!)
   (with-access::box-set! node (var value)
      (set! var (stack! var))
      (set! value (stack! value))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::box-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (stack! node::box-ref)
   (with-access::box-ref node (var)
      (set! var (stack! var))
      node))

;*---------------------------------------------------------------------*/
;*    stack! ::app ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (stack! node::app)
   (with-access::app node (fun args)
      (stack*! args)
      node))

;*---------------------------------------------------------------------*/
;*    stack*! ...                                                      */
;*---------------------------------------------------------------------*/
(define (stack*! node*)
   (let loop ((node* node*))
      (cond
	 ((null? node*)
	  'done)
	 (else
	  (set-car! node* (stack! (car node*)))
	  (loop (cdr node*))))))


   
