;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/ld.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 17 09:37:55 1992                          */
;*    Last change :  Thu Feb 19 18:26:25 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The (system) link.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cc_ld
   (export  (ld name ::bool))
   (extern  (macro shared-library-available?::bool "HAVE_SHARED_LIBRARY"))
   (import  tools_speek
	    tools_error
	    cc_exec
	    engine_param))

;*---------------------------------------------------------------------*/
;*    list-of-string->string ...                                       */
;*---------------------------------------------------------------------*/
(define (list-of-string->string l)
   (let loop ((l (reverse l))
	      (r ""))
      (if (null? l)
	  r
	  (loop (cdr l)
		(string-append (car l) " " r)))))

;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*---------------------------------------------------------------------*/
(define (ld name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-ld name need-to-return))
      (else
       (user-error "ld" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*    -------------------------------------------------------------    */
;*    Le link se fait avec plusieurs fichiers:                         */
;*       1- Le fichier .o resultat de la compilation courrante         */
;*       2- Tous les .o qui ont ete passes en argument                 */
;*       3- Tous les .o qui correspondent aux fichiers de presents     */
;*          dans les clauses `with' du main.                           */
;*---------------------------------------------------------------------*/
(define (unix-ld name need-to-return)
   (verbose 1 "   . ld (" *cc* ")" #\Newline)
   ;; we patch ld option for Linux/PC and Boehm's collector release 4.12
   (if (and (string=? (os-name) "Linux")
	    (string=? *cc* "gcc")
	    (let ((os-arch (os-arch)))
	       (and (=fx (string-length os-arch) 4)
		    (char=? (string-ref os-arch 0) #\i)
		    (char=? (string-ref os-arch 2) #\8)
		    (char=? (string-ref os-arch 3) #\6)))
	    (and (let ((p (open-input-string *ld-options*)))
		    (unwind-protect
		       (read/rp (regular-search ("-static")) p)
		       (close-input-port p)))))
       ;; Boehm's collector (at least release 4.12) needs this
       ;; otherwise the static version of the lib C cannot be used.
       (set! *ld-options* (string-append "-Wl,-defsym,_DYNAMIC=0 "
					 *ld-options*)))
   (let* ((dest       (if (string? *dest*)
			  *dest*
			  "a.out"))
	  (lib-name   (string-append "lib" *bigloo-lib* ))
	  (bigloo-lib (let ((lib (make-file-name *lib-dir* lib-name)))
			 (if (or *static-bigloo?*
				 (not shared-library-available?))
			     (make-static-library-name lib)
			     (make-shared-library-name lib))))
	  (gclib-name (string-append "lib" *gc-lib* ))
	  (gc-lib     (let ((lib (make-file-name *lib-dir* gclib-name)))
			 (if (or *static-bigloo?*
				 (not shared-library-available?))
			     (make-static-library-name lib)
			     (make-shared-library-name lib))))
	  (other-libs (let loop ((lib *bigloo-user-lib*)
				 (res ""))
			 (if (null? lib)
			     res
			     (loop (cdr lib)
				   (string-append (car lib) " " res)))))
	  (ld-args    (string-append;; object file name
		       name ".o" " "
		       ;; to be linked with files
		       (list-of-string->string *with-files*)
		       ;; other object files
		       (list-of-string->string *o-files*)
		       ;; the executable name
		       " -o " dest
		       ;; cc options
		       " "  *cc-options*
		       ;; optional debug option
		       (if *c-debug*
			   (string-append " " *c-debug-option*)
			   "")
		       ;; optional executable stripping
		       (if *strip* " -s" "")
		       ;; user ld otions
		       " " *ld-options*
		       ;; standard bigloo library
		       " " bigloo-lib
		       ;; standard GC library
		       " " gc-lib
		       ;; user libraries
		       " " other-libs))
	  (cmd/ld     (string-append *cc* " " ld-args))
	  (cmd        cmd/ld))
      (verbose 2 "      ["  cmd/ld #\] #\Newline)
      (exec cmd need-to-return "ld")))
