;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/cc.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Apr 29 09:51:32 1995                          */
;*    Last change :  Tue Jan 20 14:44:26 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C compilation                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cc_cc
   (export  (cc name ::bool))
   (import  tools_speek
	    tools_file
	    tools_error
	    cc_exec
	    engine_param))

;*---------------------------------------------------------------------*/
;*    cc ...                                                           */
;*---------------------------------------------------------------------*/
(define (cc name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-cc name need-to-return))
      (else
       (user-error "cc" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    unix-cc ...                                                      */
;*---------------------------------------------------------------------*/
(define (unix-cc name need-to-return)
   (verbose 1 "   . cc (" *cc* ")" #\Newline)
   (cond
      ((not (string? name))
       (error "cc" "can't process cc on stdout" name))
      (else
       (let ((cc (string-append *cc*
				" "
				*cc-options*
				" -c "
				" -I. -I" *lib-dir*
				(if *c-debug*
				    (string-append " " *c-debug-option*)
				    "")
				" " name ".c ")))
	  (verbose 2 "      ["  cc #\] #\Newline)
	  (let* ((basename (basename name))
		 (rm-csrc  (if *rm-c-files*
			       (string-append "&& /bin/rm -f " name ".c ")
			       ""))
		 (pwd      (let ((vpwd (getenv "PWD")))
			      (if (string? vpwd)
				  vpwd
				  (pwd))))
		 (mv-obj   (if (and (not (string=? basename name))
				    (not (string=? pwd (dirname name))))
			       (string-append "&& /bin/mv "
					      basename 
					      ".o "
					      name
					      ".o 2>&1 >/dev/null ")
			       ""))
		 (cmd      (string-append cc mv-obj rm-csrc)))
	     (exec cmd need-to-return "cc"))))))
