;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Ast/pragma.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 15:11:13 1996                          */
;*    Last change :  Thu Jun 20 12:11:28 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The creation of pragma forms.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_pragma
   (include "Ast/node.sch")
   (import  tools_error
	    tools_location
 	    ast_sexp)
   (export (pragma/type->node::node ::bool ::type exp stack ::obj ::symbol)))

;*---------------------------------------------------------------------*/
;*    pragma/type->node ...                                            */
;*---------------------------------------------------------------------*/
(define (pragma/type->node free type exp stack loc site)
   (match-case exp
      ((?- (and (? string?) ?format) . ?values)
       (let ((max-index (get-max-index format))
	     (loc       (find-location/loc exp loc)))
	  (if (not (=fx max-index (length values)))
	      (error-sexp->node "Wrong number of arguments in `pragma' form"
				exp
				loc)
	      (let loop ((exps values)
			 (nodes '()))
		 (if (null? exps)
		     (instantiate::pragma (loc          loc)
					  (type         type)
					  (format       format)
					  (args         (reverse! nodes))
					  (side-effect? (not free)))
		     (loop (cdr exps)
			   (cons
			    (sexp->node (car exps)
					stack
					(find-location/loc (car exps) loc)
					'value)
			    nodes)))))))
      (else
       (error-sexp->node "Illegal `pragma' form" exp loc))))

;*---------------------------------------------------------------------*/
;*    get-max-index ...                                                */
;*---------------------------------------------------------------------*/
(define (get-max-index format)
   (let ((parser (regular-grammar ()
		    ((#\$ (+ (>-< #\0 #\9)))
		     (let* ((str (the-string))
			    (len (the-length)))
			(string->number (substring str 1 len))))
		    ((+ (out #\$))
		     (ignore))
		    (else
		     (the-failing-char))))
	 (port   (open-input-string format)))
      (let loop ((exp (read/rp parser port))
		 (max 0))
	 (cond
	    ((eof-object? exp)
	     max)
	    ((char? exp)
	     (loop (read/rp parser port) max))
	    (else
	     (loop (read/rp parser port) (if (>fx exp max) exp max)))))))
   

