;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/ident.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun  3 09:33:09 1996                          */
;*    Last change :  Fri Feb  6 16:41:33 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The identifier managment                                         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_ident
   (import tools_error
	   tools_dsssl
	   type_type
	   type_env
	   type_cache)
   (export (type-of-id::type       ::obj)
	   (id-of-id::symbol       ::obj)
	   (fast-id-of-id::symbol  ::obj)
	   (parse-id::pair         ::obj)
	   (parse-dsssl::pair      ::obj)
	   (check-id::pair         ::pair ::obj)
	   (id->name::bstring      ::obj)))

;*---------------------------------------------------------------------*/
;*    type-of-id ...                                                   */
;*---------------------------------------------------------------------*/
(define (type-of-id::type id)
   (if (not (symbol? id))
       (user-error "Illegal identifier" "`'" id)
       (cdr (parse-id id))))

;*---------------------------------------------------------------------*/
;*    id-of-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (id-of-id::symbol id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (car (parse-id id))))

;*---------------------------------------------------------------------*/
;*    fast-id-of-id ...                                                */
;*---------------------------------------------------------------------*/
(define (fast-id-of-id::symbol id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (let* ((string (symbol->string id))
	      (len    (string-length string)))
	  (let loop ((walker  0))
	     (cond
		((=fx walker len)
		 id)
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (string->symbol (substring string 0 walker)))
		(else
		 (loop (+fx walker 1))))))))

;*---------------------------------------------------------------------*/
;*    parse-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (parse-id::pair id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (let* ((string (symbol->string id))
	      (len    (string-length string)))
	  (let loop ((walker     0)
		     (id-stop    0)
		     (type-start 0))
	     (cond
		((=fx walker len)
		 (cond
		    ((and (=fx id-stop 0) (>fx type-start 0))
		     ;; this empty name variable can be useful to declare
		     ;; prototype so it is legal.
		     (let ((id  (string->symbol ""))
			   (tid (string->symbol (substring string
							   type-start
							   len))))
			(cons id (use-type! tid))))
		    ((=fx id-stop 0)
		     (cons id (get-default-type)))
		    ((=fx type-start len)
		     ;; empty type are erroneous
		     (user-error "type-of-id"
				 "Illegal formal identifier"
				 id
				 (cons 'error-ident (get-default-type))))
		    (else
		     (let ((id  (string->symbol (substring string 0 id-stop)))
			   (tid (string->symbol (substring string
							   type-start
							   len))))
			(cons id (use-type! tid))))))
		((and (char=? (string-ref string walker) #\:)
		      (<fx walker (-fx len 1))
		      (char=? (string-ref string (+fx walker 1)) #\:))
		 (if (>fx type-start 0)
		     (user-error "type-of-id"
				 "Illegal formal identifier"
				 id
				 (cons 'error-ident (get-default-type)))
		     (loop (+fx walker 2) walker (+fx walker 2))))
		(else
		 (loop (+fx walker 1) id-stop type-start)))))))

;*---------------------------------------------------------------------*/
;*    id->name ...                                                     */
;*---------------------------------------------------------------------*/
(define (id->name::bstring id)
   (if (not (symbol? id))
       (user-error "parse" "Illegal identifier" id)
       (let ((name (string-downcase (symbol->string id))))
	  (scheme-id->c-id name
			   (memq (string->symbol name) *c-keyword-list*)))))

;*---------------------------------------------------------------------*/
;*    *c-keyword-list*                                                 */
;*---------------------------------------------------------------------*/
(define *c-keyword-list*
   (map string->symbol
	'("asm" "auto" "break" "case" "char" "const" "continue" "default"
	  "do" "double" "else" "entry" "enum" "extern" "float" "for"
	  "fortran" "goto" "if" "int" "long" "register" "return" "short"
	  "signed" "sizeof" "static" "struct" "switch" "typedef" "union"
	  "unsigned" "void" "volatile" "while" "main")))

;*---------------------------------------------------------------------*/
;*    scheme-id->c-id ...                                              */
;*---------------------------------------------------------------------*/
(define (scheme-id->c-id::bstring string::bstring rg)
   (let* ((nstring (if (and (not (char-alphabetic? (string-ref string 0)))
			    (not (char=? (string-ref string 0) #\_)))
		       (string-append "_" string)
		       string))
	  (len     (string-length nstring))
	  (res     (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     (let ((str (if rg
			    (string-append
			     res
			     (string-append
			      "_"
			      (integer->string (string->0..255 string))))
			    res)))
		(if (char=? (string-ref str 0) #\_)
		    (remove__ str)
		    str))
	     (let ((c (string-ref nstring i)))
		(cond
		   ((or (and (char>=? c #\a)
			     (char<=? c #\z))
			(and (char>=? c #\0)
			     (char<=? c #\9))
			(char=? c #\_))
		    (string-set! res i (string-ref nstring i))
		    (loop (+fx i 1)))
		   (else
		    (set! rg #t)
		    (string-set! res i #\_) 
		    (loop (+fx i 1)))))))))

;*---------------------------------------------------------------------*/
;*    remove__ ...                                                     */
;*    -------------------------------------------------------------    */
;*    On some architecture (alpha and mips) __init has a special       */
;*    meaning, in order to prevent all this strange cases, we change   */
;*    ident which start by __init.                                     */
;*---------------------------------------------------------------------*/
(define (remove__ string::bstring)
   (cond
      ((not (>=fx (string-length string) 6))
       string)
      ((not (char=? (string-ref string 0) #\_))
       string)
      ((not (char=? (string-ref string 1) #\_))
       string)
      ((and (not (char=? (string-ref string 2) #\i))
	    (not (char=? (string-ref string 2) #\f)))
       string)
      ((and (not (char=? (string-ref string 3) #\n))
	    (not (char=? (string-ref string 3) #\i)))
       string)
      ((and (not (char=? (string-ref string 4) #\i))
	    (not (char=? (string-ref string 4) #\n)))
       string)
      ((and (not (char=? (string-ref string 5) #\t))
	    (not (char=? (string-ref string 5) #\i)))
       string)
      ((not (char=? (string-ref string 6) #\_))
       string)
      (else
       (string-append "_n_o_f_u_c_k_i_n_g___init_or_fini" string))))

;*---------------------------------------------------------------------*/
;*    check-id ...                                                     */
;*---------------------------------------------------------------------*/
(define (check-id id src)
   (if (eq? (car id) (string->symbol ""))
       (user-error "Illegal identifier" "`'" src)
       id))

;*---------------------------------------------------------------------*/
;*    parse-dsssl ...                                                  */
;*---------------------------------------------------------------------*/
(define (parse-dsssl obj)
   (cond
    ((dsssl-named-constant? obj)
     (cons obj *obj*))
    ((dsssl-defaulted-formal? obj)
     (cons obj *obj*))
    (else
     (user-error "Illegal formal parameter" "" obj))))
