; client.scm
; client example for sockets in Scheme using bigloo
; Sven Hartrumpf (C) 1997


; How to test this example
;
; Set the variable server-address in this file to the IP address of the
; server.
; Type make in this directory.
; Start the server on the correct machine.
; Then, let clients call the server by entering: client "this is my message".
; The server will reply with the message reversed.
; Clients can stop the server by sending the message "quit".


;; module definition

(module client
  (include "sockets.sch")
  (include "sockets.scm")
  (main call-server-args))


;; the server's IP address

(define server-address "132.176.72.31")


;; top level

(define call-server-args (lambda (args)
  (let ((client-socket #f)
        (message "sockets in Scheme")
        (result #f)
        (server-message #f)
        (server-message-length #f))
  (cond ((pair? (cdr args))
         (set! message (cadr args))))
  ;; create socket
  (set! client-socket (open-stream-socket))
  (display "open-stream-socket: client-socket: ") (write client-socket) (newline)
  ;; bind socket
  (set! result (bind-socket client-socket 5006))
  (display "bind-socket: result: ") (write result) (newline)
  ;; connect to server (use the correct IP address)
  (set! result (connect-socket client-socket server-address 5005))
  (display "connect-socket: result: ") (write result) (newline)
  ;; send message to server
  (set! result (send-socket client-socket message))
  (display "send-socket: result: ") (write result) (newline)
  ;; receive message from server
  (set! server-message (receive-socket client-socket))
  (display "receive-socket: server-message: ") (write server-message) (newline)
  ;; shutdown client socket
  (set! result (shutdown-socket client-socket))
  (display "shutdown-socket: result: ") (write result) (newline)
  ;; close client socket
  (set! result (close-socket client-socket))
  (display "close-socket: result: ") (write result) (newline)
  )))
