
# line 2 "parse.y"
#include <stdio.h> 
#include <grp.h>
#include "idled.h"
#include <pwd.h>

#ifndef DEBUG
#define DEBUG 0
#endif

#define debug if (DEBUG > 0) logfile

int		num;
char		*name;
struct	group	*grp;

extern	char	*yytext;

extern	char	*config_file;	/* The name of the config file, from idled.c */
extern  char    *strchr();
extern	void	addlist();

  /************************************************************************
   *  The order of the tokens in the *first line* is significant.         *
   *                                                                      *
   *  They dictate which rules and exemptions have precedence.            *
   *  Hence, TTY has precedence over HOST has precedence over LOGIN, etc. *
   *                                                                      *
   *  The second two %token lines may be ordered anyway.                  *
   *  DEFAULT is the least specific, but will always match.               *
   *  It must always remain in the last position.                         *
   ************************************************************************/

# line 43 "parse.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
	char *sb; 
	int nb;
       } YYSTYPE;
# define TTY 257
# define HOST 258
# define LOGIN 259
# define GROUP 260
# define FILECOM 261
# define DEFAULT 262
# define EXEMPT 263
# define TIMEOUT 264
# define SLEEP 265
# define WARN 266
# define IDLEMETHOD 267
# define CONSWINS 268
# define SESSION 269
# define REFUSE 270
# define MULTIPLES 271
# define NUM 272
# define IDLE 273
# define MULTIPLE 274
# define NAME 275
# define ALL 276
# define THRESHOLD 277
# define NL 278
# define USERINPUT 279
# define INPUTOUTPUT 280
# define NORMAL 281
# define OFF 282

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 274 "parse.y"


static	int	errorcnt = 0;



int
yyerror(sb)
   char *sb;
{
	extern	int	linenum;

	logfile("%s: line %d: %s", config_file, linenum, sb);
	errorcnt++;
	return 0;
}



int
yywrap()
{
	extern	int	linenum;
        extern  time_t  conf_oldstamp;

	if ( errorcnt > 0 && conf_oldstamp <= 1 )
	{
	    logfile("Aborting due to conf file syntax errors.");
	    exit(1);
	}

	linenum = 1;
	return 1;
}

#ifndef HAVE_YYRESTART
void yyrestart(handle)
   FILE *handle;
{
        extern  int     linenum;

        linenum = 1;
}
#endif

/**************************************************************************
 * Reads in more rules from a separate file, which contains the           *
 * login names of the users for that type, one per line.                  *
 **************************************************************************/
void filecom_parse(type,filename,param)
   int type;               /* REFUSE, SESSION, TIMEOUT, or EXEMPT */
   char *filename;
   int param;              /* idle/session time or exempt type */
{
   FILE *handle;
   handle = fopen(filename,"r");
   if (handle == NULL)
   {
      char *buffer;
      buffer = (char *) malloc(20+sizeof(filename));
      sprintf(buffer,"Could not open file '%s'",filename);
      yyerror(buffer);
      free(buffer);
   }
   else
   {
      char lname[NAMELEN+1], trash[100], *c;
      while (!feof(handle) && (fgets(lname,NAMELEN+1,handle) != NULL))
      {
         /* If we didn't read in the newline, do so now */
         if (strchr(lname,'\n') == NULL)
            fscanf(handle,"%[^\n]\n",trash);

         /* First, strip away beyond the first space or newline */
         c = strchr(lname,' ');  if (c != NULL) *c = '\0';
         c = strchr(lname,'\n'); if (c != NULL) *c = '\0';

         if ((int)strlen(lname) > 0)
         {
            char *username;
            username = (char *) malloc (strlen(lname)+1);
            strcpy(username,lname);
            switch(type)
            {
               case REFUSE:
                  debug("Refusing user %s.",username);
                  addlist(refuse, LOGIN, username, 0, 0);
                  break;
               case SESSION:
                  debug("Session Limiting user %s to %d minutes.",username,param);
                  addlist(session, LOGIN, username, 0, param);
                  break;
               case TIMEOUT:
                  debug("Setting Idle timeout for user %s to %d minutes.",username,param);
                  addlist(rules, LOGIN, username, 0, param);
                  break;
               case EXEMPT:
                  debug("Exempting user %s from type %d.",username,param);
                  addlist(exmpt, LOGIN, username, 0, param);
                  break;
            }
         }
      }
   }
}

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 61
# define YYLAST 161
yytabelem yyact[]={

    12,   127,   126,   125,   124,   123,   122,    14,    15,    17,
    18,    19,    20,    21,    16,    23,    46,    90,   121,    87,
   119,    22,    13,    84,   118,    95,    91,    92,    88,    89,
    66,    65,    85,    86,    63,    64,   117,    62,    11,    44,
    45,   116,   115,   114,   113,   112,   111,   110,   109,   108,
   106,   104,   103,   102,   101,    98,    93,    83,    82,    81,
    80,    79,    78,    77,    76,    74,    73,    68,    24,    55,
    32,    30,    29,    31,    52,    53,    50,    58,    75,    71,
    69,    67,    60,    54,    43,    41,   120,   107,   100,    48,
    57,    99,    61,    47,    49,    56,    97,    96,    59,    94,
    42,    40,    72,    70,    36,    32,    30,    29,    31,    34,
    35,    39,    32,    30,    29,    31,    38,    27,    32,    30,
    29,    31,    26,    25,    10,     9,     8,     7,     6,     5,
     4,     3,     2,     1,    28,     0,     0,     0,     0,    33,
    37,     0,     0,     0,     0,    51,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   105 };
yytabelem yypact[]={

-10000000,  -256,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  -210,-10000000,  -139,  -152,  -145,  -171,  -172,  -240,
  -180,  -187,  -179,  -174,-10000000,  -239,  -194,  -211,  -195,-10000000,
-10000000,-10000000,-10000000,  -169,  -196,  -170,  -212,  -213,  -197,  -214,
  -215,  -216,  -217,  -218,  -219,  -220,  -221,  -249,  -253,  -255,
  -222,  -173,  -250,  -175,  -176,  -223,  -181,  -184,  -224,  -225,
  -226,  -227,-10000000,-10000000,-10000000,-10000000,-10000000,  -239,-10000000,-10000000,
  -228,  -185,  -229,-10000000,-10000000,  -230,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,  -231,  -232,  -233,  -234,  -235,  -236,
  -237,  -242,  -254,-10000000,  -258,  -186,  -260,  -272,-10000000,  -273,
  -274,-10000000,-10000000,-10000000,-10000000,  -275,-10000000,  -276,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
  -277,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000 };
yytabelem yypgo[]={

     0,   123,    92,   134,   133,   132,   131,   130,   129,   128,
   127,   126,   125,   124,    38 };
yytabelem yyr1[]={

     0,     4,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     4,     4,    13,    13,    13,     5,     5,     5,
     7,     7,     7,    12,    12,    12,    12,    12,     6,     6,
     6,     6,     8,     8,     9,     9,    10,    10,    10,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    14,
    14,     1,     3,     3,     3,     3,     2,     2,     2,     2,
     2 };
yytabelem yyr2[]={

     0,     0,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     4,     6,     4,     9,     9,     7,     9,    11,     7,
     7,     9,     7,     9,    11,     9,     9,     7,     9,    11,
     9,     7,     7,     7,     7,     7,     7,     7,     7,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     7,     7,
     7,     5,     3,     3,     3,     3,     3,     3,     3,     3,
     3 };
yytabelem yychk[]={

-10000000,    -4,    -5,    -6,    -7,    -8,    -9,   -10,   -11,   -12,
   -13,   -14,   256,   278,   263,   264,   270,   265,   266,   267,
   268,   269,   277,   271,   278,    -1,   261,   256,    -3,   259,
   258,   260,   257,    -1,   261,   262,   256,    -1,   261,   256,
   272,   256,   272,   256,   279,   280,   256,   273,   269,   274,
   256,    -1,   261,   262,   270,   256,   274,   269,   256,   272,
   256,    -2,   276,   273,   274,   270,   269,   275,   278,   275,
   272,   275,   272,   278,   278,   275,   278,   278,   278,   278,
   278,   278,   278,   278,   272,   281,   282,   272,   281,   282,
   272,   281,   282,   278,   272,   275,   272,   272,   278,   272,
   272,   278,   278,   278,   278,    -2,   278,   272,   278,   278,
   278,   278,   278,   278,   278,   278,   278,   278,   278,   278,
   272,   278,   278,   278,   278,   278,   278,   278 };
yytabelem yydef[]={

     1,    -2,     2,     3,     4,     5,     6,     7,     8,     9,
    10,    11,     0,    13,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,    12,     0,     0,     0,     0,    52,
    53,    54,    55,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    56,    57,    58,    59,    60,     0,    19,    51,
     0,     0,     0,    31,    20,     0,    22,    32,    33,    34,
    35,    36,    37,    38,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    48,     0,     0,     0,     0,    27,     0,
     0,    16,    49,    50,    17,     0,    28,     0,    30,    21,
    39,    40,    41,    42,    43,    44,    45,    46,    47,    23,
     0,    25,    26,    14,    15,    18,    29,    24 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"TTY",	257,
	"HOST",	258,
	"LOGIN",	259,
	"GROUP",	260,
	"FILECOM",	261,
	"DEFAULT",	262,
	"EXEMPT",	263,
	"TIMEOUT",	264,
	"SLEEP",	265,
	"WARN",	266,
	"IDLEMETHOD",	267,
	"CONSWINS",	268,
	"SESSION",	269,
	"REFUSE",	270,
	"MULTIPLES",	271,
	"NUM",	272,
	"IDLE",	273,
	"MULTIPLE",	274,
	"NAME",	275,
	"ALL",	276,
	"THRESHOLD",	277,
	"NL",	278,
	"USERINPUT",	279,
	"INPUTOUTPUT",	280,
	"NORMAL",	281,
	"OFF",	282,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"cmd_cmd : /* empty */",
	"cmd_cmd : cmd_cmd exempt_cmd",
	"cmd_cmd : cmd_cmd idle_cmd",
	"cmd_cmd : cmd_cmd refuse_cmd",
	"cmd_cmd : cmd_cmd sleep_cmd",
	"cmd_cmd : cmd_cmd warn_cmd",
	"cmd_cmd : cmd_cmd idlemethod_cmd",
	"cmd_cmd : cmd_cmd conswins_cmd",
	"cmd_cmd : cmd_cmd session_cmd",
	"cmd_cmd : cmd_cmd thresh_cmd",
	"cmd_cmd : cmd_cmd mult_cmd",
	"cmd_cmd : cmd_cmd error NL",
	"cmd_cmd : cmd_cmd NL",
	"thresh_cmd : THRESHOLD MULTIPLE NUM NL",
	"thresh_cmd : THRESHOLD SESSION NUM NL",
	"thresh_cmd : THRESHOLD error NL",
	"exempt_cmd : EXEMPT who exempt_type NL",
	"exempt_cmd : EXEMPT FILECOM NAME exempt_type NL",
	"exempt_cmd : EXEMPT error NL",
	"refuse_cmd : REFUSE who NL",
	"refuse_cmd : REFUSE FILECOM NAME NL",
	"refuse_cmd : REFUSE error NL",
	"session_cmd : SESSION who NUM NL",
	"session_cmd : SESSION FILECOM NAME NUM NL",
	"session_cmd : SESSION DEFAULT NUM NL",
	"session_cmd : SESSION REFUSE NUM NL",
	"session_cmd : SESSION error NL",
	"idle_cmd : TIMEOUT who NUM NL",
	"idle_cmd : TIMEOUT FILECOM NAME NUM NL",
	"idle_cmd : TIMEOUT DEFAULT NUM NL",
	"idle_cmd : TIMEOUT error NL",
	"sleep_cmd : SLEEP NUM NL",
	"sleep_cmd : SLEEP error NL",
	"warn_cmd : WARN NUM NL",
	"warn_cmd : WARN error NL",
	"idlemethod_cmd : IDLEMETHOD USERINPUT NL",
	"idlemethod_cmd : IDLEMETHOD INPUTOUTPUT NL",
	"idlemethod_cmd : IDLEMETHOD error NL",
	"conswins_cmd : CONSWINS IDLE NUM NL",
	"conswins_cmd : CONSWINS IDLE NORMAL NL",
	"conswins_cmd : CONSWINS IDLE OFF NL",
	"conswins_cmd : CONSWINS SESSION NUM NL",
	"conswins_cmd : CONSWINS SESSION NORMAL NL",
	"conswins_cmd : CONSWINS SESSION OFF NL",
	"conswins_cmd : CONSWINS MULTIPLE NUM NL",
	"conswins_cmd : CONSWINS MULTIPLE NORMAL NL",
	"conswins_cmd : CONSWINS MULTIPLE OFF NL",
	"conswins_cmd : CONSWINS error NL",
	"mult_cmd : MULTIPLES NUM NL",
	"mult_cmd : MULTIPLES error NL",
	"who : name_type NAME",
	"name_type : LOGIN",
	"name_type : HOST",
	"name_type : GROUP",
	"name_type : TTY",
	"exempt_type : ALL",
	"exempt_type : IDLE",
	"exempt_type : MULTIPLE",
	"exempt_type : REFUSE",
	"exempt_type : SESSION",
};
#endif /* YYDEBUG */
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 14:
# line 72 "parse.y"
{
			m_threshold = yypvt[-1].nb; 
		} break;
case 15:
# line 76 "parse.y"
{
			s_threshold = yypvt[-1].nb; 
		} break;
case 16:
# line 80 "parse.y"
{
			yyerror("Malformed threshold command.");
		} break;
case 17:
# line 87 "parse.y"
{
			addlist(exmpt, yypvt[-2].nb, name, num, yypvt[-1].nb);
		} break;
case 18:
# line 91 "parse.y"
{
                        filecom_parse(EXEMPT,yypvt[-2].sb,yypvt[-1].nb);
		} break;
case 19:
# line 95 "parse.y"
{
			yyerror("Malformed exempt command.");
		} break;
case 20:
# line 101 "parse.y"
{
			addlist(refuse, yypvt[-1].nb, name, num, 0);
		} break;
case 21:
# line 105 "parse.y"
{
                        filecom_parse(REFUSE,yypvt[-1].sb,/* time or thing if any */0);
                } break;
case 22:
# line 109 "parse.y"
{
			yyerror("Malformed refuse command.");
		} break;
case 23:
# line 115 "parse.y"
{
			addlist(session, yypvt[-2].nb, name, num, yypvt[-1].nb);
		} break;
case 24:
# line 119 "parse.y"
{
                        filecom_parse(SESSION,yypvt[-2].sb,yypvt[-1].nb);
		} break;
case 25:
# line 123 "parse.y"
{
			session_default = yypvt[-1].nb;
		} break;
case 26:
# line 127 "parse.y"
{
			sess_refuse_len = yypvt[-1].nb * 60;
		} break;
case 27:
# line 131 "parse.y"
{
			yyerror("Malformed session command.");
		} break;
case 28:
# line 137 "parse.y"
{
			addlist(rules, yypvt[-2].nb, name, num, yypvt[-1].nb);
		} break;
case 29:
# line 141 "parse.y"
{
                        filecom_parse(TIMEOUT,yypvt[-2].sb,yypvt[-1].nb);
		} break;
case 30:
# line 145 "parse.y"
{
			addlist(rules, DEFAULT, NULL, 0, yypvt[-1].nb);
		} break;
case 31:
# line 149 "parse.y"
{
			yyerror("Malformed timeout command.");
		} break;
case 32:
# line 155 "parse.y"
{
			sleeptime = yypvt[-1].nb;
		} break;
case 33:
# line 159 "parse.y"
{
			yyerror("Malformed sleep command.");
		} break;
case 34:
# line 165 "parse.y"
{
			warntime = yypvt[-1].nb;
		} break;
case 35:
# line 169 "parse.y"
{
			yyerror("Malformed warn command.");
		} break;
case 36:
# line 175 "parse.y"
{
			ioidle = FALSE;
		} break;
case 37:
# line 179 "parse.y"
{
			ioidle = TRUE;
                } break;
case 38:
# line 183 "parse.y"
{
			yyerror("Malformed idlemethod command.");
		} break;
case 39:
# line 189 "parse.y"
{
			conswins_idle = yypvt[-1].nb * 60;
		} break;
case 40:
# line 193 "parse.y"
{
                        conswins_idle = -2;
                } break;
case 41:
# line 197 "parse.y"
{
                        conswins_idle = -1;
                } break;
case 42:
# line 201 "parse.y"
{
			conswins_sess = yypvt[-1].nb * 60;
		} break;
case 43:
# line 205 "parse.y"
{
                        conswins_sess = -2;
                } break;
case 44:
# line 209 "parse.y"
{
                        conswins_sess = -1;
                } break;
case 45:
# line 213 "parse.y"
{
			conswins_mult = yypvt[-1].nb;
		} break;
case 46:
# line 217 "parse.y"
{
                        conswins_mult = -2;
                } break;
case 47:
# line 221 "parse.y"
{
                        conswins_mult = -1;
                } break;
case 48:
# line 225 "parse.y"
{
			yyerror("Malformed cons(ole) win(dow)s command.");
		} break;
case 49:
# line 231 "parse.y"
{
			mult_per_user = yypvt[-1].nb;
		} break;
case 50:
# line 235 "parse.y"
{
			yyerror("Malformed multiples command.");
		} break;
case 51:
# line 241 "parse.y"
{ 
			yyval.nb = yypvt[-1].nb;
			name = yypvt[-0].sb;

			if (yypvt[-1].nb == GROUP)
			{
				grp = getgrnam(name);
				if (grp != NULL)
                                	num = grp->gr_gid;
				else
					logfile("Error parsing conf file:  unknown group name '%s'.",name);
			}
			if (yypvt[-1].nb == LOGIN)
			{
				if (getpwnam(name) == NULL)
					logfile("Warning parsing conf file:  unknown login name '%s'.",name);
			}
		} break;
case 52:
# line 261 "parse.y"
{ yyval.nb = LOGIN;   } break;
case 53:
# line 262 "parse.y"
{ yyval.nb = HOST;    } break;
case 54:
# line 263 "parse.y"
{ yyval.nb = GROUP;   } break;
case 55:
# line 264 "parse.y"
{ yyval.nb = TTY;     } break;
case 56:
# line 267 "parse.y"
{ yyval.nb = ALL; 	 } break;
case 57:
# line 268 "parse.y"
{ yyval.nb = IDLE; 	 } break;
case 58:
# line 269 "parse.y"
{ yyval.nb = MULTIPLE; } break;
case 59:
# line 270 "parse.y"
{ yyval.nb = REFUSE;	 } break;
case 60:
# line 271 "parse.y"
{ yyval.nb = SESSION;  } break;
	}
	goto yystack;		/* reset registers in driver code */
}

