#ifndef __STATFILE_H__

static char statfile_h_rcsid[]="statfile.h,v 1.1.1.1 1994/06/18 19:43:32 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * statfile.h,v
 * Revision 1.1.1.1  1994/06/18  19:43:32  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define __STATFILE_H__ 1

#include <stdio.h>
#include "request.h"

#define STATFILEENVVARNAME "DQSSTATFILE"

typedef struct
{
  /* Input fields. */
  char *StatFileName;
  /* Input/Output fields. */
  FILE *StatFilePtr;
  /* Output fields. */
  struct stat FileStat;
  dqs_stats_type *Stats;
  unsigned long int Matches;
}
STATFILE;

STATFILE *
StatFileCreate PROTO((char *StatFileName, int *Result));

int
StatFileSearch PROTO((STATFILE *StatFile, unsigned long IStart,
		      unsigned long IStop, BOOLEAN Ver2_1));

int
StatFileCalc PROTO((STATFILE *StatFile, unsigned long IStop,
		    REQUEST *Req, BOOLEAN Ver2_1));

void
StatFileDestroy PROTO((STATFILE *StatFile));

#define STATFILE_SUCCESS		 0
#define STATFILE_OUTOFMEM		-1
#define STATFILE_NOFOPEN		-2
#define STATFILE_NOSTAT			-3
#define STATFILE_SMALLBINSIZE		-4
#define STATFILE_LARGEBINSIZE		-5
#define STATFILE_SMALLISTOP		-6
#define STATFILE_SMALLISTART		-7

#define STATFSRCH_SUCCESS                0
#define STATFSRCH_FSCAN_FAIL		-1
#define STATFSRCH_UNEXP_EOF		-2
#define STATFSRCH_NULLFILE		-3
#define STATFSRCH_ARITH_OVERFLOW	-4
#define STATFSRCH_STAT_FAIL		-5
#define STATFSRCH_EMPTY			-6
#define STATFSRCH_NOT_FOUND		-7
#define STATFSRCH_FSEEK_FAIL		-8

#endif /* __STATFILE_H__ */


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
