static char complex_rcsid[]="$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  complex.c,v
 * Revision 1.2  1994/11/28  16:54:44  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  02:57:04  raju
 * *** empty log message ***
 *
 **********************************************************/
#include "globals.h"

static Widget           complex_popup;
static Widget           widget_complexrc;
static Widget           widget_complexlabel;
static Widget           widget_complexframe;
static Widget           widget_complexmenu;
static Widget           widget_complexmain;
static Widget           widget_complexexec;
static Widget           widget_complexclear;
static Widget           widget_complexclose;
static Widget           widget_complexseparator;
static Widget           widget_complexopt;

struct optionstruct complexmenu[]={
  0,"Cell           ","-cell",MENUTYPE,NULL,NULL,
  0,"Add Complex       ","-ac",ACTIONTYPE,NULL,NULL,
  0,"Show Complexes    ","-sc",ACTIONTYPE,NULL,NULL,
  0,"Complex Name   ",NULL,MENUTYPE,NULL,NULL,
  0,"Show Complexe List","-scl",ACTIONTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL, NULL
};


/***********************************************************
 * pb_complexexec - Activate callback for exec
 */
XtCallbackProc pb_complexexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char 		command[MAX_STRING_SIZE];
  
  sprintf(command,"%s ",QCONF_BINARY);
  buildcommand(command,complexmenu,0);
}


/***********************************************************
 * pb_complexclear - Activate callback for clear
 */
XtCallbackProc pb_complexclear(Widget w,caddr_t client_data,caddr_t call_data)
{
  int ii;
  Arg args[5];

/*
  clearsubmenu(complexmenu);
*/
  QmonTextSetString(complexmenu[0].widgetid ,current_cell );
  if(account_list) 
  	QmonTextSetString(complexmenu[3].widgetid ,current_account );
}


/***********************************************************
 * pb_complexclose - Activate callback for close
 */
XtCallbackProc pb_complexclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * complexaction - Activate callback for action type menu
 */
XtCallbackProc complexaction(Widget w,caddr_t client_data,caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];
  char            *ptr=NULL;
  char            *ptr1=NULL;

  ptr=QmonTextGetString(complexmenu[3].widgetid);
  ptr1=QmonTextGetString(complexmenu[0].widgetid);

  for(ii=0;complexmenu[ii].name;ii++) {
    if(w==complexmenu[ii].widgetid) {
    if( ii==1 || ii==2) {
      if(!strcmp(ptr,"")) 
	{printf("Type in the complex name\n"); break ; }
      if(ii==1) {
	sprintf(command,"xterm -e %s -cell %s %s %s &",QCONF_BINARY,ptr1,complexmenu[ii].flag,ptr);
	execit(command);
       }
       else if(ii==2){
	sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,complexmenu[ii].flag,ptr);
	execit(command);
       }
    }
    else  {
      sprintf(command,"%s -cell %s %s &",QCONF_BINARY,ptr1,complexmenu[ii].flag);
      execit(command);
      break;
    }
    }
  }
}


/***********************************************************
 * create_complex_dialog - Create widgets used for the complex menu
 */
void create_complex_dialog(Widget w,XtPointer client_data,XtPointer  call_data)
{
  int             ii;
  Arg             args[32];
  Widget        complex_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  complexmenu[0].list = cell_list;
  complexmenu[3].list = account_list;

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  complex_popup = XtCreatePopupShell("complexpop", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  complex_form = XtCreateManagedWidget("form", formWidgetClass, complex_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_complexlabel=
        XtCreateManagedWidget("Configure Complexes",labelWidgetClass,complex_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_complexlabel); ii++;
  widget_complexmain=XtCreateManagedWidget("box",formWidgetClass,complex_form,
                                        args,ii);
/*
 exec=QmonAddButtonN(widget_complexmain,NULL,"Exec",pb_complexexec,NULL);
*/
 clear=QmonAddButtonN(widget_complexmain,NULL,"Reset",(XtCallbackProc)pb_complexclear,NULL);
 close=QmonAddButtonN(widget_complexmain,clear,"Close",(XtCallbackProc)pb_complexclose,NULL);

  widget_complexopt=createmenuoptions(complex_form,widget_complexmain,complexmenu,(XtCallbackProc)complexaction);
  
}


/***********************************************************
 * openwidget_complexsub - Open the complex menu
 */
void openwidget_complexsub()
{
  pb_complexclear(NULL,NULL,NULL);
  XtPopup(complex_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_complexsub - Close the complex menu
 */
void closewidget_complexsub()
{
  XtPopdown(complex_popup);
}
