static char globals_rcsid[]="$Id: globals.h,v 1.4 1997/08/13 17:34:28 decker Exp $";

/*----------------------------------------------------
 * globals.h Tom Green Mon Jan 31 10:44:30 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: globals.h,v $
 * Revision 1.4  1997/08/13 17:34:28  decker
 * Changes made to reflect version number 3.1.8
 *
 * Revision 1.3  1997/08/08 19:51:24  decker
 * Patch by Janssen for Linux
 *
 * Revision 1.2  1997/04/15 13:39:35  green
 * updated globals.h DQS_VERSION number
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.30  1996/11/20 23:04:58  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.29  1996/06/17  02:29:22  nrl
 * Updtaes from Guntram Wolski, Ron Lee, John Makosky and
 * Bodo Beckebach
 *
 * Revision 3.28  1996/04/11  12:12:20  nrl
 * Fixed compiling error discovered in alpha release
 *
 * Revision 3.27  1996/03/25  16:28:38  nrl
 * Repaired parameter scanning for qidle
 *
 * Revision 3.26  1996/03/19  23:27:31  nrl
 * added capability to clean up consumable resources whenthey
 * get out of sync with reality
 *
 * Revision 3.25  1996/03/17  00:58:01  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.24  1996/03/14  03:16:50  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.23  1996/03/12  17:12:59  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.22  1995/11/01  16:42:42  nrl
 * Added a global default mask exec_mask
 *
 * Revision 3.21  1995/03/03  21:39:27  nrl
 * Changhed version number to 3.1.2
 *
 * Revision 3.20  1995/02/09  22:44:14  nrl
 * Added "-mq" modify queue option
 *
 * Revision 3.19  1995/02/09  12:49:30  nrl
 * Added "delete complex" and "modify complex"
 *
 * Revision 3.18  1995/01/27  14:10:01  nrl
 * Changed Supspend on completion to continue beyond an unsuspend operation
 * so that jobs can be "stepped" thru the queues. Increased timout
 * retries for connect to make the system more tolerant of network delyas.
 *
 * Revision 3.17  1994/08/02  23:11:14  green
 * added support for a crude job staging mechanism
 *
 * Revision 3.16  1994/07/07  17:00:15  green
 * updated docs
 *
 * Revision 3.15  1994/07/05  14:32:31  green
 * Changed "Major" revision number
 *
 * Revision 3.14  1994/06/12  23:16:50  green
 * added "dsh" to prognames
 *
 * Revision 3.13  1994/06/09  18:38:24  green
 * had some problems with nonre-entrant gethostbyX in dqs_sec.c - fixed
 *
 * #def overload for "GENERIC" in def.h - fixed
 *
 * Revision 3.12  1994/06/09  14:25:08  green
 * yanked PVM after further digging through the PVM code decided there
 * might be potential problems(let somebody else worry with pvm if they
 * want it...)
 *
 * pulled out some sloaris #defs - maybe one day SUN will ship me my
 * compiler
 *
 * Revision 3.11  1994/06/08  17:48:22  green
 * added P4 support(with the help of Ralph Butler - Thanks Ralph!)
 *
 * backed down to Rev. 3.3 of dqs_check_to_do_list.c
 *
 * Revision 3.10  1994/06/07  16:45:41  green
 * more "sloaris" porting...
 *
 * Revision 3.9  1994/06/06  01:23:06  green
 * added "dqs_dshd_service" to the DQS config
 *
 * add "-par pvm" - though we do NOT intend to support it
 * (see dqs_start_pvm.c for a more thorough discussion)
 *
 * Revision 3.8  1994/06/04  15:24:31  green
 * added "-par parallel_packge" support
 *
 * Revision 3.7  1994/06/04  14:33:26  green
 * added "parallel_package" defs
 *
 * Revision 3.6  1994/06/02  13:44:31  green
 * attempt to port to Sloaris...
 * Work In Progress(WIPed)
 *
 * Revision 3.5  1994/05/31  10:00:39  green
 * zeroed out the "-exec" option
 *
 * Revision 3.4  1994/05/31  00:52:42  green
 * added dsh.c dshd.c to Makefile.proto
 *
 * added MAXNAMELEN and NCARGS to def.h
 *
 * type casting in dqs_reauth.c, dqs_sec.c, dqs_setup.c to hush gcc
 * warnings
 *
 * added jmp_buf to globals.h, changed Revision number in globals.h
 *
 * added dsh and dshd tp prognames.h
 *
 * Revision 3.3  1994/04/01  02:59:37  green
 * added "qalter" support
 *
 * Revision 3.2  1994/03/26  16:33:38  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.1  1994/03/23  20:11:45  green
 * updated Rev. number in globals.h
 *
 * Revision 3.0  1994/03/07  04:15:00  green
 * 3.0 freeze
 *
 * Revision 1.8  1994/02/28  03:03:13  green
 * added DEFAULT_MANAGER(2) to allow installs without root access.
 *
 * special character in def MAINPROGRAM causing some compilers to choke -
 * removed.
 *
 * Revision 1.7  1994/02/27  22:07:43  green
 * added DQS_VERSION to def.h and dqs_usage()
 *
 * Revision 1.6  1994/02/24  18:11:37  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.5  1994/02/23  16:18:19  green
 * resolved def conflicts in "prognames.h"
 *
 * added "QUSAGE" to globals.h
 *
 * Revision 1.4  1994/02/10  18:24:44  green
 * removed the following options from "qsub"
 *
 * 	-k
 * 	-p
 * 	-u
 * 	-z
 *
 * fixed the following options in "qsub"
 *
 * 	-e
 * 	-o
 * 	-N
 * 	-v
 *
 * synced with docs
 *
 * Revision 1.3  1994/02/09  19:48:20  green
 * syncing source with docs
 *
 * Revision 1.2  1994/02/02  20:22:26  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:49  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

extern int errno;
#if !(defined(__linux__) && defined (__GLIBC__) && __GLIBC__ >=2)
extern char *sys_errlist[];
#endif
#ifdef MAINPROGRAM
char DQS_VERSION[]="Revision: 3.1.8";
jmp_buf              env;
dqs_me_type          me;
dqs_conf_type        conf;
dqs_job_type         *options;
volatile int         DEBUG_ON=0;
volatile int         EXT_DEBUG_ON=0;
volatile int         DEBUG_INDENT=0;
volatile int         DEBUG_TRACEID=0;
volatile int         DEBUG_LOGLEVEL=0;
dqs_list_type        *Acl_head=NULL;
dqs_list_type        *Complex_head=NULL;
dqs_list_type        *Consumable_head=NULL;
dqs_list_type        *Host_head=NULL;
dqs_list_type        *Job_head=NULL;
dqs_list_type        *Man_head=NULL;
dqs_list_type        *Op_head=NULL;
dqs_list_type        *Queue_head=NULL;
dqs_list_type        *Resolver_head=NULL;
dqs_list_type        *Rusage_head=NULL;
dqs_list_type        *Tid_head=NULL;
dqs_list_type        *Child_head=NULL;
dqs_hash_type        *Acl_hash=NULL;
dqs_hash_type        *Complex_hash=NULL;
dqs_hash_type        *Consumable_hash=NULL;
dqs_hash_type        *Host_hash=NULL;
dqs_hash_type        *Job_hash=NULL;
dqs_hash_type        *Man_hash=NULL;
dqs_hash_type        *Op_hash=NULL;
dqs_hash_type        *Queue_hash=NULL;
sigset_t             default_mask;
sigset_t             omask;
sigset_t             io_mask;
sigset_t             exec_mask;
struct sigaction     sigterm_vec,  sigterm_ovec;
struct sigaction     sigalrm_vec,  sigalrm_ovec;
struct sigaction     sigcld_vec,   sigcld_ovec;
volatile int         SFD=0;  /* THIS PUPPY IS CLOSED ON SIGALRM */
volatile int         shut_me_down=0;
u_long32    dqs_unknown_int=999;
u_long32    dqs_zero=0;
u_long32    dqs_one=1;
u_long32    hash_bucket_size;
volatile int         dead_children=0;
volatile int         jobs_to_start=FALSE;
volatile int         reschedule=TRUE;
volatile int         sorted=FALSE;
char                 **envnew;
extern char          **environ;

char *prognames[]=
{
     
        "unknown",
        "qalter",
        "qconf",
        "qdel",
        "qhold",
        "qidle",
        "qmaster",
        "qmod",
        "qmove",
        "qmsg",
        "qrerun",
        "qrls",
        "qselect",
        "qsh",
        "qsig",
        "qstat",
        "qsub",
        "dqs_execd",
        "unknown",
        "unknown",
        "qusage",
        "dcmd",
        "dsh",
        "unknown",
        "unknown",
        "unknown",
        "unknown",
        "unknown",
};

char *queue_type[]={
        "unknown      ",
        "batch        ",
        "interactive  ",
        "bat-int      ",
        "parallel     ",
        "device       ",
        "unknown      ",
        "unknown      ",
   };

char *enable_states[]={
        "ENABLED      ",
        "DISABLED     ",
   };

char *true_false[]={
        "FALSE ",
        "TRUE  ",
        "unknown ",
   };

char *master_slave[]={
        "MASTER  ",
        "SLAVE   ",
        "UNKNOWN ",
   };

char *parallel_package[]={
        "NONE        ",
        "p4          ",
        "mpi         ",
        "generic_sla ",
        "generic_all ",
        "UNKNOWN ",
   };

char *log_levels[]={
        "LOG_EMERG    ",
        "LOG_ALERT    ",
        "LOG_CRIT     ",
        "LOG_ERR      ",
        "LOG_WARNING  ",
        "LOG_NOTICE   ",
        "LOG_INFO     ",
        "LOG_DEBUG    ",
        "LOG_EXTDEBUG ",
        "unknown      ",
        "unknown      ",
        "unknown      ",
        "unknown      ",
        "unknown      ",
   };

unsigned short dqs_options[][20]=
{
/*                  n    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    d    n    A
                    o    a    c    d    h    i    m    m    m    m    r    r    s    s    s    s    s    q    o    L
                    n    l    o    e    o    d    a    o    o    s    e    l    e    h    i    t    u    s    n    L
                    e    t    n    l    l    l    s    d    v    g    r    s    l         g    a    b    _    e    _
                         e    f         d    e    t         e         u         e              t         e         O
                         r                        e                   n         c                        x         P
                                                  r                             t                        e         T
                                                                                                         c
                                                                                                         d          
*/
/* no_OPT */        0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* a_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,   0,   0,   1,
/* A_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   1,   0,   0,   1,
/* B_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,
/* c_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* cell_OPT */      0,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,
/* C_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* e_OPT */         0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* par_OPT */       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   0,
/* E_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* f_OPT */         0,   0,   0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,
/* h_OPT */         0,   1,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   1,   0,   0,   1,
/* hard_OPT */      0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* j_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* k_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* l_OPT */         0,   1,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   1,   0,   1,   1,   0,   0,   1,
/* m_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* master_OPT */    0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* M_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* N_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,   0,   0,   1,
/* o_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* O_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* p_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,   0,   0,   1,
/* q_OPT */         0,   1,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   1,   0,   1,   1,   0,   0,   1,
/* Q_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* r_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   1,   0,   0,   1,
/* s_OPT */         0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0,   1,
/* soft_OPT */      0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* S_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* u_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   1,   0,   0,   0,   1,
/* v_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* verify_opt */    1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
/* V_OPT */         0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   0,   0,   1,
/* z_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* DESTIN_OPR */    0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* JOB_ID_OPR */    0,   0,   0,   1,   1,   0,   0,   0,   1,   1,   1,   1,   0,   0,   1,   0,   0,   0,   0,   1,
/* MESSAGE_OPR */   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* SCRIPT_OPR */    0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* SRVR_NM_OPR */   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* soc_OPT */       0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* xsoc_OPT */      0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* help_OPT*/       0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,
/* cwd_OPT */       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
/* ext_OPT */       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,
/* ul_OPT */        0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* reauth_OPT  */   0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   0,   0,
/* notify_OPT */    0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
/* passwd_OPT */    0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   1,   0,   0,
/* Passwd_OPT */    0,   1,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,   1,   0,   0,
/* d_opt */         0,   0,   0,   0,   0,   1,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* us_opt */        0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,

/*                  n    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    d    n    A
                    o    a    c    d    h    i    m    m    m    m    r    r    s    s    s    s    s    q    o    L
                    n    l    o    e    o    d    a    o    o    s    e    l    e    h    i    t    u    s    n    L
                    e    t    n    l    l    l    s    d    v    g    r    s    l         g    a    b    _    e    _
                         e    f         d    e    t         e         u         e              t         e         O
                         r                        e                   n         c                        x         P
                                                  r                             t                        e         T
                                                                                                         c
                                                                                                         d
*/

/* hold_jid_OPT */  0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* future_opt */    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/*                  n    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    d    n    A
                    o    a    c    d    h    i    m    m    m    m    r    r    s    s    s    s    s    q    o    L
                    n    l    o    e    o    d    a    o    o    s    e    l    e    h    i    t    u    s    n    L
                    e    t    n    l    l    l    s    d    v    g    r    s    l         g    a    b    _    e    _
                         e    f         d    e    t         e         u         e              t         e         O
                         r                        e                   n         c                        x         P
                                                  r                             t                        e         T
                                                                                                         c
                                                                                                         d
*/

/* ac_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* ah_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* am_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* ao_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* aq_OPT  */       0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* au_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* Aq_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* cq_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* dc_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* dh_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* dm_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* do_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* dq_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* du_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* kq_OPT */        0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* kqs_OPT */       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* mc_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* mconf_OPT */     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* mq_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* qmon_OPT */      0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sc_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* scl_OPT */       0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sconf_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sh_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sm_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* so_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sq_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sql_OPT */       0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* su_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sul_OPT */       0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* srl_opt */       0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,
/* jid_OPT */       0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* clean_OPT */     0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* gc_OPT */        0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* acons_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* mcons_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* dcons_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* gcons_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* scons_OPT */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* sconsl_OPT*/     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* refr_OPT  */     0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* shutd_OPT */     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* rc_OPT  */       0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* F_OPT */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   1,
/* g_OPT */         0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
/* empty */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* empty */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* empty */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* empty */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
/* empty */         0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,

/*                  n    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    q    d    n    A
                    o    a    c    d    h    i    m    m    m    m    r    r    s    s    s    s    s    q    o    L
                    n    l    o    e    o    d    a    o    o    s    e    l    e    h    i    t    u    s    n    L
                    e    t    n    l    l    l    s    d    v    g    r    s    l         g    a    b    _    e    _
                         e    f         d    e    t         e         u         e              t         e         O
                         r                        e                   n         c                        x         P
                                                  r                             t                        e         T
                                                                                                         c
                                                                                                         d
*/

};

#else

extern char          DQS_VERSION[];
extern jmp_buf       env;
extern dqs_me_type   me;
extern dqs_conf_type conf;
extern dqs_job_type  *options;
extern volatile int  DEBUG_ON;
extern volatile int  EXT_DEBUG_ON;
extern volatile int  DEBUG_INDENT;
extern volatile int  DEBUG_TRACEID;
extern volatile int  DEBUG_LOGLEVEL;
extern dqs_list_type *Acl_head;
extern dqs_list_type *Complex_head;
extern dqs_list_type *Consumable_head;
extern dqs_list_type *Host_head;
extern dqs_list_type *Job_head;
extern dqs_list_type *Man_head;
extern dqs_list_type *Op_head;
extern dqs_list_type *Queue_head;
extern dqs_list_type *Resolver_head;
extern dqs_list_type *Rusage_head;
extern dqs_list_type *Tid_head;
extern dqs_list_type *Child_head;
extern dqs_hash_type *Acl_hash;
extern dqs_hash_type *Complex_hash;
extern dqs_hash_type *Consumable_hash;
extern dqs_hash_type *Host_hash;
extern dqs_hash_type *Job_hash;
extern dqs_hash_type *Man_hash;
extern dqs_hash_type *Op_hash;
extern dqs_hash_type *Queue_hash;
extern sigset_t             default_mask;
extern sigset_t             omask;
extern sigset_t             io_mask;
extern sigset_t             exec_mask;
extern struct sigaction     sigterm_vec,  sigterm_ovec;
extern struct sigaction     sigalrm_vec,  sigalrm_ovec;
extern struct sigaction     sigcld_vec,   sigcld_ovec;
extern volatile int         SFD;  /* THIS PUPPY IS CLOSED ON SIGALRM */
extern volatile int         shut_me_down;
extern u_long32    dqs_unknown_int;
extern u_long32    dqs_zero;
extern u_long32    dqs_one;
extern u_long32    hash_bucket_size;
extern volatile int         dead_children;
extern volatile int         jobs_to_start;
extern volatile int         reschedule;
extern volatile int         sorted;
extern char **envnew;
extern char **environ;
extern char *prognames[];
extern char *queue_type[];
extern char *enable_states[];
extern char *true_false[];
extern char *master_slave[];
extern char *parallel_package[];

extern char *log_levels[];
extern unsigned short dqs_options[][20];

#endif
