// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: utils.cc,v 1.6 1998/06/06 03:39:09 jgg Exp $
/* ######################################################################

   General Utilities.
   
   ###################################################################### */
									/*}}}*/
// Includes								/*{{{*/
#include <deity/utils.h>
#include <deity/graphics.h>
#include <system.h>

#include <string>
#include <iostream.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

									/*}}}*/

// ReAttachStreams - Reconnects cout, clog and cerr for textmode	/*{{{*/
// ---------------------------------------------------------------------
/* This routine remaps clog to /dev/null or whatever fd 2 is. All debug
   output should go to clog, cout and cerr are left untouched. Outputting
   to cerr/cout will cause problems in text mode if the display isn't restored.
   
   Use something like 'myprog 2> log' in your shell to see the output.
 */
#include <errno.h>
void ReAttachStreams()
{
   // Stderr isnt stdout so we just point clog to cerr.
   string Err;
   if (ttyname(STDERR_FILENO) != 0)
      Err = ttyname(STDERR_FILENO);
   string Out;
   if (ttyname(STDOUT_FILENO) != 0)
      Out = ttyname(STDOUT_FILENO);
   
   // Remap if stderr isnt a fd or if it isnt the same as stdout
   if (Err != Out)
   {
      clog.rdbuf(cerr.rdbuf());
      clog << "Logging initiated" << endl;
      return;
   }
   
                 
   // Dont fiddle with the output in graphics mode
   if (TextGC::GC == 0)
      return;
   
   // We map everything to /dev/null
   int Fd = open("/dev/null",O_WRONLY | O_CREAT | O_TRUNC);
   if (Fd <= 0)
   {
      cerr << "Unable to open /dev/null!" << endl;
      exit(0);
   }

   // Point to the new streambuf at /dev/null
   streambuf *Buf = new filebuf(Fd);
   clog.rdbuf(Buf);
}
									/*}}}*/
// ChildrenExtent - Returns the widget size to fit all children		/*{{{*/
// ---------------------------------------------------------------------
/* This computes the size of the widget needed to fit all of the children
   and it's borders */
Point ChildrenExtent(Widget *Target)
{
   Rect Area = Target->Size();
   Area.w = 1;
   Area.h = 1;
   for (Widget::iterator I = Target->children(); I.end() == false; I++)
   {
      I->Extent();
      Area.w = MAX(I->Loc().x2,Area.w);
      Area.h = MAX(I->Loc().y2,Area.h);
   }

   Area.w += 2*Target->Borders().x;
   Area.h += 2*Target->Borders().y;

   return Point(Area.w,Area.h);
}
									/*}}}*/
// HorizontalLayout - Horizontal Children layout			/*{{{*/
// ---------------------------------------------------------------------
/* Organize all of the children in a horizontal line -- this should not 
   be in the class. */
void HorizontalLayout(Widget *Target,long Spacing)
{
   long X = 0;
   for (Widget::iterator I = Target->children(); I.end() == false; I++)
   {
      I->Extent();
      Rect Pos = I->Pos;
      Pos.x = X;
      Pos.y = 0;
      X += Pos.w + Spacing;
      I->Resize(Pos);
   }   
}
									/*}}}*/
// VerticalLayout - Vertical children layout				/*{{{*/
// ---------------------------------------------------------------------
/* Organize all of the children in a vertical line -- this should not be
   in the class */
long VerticalLayout(Widget *Target,long Spacing,bool SameSize)
{
   long Y = 0;
   long Width = 0;
   for (Widget::iterator I = Target->children(); I.end() == false; I++)
   {
      I->Extent();
      Width = MAX(Width,I->Pos.w);
   }   
   
   for (Widget::iterator I = Target->children(); I.end() == false; I++)
   {
      Rect Pos = I->Pos;
      Pos.y = Y;
      Pos.x = 0;
      if (SameSize == true)
	 Pos.w = Width;
      Y += Pos.h + Spacing;
      I->Resize(Pos);
   }   
   return Width;
}
									/*}}}*/
// CurrentTime - Return the current time				/*{{{*/
// ---------------------------------------------------------------------
/* */
double GetCurrentTime()
{
   struct timeval Now;
   gettimeofday(&Now,0);
   return Now.tv_sec + (double)(Now.tv_usec)/1000000.0;
}
									/*}}}*/
