// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: textwidg.cc,v 1.18 1998/06/21 03:25:08 jgg Exp $
/* ######################################################################

   Text String - Text String Widget
   Text Menu Item - Text Menu Item
   
   Extenting the string will set it's dimensions to be the largest size
   the string will occupy when rendered.
   
   ##################################################################### */
									/*}}}*/
#include <deity/textwidg.h>

// TextWidget::TextWidget - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
TextWidget::TextWidget(string iString,Widget *Parent) : BasicWidget(Parent), 
           iString(iString), iDrawFlags(0)
{
   BorderWidth(0);
   Flag(MouseTransparent);
}
									/*}}}*/
// TextWidget::TextWidget - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
TextWidget::TextWidget(Widget *Parent) : BasicWidget(Parent), iDrawFlags(0)
{
   BorderWidth(0);
   Flag(MouseTransparent);
}
									/*}}}*/
// TextWidget::IdealSize - Compute the size				/*{{{*/
// ---------------------------------------------------------------------
/* */
Point TextWidget::IdealSize()
{
   // Extent the text
   GenGC::GC->SetFont(iFont);
   Rect SSize = GenGC::GC->ExtentText(iString);
   return Point(SSize.w + 2*iMargins.x + 2*BorderX,SSize.h + 2*iMargins.y + 2*BorderY);
}
									/*}}}*/
// TextWidget::Render - Draws the string				/*{{{*/
// ---------------------------------------------------------------------
/* */
void TextWidget::Render(CombinedGC &GC)
{
   BasicRender(GC,true);

   GC->DrawString(Rect(BorderX + iMargins.x,BorderY + iMargins.y,
		       Pos.w - 2*(BorderX + iMargins.x),
		       Pos.h - 2*(BorderY + iMargins.y)),iString,iDrawFlags);
}
									/*}}}*/
// TextWidget::Text - Change the text string				/*{{{*/
// ---------------------------------------------------------------------
/* */
void TextWidget::Text(string Text)
{
   iString = Text;
   Damage();
}
									/*}}}*/

// MenuItem::MenuItem - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* We override the colors to match the default menu colors. */
MenuItem::MenuItem(string iString,Widget *Parent) :
             TextWidget(iString,Parent), HotKey(0), HasChild(false)
{
   if (GraphicGC::GC != 0)
      Margins(Point(2,1));
   else
      Margins(Point(1,0));
   
   if (GraphicGC::GC != 0)
      iBoldColor = Wc_Blue;
   else
      iBoldColor = Wc_BrightBlue;
   iActiveTextColor = Wc_White;
   iActiveColor = Wc_Blue;
   Flag(ShowFocus | Focusable | ParentKeys);
   Flag(0,MouseTransparent);

   // Strip the string of special chars
   HotKey = Accel = iString.size();
   for (const char *I = iString.begin(); I != iString.end(); I++)
   {
      if (*I == '&' && I + 1 != iString.end())
	 HotKey = I - iString.begin();
      if (*I == '\t' && I + 1 != iString.end())
	 Accel = I -iString.begin();
   }
   if (HotKey > Accel)
      HotKey = Accel;
}
									/*}}}*/
// MenuItem::Render - Change the color to match the focus		/*{{{*/
// ---------------------------------------------------------------------
/* */
void MenuItem::Render(CombinedGC &GC)
{
   // Select the proper colours
   Color Cur;
   Color OldBack = iBackground;
   if (Focus() == true)
   {
      iBackground = iActiveColor;
      Cur = iActiveTextColor;
   }   
   else
      Cur = iColor;

   // Draw the backround
   BasicRender(GC,true);   
   iBackground = OldBack;

   // Draw the string highliting the hotkey
   GC->SetFont(iFont);
   GC->SetColor(Cur);

   // Create a bolded font
   SimpleFont BoldFont = iFont;
   BoldFont.Weight = SimpleFont::Bold;
   
   // Draw the text before the &
   Point Pos = iMargins;
   GC->DrawText(Pos,iString.begin(),HotKey);
   
   // Draw the text at the &
   if (HotKey + 1 >= iString.size())
       return;
   Rect Size = GC->ExtentText(iString.begin(),HotKey);
   Pos.x += Size.w;
   if (Cur == iColor)
      GC->SetColor(iBoldColor);
   GC->DrawText(Pos,iString.begin() + HotKey + 1,1);

   // Draw the text up to the accelerator
   if (HotKey + 2 >= iString.size())
       return;
   Size = GC->ExtentText(iString.begin()+HotKey+1,1);
   Pos.x += Size.w;
//   if (GC.IsText() == true)
      GC.GC->SetColor(Cur);
   GC->DrawText(Pos,iString.begin() + HotKey + 2,Accel - HotKey - 2);
   
   // Draw the accelerator right aligned
   if (Accel + 1 >= iString.size())
       return;
   GC->SetFont(BoldFont);
   if (GC.IsText() == true && Cur == iColor)
      GC.tGC->SetColor(iBoldColor);

   Size = GC->ExtentText(iString.begin()+Accel + 1,iString.size() - Accel - 1);
   Pos.x = this->Pos.w - Size.w;
   if (GC.IsGraphic() == true)
      Pos.x -= 2;
   GC->DrawText(Pos,iString.begin() + Accel + 1, iString.size() - Accel - 1);
}
									/*}}}*/
// MenuItem::Key - Key handler						/*{{{*/
// ---------------------------------------------------------------------
/* We set parent keys so we see any unprocessed keys that pass by the
   parent. We then check them for hotkey matches */
bool MenuItem::Key(const KeyEvent &Key,Widget *Source)
{
   if (Source == this && Key.Extended == KeyEvent::Enter)
   {
      if (Child == 0)
      {
	 for (Widget *I = Parent; I != 0; I = I->Parent)
	    I->FocusRestore();
	 Trigger(Nt_Action,0);
	 return true;
      }
   }
   
   if (Source == this && (Key.Extended == KeyEvent::Down || 
			  Key.Extended == KeyEvent::Enter))
   {
      if (Child != 0)
      {
	 Drop();
	 return true;
      }
      
      return false;
   }   
   
   /* Handle hot key events, We only allow hotkeys that missed a focus widget
      at the same level, ie the top menu bar will ignore the sub menus */
   if (Source->Parent == Parent && Key.IsPrintable() == true && 
       toupper(Key.Key) == toupper(iString[HotKey+1]))
   {
      if (Focus() == true)
      {
	 for (Widget *I = Parent; I != 0; I = I->Parent)
	    I->FocusRestore();
      }
      else
	 GiveFocus();
      
      return true;
   }
   
   return false;
}
									/*}}}*/
// MenuItem::Mouse - Mouse handler					/*{{{*/
// ---------------------------------------------------------------------
/* This keeps a static var for tracking the mouse history. This is
   okay because there is only one mouse. */
void MenuItem::Mouse(const MouseEvent &Event)
{
   static MenuItem *DropWidg = 0;
   
   // On a down we drop the list
   if (Event.IsDn() == true)
   {
      if (HasChild == true || Child != 0)
	 DropWidg = this;
      Drop();
   }

   // This will remove any drop down widgets on a drag release
   if (Event.IsUp() == true && Event.IsClick() == false)
   {
      if (DropWidg == this)
	 return;
      
      Parent->Flag(0,MenuDrop);
      for (Widget *I = Parent; I != 0; I = I->Parent)
	 I->FocusRestore();
      Trigger(Nt_Action,0);
   }

   // This will focus the widget if the mouse is moved over it (drag)
   if (Event.IsMotion() == true &&
       Event.IsButtonDn(MouseEvent::Select) == true)
   {
      if (DropWidg != this)
	 DropWidg = 0;
      if (Focus() == false)
	 GiveFocus();
   }
   
   if (Event.IsClick() == true)
   {
      if (DropWidg == this)
	 return;
      
      if (Child == 0 && IsFlag(ForceFocus) == false && Focus() == true)
      {
	 for (Widget *I = Parent; I != 0; I = I->Parent)
	    I->FocusRestore();
	 Trigger(Nt_Action,0);
      }
      
      if (IsFlag(ForceFocus) == true)
      {
	 Parent->Flag(0,MenuDrop);
	 for (Widget *I = Parent; I != 0; I = I->Parent)
	    I->FocusRestore();
      }
   }   
}
									/*}}}*/
// MenuItem::FocusLost - Loss of focus					/*{{{*/
// ---------------------------------------------------------------------
/* We unrealize any sub-menu we might happen to have. We record the status
   of the submenu in the parent so that hitting 'left' on a dropped down
   menu will bring down the next focus items menu. The parent should clear
   this bit when it loses focus. */
void MenuItem::FocusLost(Widget *)
{
   if (Child == 0)
      return;

   if (Child->Realized == false)
      Parent->Flag(0,MenuDrop);
}
									/*}}}*/
// MenuItem::FocusGained - Gain of focus				/*{{{*/
// ---------------------------------------------------------------------
/* */
void MenuItem::FocusGained(Widget *)
{
   if (Child != 0 && Parent->IsFlag(MenuDrop) == true)
      Drop();
}
									/*}}}*/
// MenuItem::Drop - Open a sub menu					/*{{{*/
// ---------------------------------------------------------------------
/* HasChild is a bit of a hack, it should be more automatic somehow.. */
void MenuItem::Drop()
{
   if (Child != 0)
   {
      Child->Pos.y = Parent->Pos.h - Pos.y - Parent->BorderY;
      Child->Pos.x = 0;
      Child->RealizeFamily();
      Parent->Flag(MenuDrop);
      HasChild = true;
   }
}
									/*}}}*/
// MenuItem::IdealSize - Compute the size minus &			/*{{{*/
// ---------------------------------------------------------------------
/* */
Point MenuItem::IdealSize()
{
   Point P = TextWidget::IdealSize();
   if (HotKey != iString.size())
   {
      Rect Size = GenGC::GC->ExtentText("&",1);
      return Point(P.x - Size.w,P.y);
   }
   return P;
}
									/*}}}*/

// HelpMenuItem::HelpMenuItem - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
HelpMenuItem::HelpMenuItem(string iString,Widget *Parent) : 
                 MenuItem(iString,Parent)
{
   Flag(AutoExtent);
}
									/*}}}*/
// HelpMenuItem::Resize - Forces the menu item to be to the right	/*{{{*/
// ---------------------------------------------------------------------
/* */
void HelpMenuItem::Resize(Rect Pos)
{
   Pos.x = Parent->CanvasSize().x - Pos.w;
   MenuItem::Resize(Pos);
}
									/*}}}*/

// CheckMenuItem::CheckMenuItem - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* Add support for check marks */
CheckMenuItem::CheckMenuItem(string iString,Widget *Parent) : 
             MenuItem(iString,Parent), Check(false)
{
}
									/*}}}*/
// CheckMenuItem::IdealSize - Compute the size				/*{{{*/
// ---------------------------------------------------------------------
/* */
Point CheckMenuItem::IdealSize()
{
   Point P = MenuItem::IdealSize();

   GenGC::GC->SetFont(SimpleFont("open look glyph",100));
   return Point(P.x + GenGC::GC->ExtentText("u",1).w + 2*iMargins.x,P.y);
}
									/*}}}*/
// CheckMenuItem::Render - Draw the checkmark				/*{{{*/
// ---------------------------------------------------------------------
/* */
void CheckMenuItem::Render(CombinedGC &GC)
{
   // Determine the size of the checkmark glyph
   long Size = 1;
   Rect Clip = GC->GetClipping();
   if (GC.IsGraphic() == true)
   {
      // Select the X win glyph font, this will render a check mark
      GC->SetFont(SimpleFont("open look glyph",100));
      
      // Offset the normal menu text
      Size = GC->ExtentText("u",1).w + iMargins.x;
   }
   
   // Set a new offset/clip region
   Clip.x = Size;
   Clip.w -= Size;
   Clip.y = 0;
      
   // Draw the menu item, offset to the right a bit.
   GC->AddClipping(Clip);
   MenuItem::Render(GC);
   GC->PopClipping();
   
   // Use an open look glyph font in graphics mode
   if (GC.IsGraphic() == true)
   {
      // Set the fill color
      if (Focus() == true)
	 GC->SetColor(iActiveColor);
      else
	 GC->SetColor(iBackground);
      GC->Fill(AbsRect(BorderX,BorderY,Size,Pos.h - BorderY));

      if (IsFlag(Set) == false)
	 return;
      
      // Set the text colour
      if (Focus() == true)
	 GC->SetColor(iActiveTextColor);
      else
	 GC->SetColor(iColor);
      
      GC->SetFont(SimpleFont("open look glyph",100));
      GC->DrawString(Point(iMargins.x,iMargins.y + 1),"u");
   }
   
   // Draw a * char in text mode
   if (GC.IsText() == true)
   {
      if (IsFlag(Set) == true)
	 GC->DrawString(iMargins,"*");
      else
	 GC->DrawString(iMargins," ");
   }   
}
									/*}}}*/

// Separator::Separator - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* Disabling focusable prevents us from ever getting focus. */
Separator::Separator(Widget *Parent = 0) : BasicWidget(Parent)
{
   Flag(0,Focusable);
   if (GraphicGC::GC != 0)
      Pos.h = 4;
   if (TextGC::GC != 0)
      Pos.h = 1;
   ExtentMode(ExtentOnce,ExtentNever);
}
									/*}}}*/
// Separator::Render - Draw the bar					/*{{{*/
// ---------------------------------------------------------------------
/* In text mode the line is a simple text line, in graphics mode it is
   a 2 pixel 3d bar */
void Separator::Render(CombinedGC &GC)
{
   if (GC.IsText() == true)
   {
      GC.tGC->SetColor(iColor);
      GC.tGC->Background(iBackground);
      GC.tGC->HLine(Point(0,0),Pos.w);
   }

   if (GC.IsGraphic() == true)
   {
      GC.gGC->SetColor(iBorderUl);
      long Center = (Pos.h-2)/2;
      GC.gGC->Line(Point(0,Center),Point(Pos.w,Center));
      GC.gGC->SetColor(iBorderLr);
      GC.gGC->Line(Point(0,Center+1),Point(Pos.w,Center+1));
   }   
}
									/*}}}*/

