// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: fileutl.cc,v 1.3 1998/05/01 03:58:38 jgg Exp $
/* ######################################################################
   
   File Utilities
   
   CopyFile - Buffered copy of a single file
   GetLock - dpkg compatible lock file manipulation (fcntl)
   
   This source is placed in the Public Domain, do with it what you will
   It was originally written by Jason Gunthorpe.
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#include <fileutl.h>
#include <pkglib/error.h>

#include <unistd.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/types.h>
									/*}}}*/

// CopyFile - Buffered copy of a file					/*{{{*/
// ---------------------------------------------------------------------
/* */
bool CopyFile(string From,string To)
{
   // Open the from file
   int Ffd = open(From.c_str(),O_RDONLY);
   if (Ffd < 0)
      return _error->Errno("open","Couldn't open %s",From.c_str());
   
   // Remove the to file (could be a link..) and create the to file
   unlink(To.c_str());
   int Tfd = open(To.c_str(),O_WRONLY | O_CREAT | O_TRUNC,0666);
   if (Tfd < 0)
   {
      close(Ffd);
      _error->Errno("open","Couldn't open %s",To.c_str());
      return false;
   }
   
   // Buffered copy between fds
   unsigned char *Buf = new unsigned char[64000];
   long Size;
   while ((Size = read(Ffd,Buf,64000)) > 0)
   {
      if (write(Tfd,Buf,Size) != Size)
      {
	 _error->Errno("open","IO error in copy %s to %s",From.c_str(),To.c_str());
	 close(Tfd);
	 close(Ffd);
	 unlink(To.c_str());
	 delete [] Buf;
	 return false;
      }
   }
   close(Tfd);
   close(Ffd);
   delete [] Buf;
   return true;
   
}
									/*}}}*/
// GetLock - Gets a lock file						/*{{{*/
// ---------------------------------------------------------------------
/* This will create an empty file of the given name and lock it. Once this
   is done all other calls to GetLock in any other process will fail with
   -1. The return result is the fd of the file, the call should call
   close at some time. */
int GetLock(string File,bool Errors)
{
   int FD = open(File.c_str(),O_RDWR | O_CREAT | O_TRUNC,0640);
   if (FD < 0)
   {
      if (Errors == true)
	 _error->Errno("open","Could not open lock file %s",File.c_str());
      return -1;
   }
   
   // Aquire a write lock
   struct flock fl;
   fl.l_type= F_WRLCK;
   fl.l_whence= SEEK_SET;
   fl.l_start= 0;
   fl.l_len= 1;
   if (fcntl(FD,F_SETLK,&fl) == -1)
   {
      if (Errors == true)
	 _error->Errno("open","Could not get lock %s",File.c_str());
      close(FD);
      return -1;
   }

   return FD;
}
									/*}}}*/
// FileExists - Check if a file exists					/*{{{*/
// ---------------------------------------------------------------------
/* */
bool FileExists(string File)
{
   struct stat Buf;
   if (stat(File.c_str(),&Buf) != 0)
      return false;
   return true;
}
									/*}}}*/
// SafeGetCWD - This is a safer getcwd that returns a dynamic string	/*{{{*/
// ---------------------------------------------------------------------
/* We return / on failure. */
string SafeGetCWD()
{
   // Stash the current dir.
   char S[300];
   S[0] = 0;
   if (getcwd(S,sizeof(S)) == 0)
      return "/";
   return S;
}
									/*}}}*/
