// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: pkglistvect.h,v 1.7 1997/05/27 04:50:20 jgg Exp $
/* ######################################################################

   Package List Vector - Ordered Package list in main memory, stored in a 
                         vector

   This class is the basic package list. It implements transient memory 
   storage of an ordered list of items.
   
   No new methods.

   ##################################################################### */
									/*}}}*/
// Public header
#ifndef PKGLISTVECT_H
#define PKGLISTVECT_H

#include <pkglib/pkglist.h>

class pkgPkgListVect : public pkgPkgListOrdered
{
   vector<pkgSPkgCtrlInfo> List;
   
   protected:

   // Private iterator representation.
   class priv_iterator : public pkgPkgList::priv_iterator
   {
      // All we need to know to iterate is the current 
      vector<pkgSPkgCtrlInfo>::iterator Itr;
      vector<pkgSPkgCtrlInfo>::iterator End;
      
      public:

      virtual bool Next();      
      priv_iterator(vector<pkgSPkgCtrlInfo> &List);
   };
   
   public:

   // Index by Name 
   virtual pkgSPkgCtrlInfo Find(string Name) const;
   virtual pkgSPkgCtrlInfo Find(const pkgElement &Target) const;
   virtual pkgPkgList::iterator begin();
   
   // General Info
   virtual signed long Size() {return List.size();};

   // Insertion
   virtual void Add(pkgSPkgCtrlInfo &Info) {List.push_back(Info);};
   virtual void push_front(pkgSPkgCtrlInfo &Info) {List.insert(List.begin(),Info);};
   virtual void push_back(pkgSPkgCtrlInfo &Info) {List.push_back(Info);};
   virtual void insert(pkgPkgList::iterator Spot,pkgSPkgCtrlInfo &Item);   
};

#endif
