// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: pkgcachemerge.h,v 1.7 1998/04/08 23:20:46 jgg Exp $
/* ######################################################################
   
   Cache Merge - Class to merge package files into the cache file.
   
   This header is only needed if multiple files are to be merged. the
   pkgCache::MergePackageFile member is usually acceptable.

   ##################################################################### */
									/*}}}*/
// Header section: pkglib
#ifndef PKGLIB_CACHEMERGE_H
#define PKGLIB_CACHEMERGE_H

#include <sys/types.h>
#include <map>
#include <vector>
#include <pkglib/pkgcache.h>
#include <pkglib/pkglist.h>

class pkgCache::MergeState
{
   // The file we are merging into
   string FileName;
   string PkgFileName;
   
   // The cache file
   int Fd;
   off_t CurOffset;
   
   // This stores each package currently in the cache file and its index
   typedef map<string,unsigned long,less<string> > NameMap_t;
   NameMap_t NameMap;
   
   // This stores the stringlist
   NameMap_t StringMap;
   
   vector<string> Lines;

   // Parser Helper
   struct WordList
   {
      char *Str;
      unsigned char Val;
   };
   
   // Various current item structures
   Header Head;
   Package CurPackage;
   Version CurVersion;
   unsigned long VerOffset;
   unsigned long PkgOffset;
   unsigned long TopLine;
   unsigned long FileOffset;

   // Writers
   unsigned long EmitString(string Str);
   unsigned long EmitUniqueString(string Str);
   unsigned long eseek(unsigned long Pos);
   bool eread(void *Data,unsigned long Size);
   bool ewrite(const void *Data,unsigned long Size);
   unsigned long elwrite(const void *Data,unsigned long Size);
   
   // High-level manipulators
   int AllocatePool(unsigned long Size,int Number);
   bool SetVersion(string Version,Version &CurVersion,
		   unsigned long &VerOffset,unsigned long FileOffset);
   bool ProcessDepends(vector<string> &Lines,unsigned char Type);
   bool ProcessProvides(vector<string> &Lines);
   bool ProcessStatus(string State);
   bool ProcessTargetVersion(string Ver);
   unsigned long GetPackageIndex(string Name,Package &Pack,bool Read = true);
   bool GrabWord(string Word, WordList *List, int Count,unsigned char &Out);
   bool SortVersions(pkgCache &Cache);
   bool GenReverseDepends(pkgCache &Cache);
   
   public:

   inline unsigned long Hash(string S) const {return pkgCache::sHash(S);};
   inline unsigned long Hash(const char *S) const {return pkgCache::sHash(S);};

   bool MergePackage(pkgTextElmReader &Reader);
   bool SelectFile(string File,string Dist,string Version,unsigned long Flags = 0);
   bool MergePackageFile(string FileName,string Dist,string Revision,unsigned long Flags = 0);

   MergeState(string FileName);
   ~MergeState();
};

#endif
