// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: selectloop.h,v 1.4 1997/10/25 04:49:53 jgg Exp $
/* ######################################################################
   
   Select Loop - Class to allow mulitple sockets to be monitored at once
   SelectLoop::Fd - Selectable file descriptor

   These two classes are used to allow multiple FD's to stream data into
   a number of different locations.
   
   Deriving a class from SelectLoop::Fd and overriding Read/Write and 
   Error will allow you to recive data on that particular Fd when it is 
   ready. The procedures will be called whenever select reports that the
   socket is ready.

   The proper procudure for handling signals is to catch the signal
   with AddSignal. AddSignal will allow the signal to interrupt select 
   (it will be remasked after select). If select is interrupted by a signal
   then it will call Signal for each fd. Signal will not be called for 
   signals that did not occure during the select call however.

   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_SELECTLOOP_H
#define DEITY_SELECTLOOP_H

class SelectLoop
{   
   public:   
   
   // Derive to get FD processing abilities
   class Fd
   {
      friend SelectLoop;

      protected:
      Fd *Next;
      
      bool ReadFlag;
      bool WriteFlag;
      bool ErrorFlag;
      bool SignalFlag;
      
      int FileDesc;
      
      virtual bool Read(SelectLoop &) {return false;};
      virtual bool Write(SelectLoop &) {return false;};
      virtual bool Error(SelectLoop &) {return false;};
      virtual bool Signal(SelectLoop &) {return false;};
      virtual void Setup(SelectLoop &) {};

      public:

      Fd(int Fd,bool Read = false, bool Write = false, 
	 bool Error = false, bool Signal = false);
      virtual ~Fd() {};
   };   
 
   private:
   
   // Linked List of FDs
   Fd *List;
   
   // List of signal handlers
   typedef void (*SigHandler)(int);
   struct Sig
   {
      int Signal;
      SigHandler Handler;
   };

   static Sig Signals[10];
   static SigHandler DeathHandlers[10];
   static bool Triged;
   static void SignalHandler(int Signal);
   static void DeathHandler(int Signal);
   
   public:
   
   bool Quit;
   
   // Main loop
   bool Loop();
   
   // List manipulators
   void Add(Fd *FD);
   void AddSignal(int Sig,SigHandler Handler);
   void AddDeathHandler(SigHandler Handler);
   
   // Construct/destruct
   SelectLoop();
   ~SelectLoop();
};

#endif
