// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: button.h,v 1.9 1998/01/24 02:54:54 jgg Exp $
/* ######################################################################

   BasicButton - Simple button
   TextButton - Textual button
   
   Basic Button provide the basic functions of a button, such as borders,
   click handling and notification. TextButton contains a single child, 
   TextWidget that draws the button contents.
   
   The single child -must- be derived from BasicWidget!

   Triggers: Nt_State, Nt_Action
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_BUTTON_H
#define DEITY_BUTTON_H

#include <deity/basic.h>

// Notifications generated by BasicButton
#define Nt_State Notifyer::Tag(BasicButton::Type,1) // Data -> IsFlag(Wf_Set), Toggle button only

class BasicButton : public BasicWidget
{
   protected:

   Color iDepressed;
   bool OldState;
   
   virtual void Render(CombinedGC &GC);
   virtual bool Key(const KeyEvent &Key,Widget *Source);
   virtual void Mouse(const MouseEvent &Event);
   virtual Point IdealSize();
   
   public:
   static void *Type;
   
   void Set(bool State);
   
   BasicButton(Widget *Parent = 0);
};

class TextButton : public BasicButton
{
   public:

   TextButton(string Text,Widget *Parent = 0);
};

#endif
