// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: extracache.cc,v 1.16 1998/03/02 01:43:35 jgg Exp $
/* ######################################################################

   ExtraCache - Extension data for the cache
   
   This class stores the cache data and a set of extension structures for
   monitoring the current state of all the packages.
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#include "extracache.h"
#include "policy.h"

#include <pkglib/error.h>
									/*}}}*/

ExtraCache *ExtraCache::SortCache = 0;

// ExtraCache::ExtraCache - Constructors				/*{{{*/
// ---------------------------------------------------------------------
/* */
ExtraCache::ExtraCache(Policy &Pol,string CacheFile,bool Public,bool ReadOnly) :
	     pkgDepCache(CacheFile,Public,ReadOnly), 
             SortedPkgs(0), SecSortedPkgs(0), CurPolicy(Pol)
{
   if (_error->PendingError() == false)
      Init();
}

ExtraCache::ExtraCache(Policy &Pol,bool Public,bool ReadOnly) :
	     pkgDepCache(Public,ReadOnly), 
             SortedPkgs(0), SecSortedPkgs(0), CurPolicy(Pol)
{
   if (_error->PendingError() == false)
      Init();
}
									/*}}}*/
// ExtraCache::~ExtraCache - Destructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
ExtraCache::~ExtraCache()
{
   delete [] SortedPkgs;
   delete [] SecSortedPkgs;
}
									/*}}}*/
// ExtraCache::ReMap - Regenerate the extra data for the new cache	/*{{{*/
// ---------------------------------------------------------------------
/* pkgCache's constructors call this function, but because the object is not
   fully constructed at that point it will not result in this function being
   called but pkgCache::ReMap will be instead.*/
bool ExtraCache::ReMap()
{
   if (pkgCache::ReMap() == false)
      return false;
   
   return Init();
}
									/*}}}*/
// ExtraCache::NameComp - QSort compare by name				/*{{{*/
// ---------------------------------------------------------------------
/* */
int ExtraCache::NameComp(const void *a,const void *b)
{
   const Package &A = **(Package **)a;
   const Package &B = **(Package **)b;

   return strcmp(SortCache->StrP + A.Name,SortCache->StrP + B.Name);
}
									/*}}}*/
// ExtraCache::SecNameComp - Compare by name and then by section	/*{{{*/
// ---------------------------------------------------------------------
/* */
int ExtraCache::SecNameComp(const void *a,const void *b)
{
   const Package &A = **(Package **)a;
   const Package &B = **(Package **)b;

   // Sort by section first
   if (A.Section == B.Section)
      return strcmp(SortCache->StrP + A.Name,SortCache->StrP + B.Name);
   return strcmp(SortCache->StrP + A.Section,SortCache->StrP + B.Section);
}
									/*}}}*/
// ExtraCache::Init - Generate the initial extra structures.		/*{{{*/
// ---------------------------------------------------------------------
/* This allocats the extension buffers and then sorts the packages two
   ways. */
bool ExtraCache::Init()
{
   // Grab some memory including space for the trailing null
   delete [] SortedPkgs;
   delete [] SecSortedPkgs;
   SortedPkgs = new Package *[Head().PackageCount + 1];
   SecSortedPkgs = new Package *[Head().PackageCount + 1];
   
   // Initialize both lists
   int J = 0;
   for (PkgIterator I = PkgBegin(); I.end() != true; I++, J++)
      SortedPkgs[J] = SecSortedPkgs[J] = I;
   SortedPkgs[J] = SecSortedPkgs[J] = 0;

   // Sort them
   SortCache = this;
   qsort(SortedPkgs,J,sizeof(*SortedPkgs),NameComp);
   qsort(SecSortedPkgs,J,sizeof(*SecSortedPkgs),SecNameComp);

   return true;
} 
									/*}}}*/
// ExtraCache::GetCandidateVer - Returns the Candidate install version	/*{{{*/
// ---------------------------------------------------------------------
/* */
ExtraCache::VerIterator ExtraCache::GetCandidateVer(PkgIterator Pkg)
{
   return CurPolicy.GetCandidateVer(Pkg);
};
									/*}}}*/
// ExtraCache::IsImportantDep - True if the dep is important		/*{{{*/
// ---------------------------------------------------------------------
/* */
bool ExtraCache::IsImportantDep(DepIterator Dep)
{
   return CurPolicy.IsImportantDep(Dep);
};
									/*}}}*/
