#ifndef	VAT_GSM_H
#define	VAT_GSM_H

#ifndef PRIVATE_H
typedef short		word;			/* 16 bit signed int	*/
typedef int		longword;		/* 32 bit signed int	*/

typedef unsigned short	uword;			/* unsigned word	*/
typedef unsigned int	ulongword;		/* unsigned longword	*/

struct gsm_state {

	word		dp0[ 280 ];

	word		z1;		/* preprocessing.c, Offset_com. */
	longword	L_z2;		/*                  Offset_com. */
	int		mp;		/*                  Preemphasis	*/

	word		u[8];		/* short_term_aly_filter.c	*/
	word		LARpp[2][8]; 	/*                              */
	word		j;		/*                              */

	word		ltp_cut;	/* long_term.c, LTP crosscorr.  */
	word		nrp; /* 40 */	/* long_term.c, synthesis	*/
	word		v[9];		/* short_term.c, synthesis	*/
	word		msr;		/* decoder.c,	Postprocessing	*/

	char		verbose;
	char		fast;
};
#endif

typedef struct gsm_state 	gsm_state;
typedef unsigned char		gsm_byte;
typedef unsigned char		ulaw_byte;

#define	GSM_MAGIC	0xD			  	/* 13 kbit/s RPE-LTP */

extern void Vat_Gsm_InitS(gsm_state *);
extern void Vat_Gsm_InitR(gsm_state *);
extern void Vat_Gsm_Encoder(gsm_state *, const ulaw_byte *, gsm_byte*);
extern void Vat_Gsm_Decoder(gsm_state *, ulaw_byte *, const gsm_byte *);

#endif	/* GSM_H */
