/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 * 	This product includes software developed by the Network Research
 * 	Group at Lawrence Berkeley National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
static const char rcsid[] =
    "@(#) $Header: decoder-gsm.cc,v 1.7 96/04/09 01:36:12 van Exp $ (LBL)";

#include "decoder.h"
#include "controller.h"
extern "C" {
#include "gsm.h"
}

class GSMDecoder : public PCM_Decoder {
    public:
	GSMDecoder();
	virtual void recv(const struct rtphdr*, const u_char* frame, int len);
    private:
	int nframes;
	gsm_state rstate_;
};

static class GSMDecoderMatcher : public Matcher {
    public:
	GSMDecoderMatcher() : Matcher("decoder") {}
	TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "gsm") == 0)
			return (new GSMDecoder);
		else
			return (0);
	}
} gsm_decoder_matcher;

GSMDecoder::GSMDecoder()
{
	Vat_Gsm_InitR(&rstate_);
}

void GSMDecoder::recv(const struct rtphdr* rh, const u_int8_t* frame, int len)
{
	if (active()) {
		if (len >= 33 && len <= 8 * 33) {
			u_char wrkbuf[FRAMESIZE*8];
			u_char* wp = wrkbuf;
			int outlen = 0;
			for (const u_char* ep = frame + len; frame < ep;
			     wp += framesize_, frame += 33) {
				Vat_Gsm_Decoder(&rstate_, wp, frame);
				outlen += framesize_;
			}
			consume_samples(rh, wrkbuf, outlen);
		}
	}
}
