#ifndef SESSION_H
#define SESSION_H

#include <glib.h>
#include "panel-widget.h"

BEGIN_GNOME_DECLS

#define DEFAULT_AUTO_HIDE_STEP_SIZE 10
#define DEFAULT_EXPLICIT_HIDE_STEP_SIZE 50
#define DEFAULT_DRAWER_STEP_SIZE 30

/* amount of time in ms. to wait before lowering panel */
#define DEFAULT_MINIMIZE_DELAY 300

/* number of pixels it'll stick up from the bottom when using
   PANEL_AUTO_HIDE */
#define DEFAULT_MINIMIZED_SIZE 6

#define DEFAULT_PANEL_NUM 0

int panel_session_save (GnomeClient *client,
			int phase,
			GnomeSaveStyle save_style,
			int shutdown,
			GnomeInteractStyle interact_style,
			int fast,
			gpointer client_data);

int panel_session_die (GnomeClient *client,
			gpointer client_data);

void panel_quit(void);

void panel_config_sync(void);

void load_up_globals(void);

void init_user_applets(void);
void init_user_panels(void);

void apply_global_config(void);

END_GNOME_DECLS

#endif
