package ButtonStyle;
use Var;

@FLAGS = qw(ReliefAUp ReliefADown ReliefIA);
@RADS = (qw( Init ),@FLAGS);
@COMMON = qw( ActiveUp ActiveDown Inactive);

sub new {
    my $class = shift;
    my $self = {};
    bless $self, $class;
    $self->init();
    return $self
}


sub init {
    my $self=shift;
    my $i;
    for($i=0;$i<=9;$i++){ 
	$self->{"B$i"} = new Var('Y');
	$self->{"B$i"}->set_panel_widget_class('Checkbutton');
    }

    foreach (@RADS) {
	    $self->{$_} = new Var;
	    $self->{$_}->set_panel_widget_class('Radiobutton');
	}
    foreach (@COMMON) {
	$self->{$_} = new Var;
    }
#    foreach (@RADS, @COMMON) {$self->{$_}->set_name("D:$_");}
    foreach (@COMMON) {$self->{$_}->set_panel_widget_class('Entry')};
    $self->{ActiveUp}->set_prefix('ActiveUp');
    $self->{ActiveDown}->set_prefix('ActiveDown');
    $self->{Inactive}->set_prefix('Inactive');
    $self->{ReliefAUp}->set_prefix('ActiveUp');
    $self->{ReliefADown}->set_prefix('ActiveDown');
    $self->{ReliefIA}->set_prefix('Inactive');
    $self->{Init}->set_value('None');
#    $self->set_number();
}


sub set_number {
    my $self = shift;
    my $num = shift;
#    $self->{Number} = $num;
# Number screws things up. Not needed now anyway
    foreach (@RADS, @COMMON) {$self->{$_}->
	  set_name_title("B:$num-$_",($num+1)."-$_");}
    return 1;
}

#sub get_number {
#    my $self = shift;
#    return $self->{Number};
#}


sub set_init_default {
    my $self = shift;
    $self->{Init}->set_value('Default');
}

sub set_init_simple {
    my $self = shift;
    $self->{Init}->set_value('Simple');
}

sub set_init_none {
    my $self = shift;
    $self->{Init}->set_value('None');
}

sub query_init {
    my $self = shift;
    return $self->{Init}->get_value();
}

sub get_command {
    my $self = shift;
    my $pref = 'AddButtonStyle ';
    my (@coms,$j,$val,$pref1);

    for($j=0;$j<=9;$j++) {
	if ($self->{"B$j"}->get_value() eq 'Y') {
	    $val = $self->{Init}->get_value();
	    if ( defined $val and $val eq 'Default' or $val eq 'Simple' ) {
		push @coms, "$pref $j  $val";
	    }
	    foreach (@FLAGS) {
		next unless  $self->{$_}->is_set;
		$val = $self->{$_}->get_value();
		$pref1 = $self->{$_}->get_prefix();
		push @coms, "$pref $j $pref1  -- $val";
	    }
	    foreach (@COMMON) {
		next unless  $self->{$_}->is_set;
		$val = $self->{$_}->get_value();
		$pref1 = $self->{$_}->get_prefix();
		push @coms, "$pref $j $pref1  $val";
	    }
	}
    }
    return @coms;

}

1;
