#include "E.h"

void
DebugEvent(XEvent * ev)
{
   EDBUG(8, "DebugEvent");
   if (ev->type == event_base_shape + ShapeNotify)
      printf("EV: ShapeNotify:\n");
   else
     {
	switch (ev->type)
	  {
	  case KeyPress:
	     printf("EV: KeyPress:\n");
	     break;
	  case KeyRelease:
	     printf("EV: KeyRelease:\n");
	     break;
	  case ButtonPress:
	     printf("EV: ButtonPress:\n");
	     break;
	  case ButtonRelease:
	     printf("EV: ButtonRelease:\n");
	     break;
	  case MotionNotify:
	     printf("EV: MotionNotify:\n");
	     break;
	  case EnterNotify:
	     printf("EV: EnterNotify:\n");
	     break;
	  case LeaveNotify:
	     printf("EV: LeaveNotify:\n");
	     break;
	  case FocusIn:
	     printf("EV: FocusIn:\n");
	     break;
	  case FocusOut:
	     printf("EV: FocusOut:\n");
	     break;
	  case KeymapNotify:
	     printf("EV: KeymapNotify:\n");
	     break;
	  case Expose:
	     printf("EV: Expose:\n");
	     break;
	  case GraphicsExpose:
	     printf("EV: GraphicsExpose:\n");
	     break;
	  case NoExpose:
	     printf("EV: NoExpose:\n");
	     break;
	  case VisibilityNotify:
	     printf("EV: VisibilityNotify:\n");
	     break;
	  case CreateNotify:
	     printf("EV: CreateNotify:\n");
	     break;
	  case DestroyNotify:
	     printf("EV: DestroyNotify:\n");
	     break;
	  case UnmapNotify:
	     printf("EV: UnmapNotify:\n");
	     break;
	  case MapNotify:
	     printf("EV: MapNotify:\n");
	     break;
	  case MapRequest:
	     printf("EV: MapRequest:\n");
	     break;
	  case ReparentNotify:
	     printf("EV: ReparentNotify:\n");
	     break;
	  case ConfigureNotify:
	     printf("EV: ConfigureNotify:\n");
	     break;
	  case ConfigureRequest:
	     printf("EV: ConfigureRequest:\n");
	     break;
	  case GravityNotify:
	     printf("EV: GravityNotify:\n");
	     break;
	  case ResizeRequest:
	     printf("EV: ResizeRequest:\n");
	     break;
	  case CirculateNotify:
	     printf("EV: CirculateNotify:\n");
	     break;
	  case CirculateRequest:
	     printf("EV: CirculateRequest:\n");
	     break;
	  case PropertyNotify:
	     printf("EV: PropertyNotify:\n");
	     break;
	  case SelectionClear:
	     printf("EV: SelectionClear:\n");
	     break;
	  case SelectionRequest:
	     printf("EV: SelectionRequest:\n");
	     break;
	  case SelectionNotify:
	     printf("EV: SelectionNotify:\n");
	     break;
	  case ColormapNotify:
	     printf("EV: ColormapNotify:\n");
	     break;
	  case ClientMessage:
	     printf("EV: ClientMessage:\n");
	     break;
	  case MappingNotify:
	     printf("EV: MappingNotify:\n");
	     break;
	  default:
	     printf("EV: ???\n");
	     break;
	  }
     }
   EDBUG_RETURN_;
}

void
HandleEvent(XEvent * ev)
{
   void              **lst;
   int                 i, num;

   EDBUG(7, "HandleEvent");
/*   DebugEvent(ev); */
   if (ev->type == event_base_shape + ShapeNotify)
      HandleChildShapeChange(ev);
   lst = ListItemType(&num, LIST_TYPE_ACLASS_GLOBAL);
   if (lst)
     {
	for (i = 0; i < num; i++)
	   EventAclass(ev, (ActionClass *) lst[i]);
	Efree(lst);
     }
   switch (ev->type)
     {
     case Expose:
	if (!ev->xexpose.count)
	   HandleExpose(ev);
	break;
     case ButtonPress:
	ApplySclass(FindItem("SOUND_BUTTON_CLICK", 0,
			     LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
	HandleMouseDown(ev);
	DesktopAccounting();
	EDisplayMemUse();
	break;
     case ButtonRelease:
	ApplySclass(FindItem("SOUND_BUTTON_RAISE", 0,
			     LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
	HandleMouseUp(ev);
	break;
     case EnterNotify:
	if (mode.mode == MODE_NONE)
	  {
	     HandleMouseIn(ev);
	     HandleFocusWindow(ev->xcrossing.window);
	  }
	break;
     case LeaveNotify:
	if (mode.mode == MODE_NONE)
	  {
	     HandleMouseOut(ev);
	     HandleFocusWindow(ev->xcrossing.window);
	  }
	break;
     case MapRequest:
	HandleMapRequest(ev);
	DesktopAccounting();
	break;
     case DestroyNotify:
	HandleDestroy(ev);
	DesktopAccounting();
	break;
     case UnmapNotify:
	HandleUnmap(ev);
	DesktopAccounting();
	break;
     case ClientMessage:
	{
	   Atom                a;

	   a = XInternAtom(disp, "ENL_MSG", False);
	   if (ev->xclient.message_type == a)
	      HandleComms(ev);
	}
	break;
     case ConfigureRequest:
	HandleConfigureRequest(ev);
	break;
     case ResizeRequest:
	HandleResizeRequest(ev);
	break;
     case PropertyNotify:
	HandleProperty(ev);
	DesktopAccounting();
	break;
     case CirculateRequest:
	HandleCirculate(ev);
	break;
     case ReparentNotify:
	HandleReparent(ev);
	break;
     case KeyPress:
	break;
     case KeyRelease:
	break;
     case MotionNotify:
	while (XCheckTypedEvent(disp, ev->type, ev));
	HandleMotion(ev);
	break;
     case FocusIn:
	break;
     case FocusOut:
	break;
     default:
	break;
     }
   EDBUG_RETURN_;
}

void
CheckEvent()
{
   XEvent              ev;

   EDBUG(7, "CheckEvent");
   while (XCheckMaskEvent(disp, SubstructureNotifyMask | ButtonPressMask |
		       ButtonReleaseMask | EnterWindowMask | LeaveWindowMask |
			  ButtonMotionMask | PropertyChangeMask |
			  SubstructureRedirectMask | KeyPressMask |
			  KeyReleaseMask | PointerMotionMask | ExposureMask
			  ,&ev))
      HandleEvent(&ev);
   EDBUG_RETURN_;
}

void
WaitEvent()
{
   XEvent              ev;

   EDBUG(7, "WaitEvent");
   XNextEvent(disp, &ev);
   HandleEvent(&ev);
   EDBUG_RETURN_;
}
