#include "E.h"

void
ShowDesktopControls()
{
   Button            **lst;
   int                 num, i;

   lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 1);
   if ((lst) && (num > 0))
     {
	for (i = 0; i < num; i++)
	   SimpleShowButton(lst[i]);
	Efree(lst);
	StackDesktops();
     }
}

void
ShowDesktopTabs()
{
   Button            **lst;
   int                 num, i;

   lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 2);
   if ((lst) && (num > 0))
     {
	for (i = 0; i < num; i++)
	   SimpleShowButton(lst[i]);
	Efree(lst);
	StackDesktops();
     }
}

void
HideDesktopTabs()
{
   Button            **lst;
   int                 num, i;

   lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 2);
   if ((lst) && (num > 0))
     {
	for (i = 0; i < num; i++)
	   HideButton(lst[i]);
	Efree(lst);
	StackDesktops();
     }
}

void
MoveToDeskTop(int num)
{
   int                 i, j;

   EDBUG(6, "MoveToDeskTop");
   j = -1;
   i = 0;
   while ((j < 0) && (i < 32))
     {
	if (deskorder[i] == num)
	   j = i;
	i++;
     }
   if (j < 0)
      EDBUG_RETURN_;
   if (j > 0)
     {
	for (i = j - 1; i >= 0; i--)
	   deskorder[i + 1] = deskorder[i];
	deskorder[0] = num;
     }
   EDBUG_RETURN_;
}

void
MoveToDeskBottom(int num)
{
   int                 i, j;

   EDBUG(6, "MoveToDeskBottom");
   j = -1;
   i = 0;
   while ((j < 0) && (i < 32))
     {
	if (deskorder[i] == num)
	   j = i;
	i++;
     }
   if (j < 0)
      EDBUG_RETURN_;
   if (j < 31)
     {
	for (i = j; i < 31; i++)
	   deskorder[i] = deskorder[i + 1];
	deskorder[31] = num;
     }
   EDBUG_RETURN_;
}

void
SlideWindowTo(Window win, int fx, int fy, int tx, int ty, int speed)
{
   int                 k, spd, x, y, min;
   struct timeval      timev1, timev2;
   int                 dsec, dusec;
   double              tm;

   EDBUG(5, "SlideWindowTo");
   spd = 16;
   min = 2;
   GrabX();
   for (k = 0; k < 1024; k += spd)
     {
	gettimeofday(&timev1, NULL);
	x = ((fx * (1023 - k)) + (tx * k)) >> 10;
	y = ((fy * (1023 - k)) + (ty * k)) >> 10;
	XMoveWindow(disp, win, x, y);
	XSync(disp, False);
	gettimeofday(&timev2, NULL);
	dsec = timev2.tv_sec - timev1.tv_sec;
	dusec = timev2.tv_usec - timev1.tv_usec;
	if (dusec < 0)
	  {
	     dsec--;
	     dusec += 1000000;
	  }
	tm = (double)dsec + (((double)dusec) / 1000000);
	spd = (int)((double)speed * tm);
	if (spd < min)
	   spd = min;
     }
   UngrabX();
   EDBUG_RETURN_;
}

Background         *
CreateDesktopBG(char *name, ImlibColor * solid,
		char *bg, char tile, char keep_aspect,
		int xjust, int yjust, int xperc, int yperc,
		char *top, char tkeep_aspect,
		int txjust, int tyjust, int txperc, int typerc)
{
   ImlibData          *imd;
   Background         *d;

   EDBUG(6, "CreateDesktopBG");
   if (ird)
      imd = ird;
   else
      imd = id;
   d = Emalloc(sizeof(Background));
   if (!d)
      EDBUG_RETURN(NULL);
   d->name = duplicate(name);
   d->pmap = 0;
   d->bg.solid.r = 160;
   d->bg.solid.g = 160;
   d->bg.solid.b = 160;
   d->bg.file = NULL;
   d->bg.im = NULL;
   d->bg.tile = 1;
   d->bg.keep_aspect = 1;
   d->bg.xjust = 512;
   d->bg.yjust = 512;
   d->bg.xperc = 1024;
   d->bg.yperc = 1024;
   d->top.file = NULL;
   d->top.im = NULL;
   d->top.keep_aspect = 1;
   d->top.xjust = 512;
   d->top.yjust = 512;
   d->top.xperc = 0;
   d->top.yperc = 0;
   if (solid)
     {
	d->bg.solid.r = solid->r;
	d->bg.solid.g = solid->g;
	d->bg.solid.b = solid->b;
     }
   if (d->bg.file)
      Efree(d->top.file);
   d->bg.file = NULL;
   if (bg)
      d->bg.file = duplicate(bg);
   d->bg.im = NULL;
   d->bg.tile = tile;
   d->bg.keep_aspect = keep_aspect;
   d->bg.xjust = xjust;
   d->bg.yjust = yjust;
   d->bg.xperc = xperc;
   d->bg.yperc = yperc;
   d->last_viewed = 0;

   if (d->top.file)
      Efree(d->top.file);
   d->top.file = NULL;
   if (top)
      d->top.file = duplicate(top);
   d->top.im = NULL;
   d->top.keep_aspect = tkeep_aspect;
   d->top.xjust = txjust;
   d->top.yjust = tyjust;
   d->top.xperc = txperc;
   d->top.yperc = typerc;
   EDBUG_RETURN(d);
}

void
RefreshCurrentDesktop()
{
   EDBUG(5, "RefreshCurrentDesktop");
   RefreshDesktop(desks.current);
   EDBUG_RETURN_;
}

void
RefreshDesktop(int num)
{
   Background         *dsk;
   int                 r, g, b, w, h, x, y, ww, hh;
   Pixmap              pmap, mask;
   GC                  gc;
   XGCValues           gcv;
   char                hasbg, hasfg;
   int                 rt;
   ColorModifierClass *cm;
   ImlibData          *imd;

   EDBUG(4, "RefreshDesktop");
   num &= 0x1f;
   if (!desks.desk[num].viewable)
      EDBUG_RETURN_;
   dsk = desks.desk[num].bg;
   if (!dsk)
      EDBUG_RETURN_;
   if ((ird) && (num == 0))
     {
	printf("using root imlib\n");
	imd = ird;
     }
   else
      imd = id;
   r = dsk->bg.solid.r;
   g = dsk->bg.solid.g;
   b = dsk->bg.solid.b;
   dsk->bg.solid.pixel = Imlib_best_color_match(imd, &r, &g, &b);
   pmap = 0;
   gc = 0;
   w = 0;
   h = 0;
   hasbg = 0;
   hasfg = 0;
   rt = Imlib_get_render_type(id);
   if (desks.hiqualitybg)
      Imlib_set_render_type(imd, RT_DITHER_TRUECOL);
   if (!dsk->pmap)
     {
	cm = NULL;
	cm = (ColorModifierClass *) FindItem("BACKGROUND", 0, LIST_FINDBY_NAME,
					     LIST_TYPE_COLORMODIFIER);
	if (!cm)
	   cm = (ColorModifierClass *) FindItem("DEFAULT", 0, LIST_FINDBY_NAME,
						LIST_TYPE_COLORMODIFIER);
	if (dsk->bg.file)
	  {
	     if (!dsk->bg.im)
		dsk->bg.im = ELoadImageImlibData(imd, dsk->bg.file);
	  }
	if (dsk->top.file)
	  {
	     if (!dsk->top.im)
		dsk->top.im = ELoadImageImlibData(imd, dsk->top.file);
	  }
	if (cm)
	  {
	     if (dsk->top.im)
	       {
		  Imlib_set_image_red_curve(id, dsk->top.im,
					    cm->red.map);
		  Imlib_set_image_green_curve(id, dsk->top.im,
					      cm->green.map);
		  Imlib_set_image_blue_curve(id, dsk->top.im,
					     cm->blue.map);
	       }
	     if (dsk->bg.im)
	       {
		  Imlib_set_image_red_curve(id, dsk->bg.im,
					    cm->red.map);
		  Imlib_set_image_green_curve(id, dsk->bg.im,
					      cm->green.map);
		  Imlib_set_image_blue_curve(id, dsk->bg.im,
					     cm->blue.map);
	       }
	  }
     }
   if (dsk->top.im)
      hasfg = 1;
   if (dsk->bg.im)
      hasbg = 1;
   if ((hasfg) && (hasbg))
     {
	if (dsk->bg.xperc > 0)
	   w = (root.w * dsk->bg.xperc) >> 10;
	else
	   w = dsk->bg.im->rgb_width;
	if (dsk->bg.yperc > 0)
	   h = (root.h * dsk->bg.yperc) >> 10;
	else
	   h = dsk->bg.im->rgb_height;
	if (dsk->bg.keep_aspect)
	  {
	     if (((w << 10) / h) !=
		 ((dsk->bg.im->rgb_width << 10) / dsk->bg.im->rgb_height))
		h = ((w * dsk->bg.im->rgb_height) / dsk->bg.im->rgb_width);
	  }
	dsk->pmap = XCreatePixmap(disp, desks.desk[num].win, root.w, root.h, imd->x.depth);
	gc = XCreateGC(disp, dsk->pmap, 0, &gcv);
	if (!dsk->bg.tile)
	  {
	     XSetForeground(disp, gc, dsk->bg.solid.pixel);
	     XFillRectangle(disp, dsk->pmap, gc, 0, 0, root.w, root.h);
	  }
	x = ((root.w - w) * dsk->bg.xjust) >> 10;
	y = ((root.h - h) * dsk->bg.yjust) >> 10;
	Imlib_render(imd, dsk->bg.im, w, h);
	pmap = Imlib_move_image(imd, dsk->bg.im);
	XSetTile(disp, gc, pmap);
	XSetTSOrigin(disp, gc, x, y);
	XSetFillStyle(disp, gc, FillTiled);
	if (!dsk->bg.tile)
	   XFillRectangle(disp, dsk->pmap, gc, x, y, w, h);
	else
	   XFillRectangle(disp, dsk->pmap, gc, 0, 0, root.w, root.h);
	Imlib_free_pixmap(imd, pmap);

	if (dsk->top.xperc > 0)
	   ww = (root.w * dsk->top.xperc) >> 10;
	else
	   ww = dsk->top.im->rgb_width;
	if (dsk->top.yperc > 0)
	   hh = (root.h * dsk->top.yperc) >> 10;
	else
	   hh = dsk->top.im->rgb_height;
	if (dsk->top.keep_aspect)
	  {
	     if (((ww << 10) / hh) !=
		 ((dsk->top.im->rgb_width << 10) / dsk->top.im->rgb_height))
		hh = ((ww * dsk->top.im->rgb_height) / dsk->top.im->rgb_width);
	  }
	Imlib_render(imd, dsk->top.im, ww, hh);
	pmap = Imlib_move_image(imd, dsk->top.im);
	mask = Imlib_move_mask(imd, dsk->top.im);
	x = ((root.w - ww) * dsk->top.xjust) >> 10;
	y = ((root.h - hh) * dsk->top.yjust) >> 10;
	XSetTile(disp, gc, pmap);
	XSetTSOrigin(disp, gc, x, y);
	XSetFillStyle(disp, gc, FillTiled);
	if (mask)
	  {
	     XSetClipMask(disp, gc, mask);
	     XSetClipOrigin(disp, gc, x, y);
	  }
	XFillRectangle(disp, dsk->pmap, gc, x, y, ww, hh);
	Imlib_free_pixmap(imd, pmap);
     }
   else if (hasbg)
     {
	if (dsk->bg.xperc > 0)
	   w = (root.w * dsk->bg.xperc) >> 10;
	else
	   w = dsk->bg.im->rgb_width;
	if (dsk->bg.yperc > 0)
	   h = (root.h * dsk->bg.yperc) >> 10;
	else
	   h = dsk->bg.im->rgb_height;
	if (dsk->bg.keep_aspect)
	  {
	     if (((w << 10) / h) !=
		 ((dsk->bg.im->rgb_width << 10) / dsk->bg.im->rgb_height))
		h = ((w * dsk->bg.im->rgb_height) / dsk->bg.im->rgb_width);
	  }
	if (dsk->bg.tile)
	  {
	     dsk->pmap = XCreatePixmap(disp, desks.desk[num].win, w, h, imd->x.depth);
	     gc = XCreateGC(disp, dsk->pmap, 0, &gcv);
	  }
	else
	  {
	     dsk->pmap = XCreatePixmap(disp, desks.desk[num].win, root.w, root.h, imd->x.depth);
	     gc = XCreateGC(disp, dsk->pmap, 0, &gcv);
	     XSetForeground(disp, gc, dsk->bg.solid.pixel);
	     XFillRectangle(disp, dsk->pmap, gc, 0, 0, root.w, root.h);
	  }
	x = ((root.w - w) * dsk->bg.xjust) >> 10;
	y = ((root.h - h) * dsk->bg.yjust) >> 10;
	Imlib_render(imd, dsk->bg.im, w, h);
	pmap = Imlib_move_image(imd, dsk->bg.im);
	XSetTile(disp, gc, pmap);
	XSetTSOrigin(disp, gc, x, y);
	XSetFillStyle(disp, gc, FillTiled);
	if (dsk->bg.tile)
	   XFillRectangle(disp, dsk->pmap, gc, 0, 0, w, h);
	else
	   XFillRectangle(disp, dsk->pmap, gc, x, y, w, h);
	Imlib_free_pixmap(imd, pmap);
     }
   else if (hasfg)
     {
	dsk->pmap = XCreatePixmap(disp, desks.desk[num].win, root.w, root.h, imd->x.depth);
	gc = XCreateGC(disp, dsk->pmap, 0, &gcv);
	XSetForeground(disp, gc, dsk->bg.solid.pixel);
	XFillRectangle(disp, dsk->pmap, gc, 0, 0, root.w, root.h);
	if (dsk->top.xperc > 0)
	   ww = (root.w * dsk->top.xperc) >> 10;
	else
	   ww = dsk->top.im->rgb_width;
	if (dsk->top.yperc > 0)
	   hh = (root.h * dsk->top.yperc) >> 10;
	else
	   hh = dsk->top.im->rgb_height;
	if (dsk->top.keep_aspect)
	  {
	     if (((ww << 10) / hh) !=
		 ((dsk->top.im->rgb_width << 10) / dsk->top.im->rgb_height))
		hh = ((ww * dsk->top.im->rgb_height) / dsk->top.im->rgb_width);
	  }
	Imlib_render(imd, dsk->top.im, ww, hh);
	pmap = Imlib_move_image(imd, dsk->top.im);
	mask = Imlib_move_mask(imd, dsk->top.im);
	x = ((root.w - ww) * dsk->top.xjust) >> 10;
	y = ((root.h - hh) * dsk->top.yjust) >> 10;
	XSetTile(disp, gc, pmap);
	XSetTSOrigin(disp, gc, x, y);
	XSetFillStyle(disp, gc, FillTiled);
	if (mask)
	  {
	     XSetClipMask(disp, gc, mask);
	     XSetClipOrigin(disp, gc, x, y);
	  }
	XFillRectangle(disp, dsk->pmap, gc, x, y, ww, hh);
	Imlib_free_pixmap(imd, pmap);
     }
   if (dsk->top.im)
      Imlib_kill_image(imd, dsk->top.im);
   if (dsk->bg.im)
      Imlib_kill_image(imd, dsk->bg.im);
   dsk->top.im = NULL;
   dsk->bg.im = NULL;
   if (dsk->pmap)
      SetBG(desks.desk[num].win, dsk->pmap, 0);
   else
      SetBG(desks.desk[num].win, 0, dsk->bg.solid.pixel);
   if (gc)
      XFreeGC(disp, gc);
   Imlib_set_render_type(imd, rt);
   EDBUG_RETURN_;
}

void
InitDesktopBgs()
{
   int                 i;
   Desk               *d;
   Atom                at;

   EDBUG(6, "InitDesktopBgs");
   for (i = 0; i < 32; i++)
     {
	d = &desks.desk[i];
	d->bg = NULL;
	deskorder[i] = i;
	d->num = 0;
	d->list = NULL;
	d->tag = NULL;
	d->x = 0;
	d->y = 0;
	if (i == 0)
	  {
	     d->win = root.win;
	     d->viewable = 1;
	  }
	else
	  {
	     d->win = ECreateWindow(root.win, 0, 0, root.w, root.h, 0);
	     XSelectInput(disp, d->win,
			  SubstructureNotifyMask | ButtonPressMask |
			  ButtonReleaseMask | EnterWindowMask |
			  LeaveWindowMask | ButtonMotionMask |
			  PropertyChangeMask | SubstructureRedirectMask |
			  KeyPressMask | KeyReleaseMask | PointerMotionMask);
	     d->viewable = 0;
	  }
	at = XInternAtom(disp, "ENLIGHTENMENT_DESKTOP", False);
	XChangeProperty(disp, d->win, at, XA_CARDINAL, 32, PropModeReplace,
			(unsigned char *)&i, 1);
     }
   EDBUG_RETURN_;
}

void
InitDesktopControls()
{
   int                 i;
   ActionClass        *ac, *ac2, *ac3;
   ImageClass         *ic, *ic2, *ic3, *ic4;
   Button             *b;
   Action             *a;
   int                 x[3], y[3], w[3], h[3], m, n, o;
   char                s[512], *param;

   EDBUG(6, "InitDesktopControls");
   for (i = 0; i < 32; i++)
     {
	Esnprintf(s, sizeof(s), "DRAGBAR_DESKTOP_%i", i);
	ac = FindItem(s, 0, LIST_FINDBY_NAME, LIST_TYPE_ACLASS);
	if (!ac)
	  {
	     ac = CreateAclass(s);
	     AddItem(ac, ac->name, 0, LIST_TYPE_ACLASS);
	     a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 1, 0, 0, NULL);
	     AddAction(ac, a);
	     param = Emalloc(3);
	     Esnprintf(param, 3, "%i", i);
	     AddToAction(a, ACTION_DESKTOP_DRAG, param);
	  }
	Esnprintf(s, sizeof(s), "RAISEBUTTON_DESKTOP_%i", i);
	ac2 = FindItem(s, 0, LIST_FINDBY_NAME, LIST_TYPE_ACLASS);
	if (!ac2)
	  {
	     ac2 = CreateAclass(s);
	     AddItem(ac2, ac2->name, 0, LIST_TYPE_ACLASS);
	     a = CreateAction(EVENT_MOUSE_UP, 1, 0, 1, 0, 0, NULL);
	     AddAction(ac2, a);
	     param = Emalloc(3);
	     Esnprintf(param, 3, "%i", i);
	     AddToAction(a, ACTION_DESKTOP_RAISE, param);
	  }
	Esnprintf(s, sizeof(s), "LOWERBUTTON_DESKTOP_%i", i);
	ac3 = FindItem(s, 0, LIST_FINDBY_NAME, LIST_TYPE_ACLASS);
	if (!ac3)
	  {
	     ac3 = CreateAclass(s);
	     AddItem(ac3, ac3->name, 0, LIST_TYPE_ACLASS);
	     a = CreateAction(EVENT_MOUSE_UP, 1, 0, 1, 0, 0, NULL);
	     AddAction(ac3, a);
	     param = Emalloc(3);
	     Esnprintf(param, 3, "%i", i);
	     AddToAction(a, ACTION_DESKTOP_LOWER, param);
	  }
	b = NULL;
	if (desks.dragdir < 2)
	  {
	     ic = FindItem("DESKTOP_DRAGBUTTON_VERT", 0, LIST_FINDBY_NAME,
			   LIST_TYPE_ICLASS);
	     ic2 = FindItem("DESKTOP_RAISEBUTTON_VERT", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	     ic3 = FindItem("DESKTOP_LOWERBUTTON_VERT", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	     ic4 = FindItem("DESKTOP_DESKRAY_VERT", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	  }
	else
	  {
	     ic = FindItem("DESKTOP_DRAGBUTTON_HORIZ", 0, LIST_FINDBY_NAME,
			   LIST_TYPE_ICLASS);
	     ic2 = FindItem("DESKTOP_RAISEBUTTON_HORIZ", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	     ic3 = FindItem("DESKTOP_LOWERBUTTON_HORIZ", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	     ic4 = FindItem("DESKTOP_DESKRAY_HORIZ", 0, LIST_FINDBY_NAME,
			    LIST_TYPE_ICLASS);
	  }
	switch (desks.dragbar_ordering)
	  {
	  case 0:
	     m = 0;
	     n = 1;
	     o = 2;
	     break;
	  case 1:
	     m = 0;
	     n = 2;
	     o = 1;
	     break;
	  case 2:
	     m = 2;
	     n = 0;
	     o = 1;
	     break;
	  case 3:
	     m = 1;
	     n = 0;
	     o = 2;
	     break;
	  case 4:
	     m = 1;
	     n = 2;
	     o = 0;
	     break;
	  case 5:
	     m = 2;
	     n = 1;
	     o = 0;
	     break;
	  default:
	     m = 0;
	     n = 1;
	     o = 2;
	     break;
	  }
	switch (desks.dragdir)
	  {
	  case 0:
	     w[0] = w[1] = w[2] = h[0] = h[1] = desks.dragbar_width;
	     if (desks.dragbar_length == 0)
		h[2] = root.h - (desks.dragbar_width * 2);
	     else
		h[2] = desks.dragbar_length;
	     x[0] = x[1] = x[2] = 0;
	     y[m] = 0;
	     y[n] = y[m] + h[m];
	     y[o] = y[n] + h[n];
	     break;
	  case 1:
	     w[0] = w[1] = w[2] = h[0] = h[1] = desks.dragbar_width;
	     if (desks.dragbar_length == 0)
		h[2] = root.h - (desks.dragbar_width * 2);
	     else
		h[2] = desks.dragbar_length;
	     x[0] = x[1] = x[2] = root.w - desks.dragbar_width;
	     y[m] = 0;
	     y[n] = y[m] + h[m];
	     y[o] = y[n] + h[n];
	     break;
	  case 2:
	     h[0] = h[1] = h[2] = w[0] = w[1] = desks.dragbar_width;
	     if (desks.dragbar_length == 0)
		w[2] = root.w - (desks.dragbar_width * 2);
	     else
		w[2] = desks.dragbar_length;
	     y[0] = y[1] = y[2] = 0;
	     x[m] = 0;
	     x[n] = x[m] + w[m];
	     x[o] = x[n] + w[n];
	     break;
	  case 3:
	     h[0] = h[1] = h[2] = w[0] = w[1] = desks.dragbar_width;
	     if (desks.dragbar_length == 0)
		w[2] = root.w - (desks.dragbar_width * 2);
	     else
		w[2] = desks.dragbar_length;
	     y[0] = y[1] = y[2] = root.h - desks.dragbar_width;
	     x[m] = 0;
	     x[n] = x[m] + w[m];
	     x[o] = x[n] + w[n];
	     break;
	  default:
	     break;
	  }
	b = CreateButton("_DESKTOP_DRAG_CONTROL", ic2, ac2, -1, FLAG_FIXED, 1,
			 99999, 1, 99999, 0, 0, x[0], 0, y[0], 0, 0, w[0], 0,
			 h[0], 0, i, 0);
	AddItem(b, b->name, 1, LIST_TYPE_BUTTON);
	b = CreateButton("_DESKTOP_DRAG_CONTROL", ic3, ac3, -1, FLAG_FIXED, 1,
			 99999, 1, 99999, 0, 0, x[1], 0, y[1], 0, 0, w[1], 0,
			 h[1], 0, i, 0);
	AddItem(b, b->name, 1, LIST_TYPE_BUTTON);
	b = CreateButton("_DESKTOP_DRAG_CONTROL", ic, ac, -1, FLAG_FIXED, 1,
			 99999, 1, 99999, 0, 0, x[2], 0, y[2], 0, 0, w[2], 0,
			 h[2], 0, i, 0);
	AddItem(b, b->name, 1, LIST_TYPE_BUTTON);
	if (i > 0)
	  {
	     if (desks.dragdir == 0)
		b = CreateButton("_DESKTOP_DESKRAY_DRAG_CONTROL", ic4, ac, 1, FLAG_FIXED_VERT, 1,
				 99999, 1, 99999, 0, 0, desks.desk[i].x,
				 0, desks.desk[i].y, 0, 0, 0, 0, 0, 1, 0, 1);
	     else if (desks.dragdir == 1)
		b = CreateButton("_DESKTOP_DESKRAY_DRAG_CONTROL", ic4, ac, 1, FLAG_FIXED_VERT, 1,
				 99999, 1, 99999, 0, 0, desks.desk[i].x + root.w - desks.dragbar_width,
				 0, desks.desk[i].y, 0, 0, 0, 0, 0, 1, 0, 1);
	     else if (desks.dragdir == 2)
		b = CreateButton("_DESKTOP_DESKRAY_DRAG_CONTROL", ic4, ac, 1, FLAG_FIXED_HORIZ, 1,
				 99999, 1, 99999, 0, 0, desks.desk[i].x,
				 0, desks.desk[i].y, 0, 0, 0, 0, 0, 1, 0, 1);
	     else
		b = CreateButton("_DESKTOP_DESKRAY_DRAG_CONTROL", ic4, ac, 1, FLAG_FIXED_HORIZ, 1,
				 99999, 1, 99999, 0, 0, desks.desk[i].x,
				 0, desks.desk[i].y + root.h - desks.dragbar_width, 0, 0, 0, 0, 0, 1, 0, 1);
	     AddItem(b, b->name, 2, LIST_TYPE_BUTTON);
	     desks.desk[i].tag = b;
	  }
	else
	   desks.desk[i].tag = NULL;
     }
   EDBUG_RETURN_;
}

void
SetDesktopBg(int desk, Background * bg)
{
   EDBUG(5, "SetDesktopBg");
   desks.desk[desk & 0x1f].bg = bg;
   if (desks.desk[desk & 0x1f].viewable)
      RefreshDesktop(desk);
   EDBUG_RETURN_;
}

void
ConformEwinToDesktop(EWin * ewin)
{
   int                 xo, yo;

   EDBUG(3, "ConformEwinToDesktop");
   if ((ewin->iconified) &&
       (ewin->parent != desks.desk[ewin->desktop].win))
     {
	DesktopRemoveEwin(ewin);
	ewin->parent = desks.desk[ewin->desktop].win;
	DesktopAddEwinToTop(ewin);
	XReparentWindow(disp, ewin->win, desks.desk[ewin->desktop].win,
			ewin->x, ewin->y);
	ICCCM_Configure(ewin);
	StackDesktops();
	EDBUG_RETURN_;
     }
   if ((ewin->sticky) || (ewin->floating))
     {
	xo = desks.desk[ewin->desktop].x;
	yo = desks.desk[ewin->desktop].y;
	if (ewin->parent != desks.desk[ewin->desktop].win)
	  {
	     ewin->parent = desks.desk[ewin->desktop].win;
	     XReparentWindow(disp, ewin->win, root.win, ewin->x + xo, ewin->y + yo);
	  }
	ICCCM_Configure(ewin);
	EDBUG_RETURN_;
     }
   if (ewin->parent != desks.desk[ewin->desktop].win)
     {
	DesktopRemoveEwin(ewin);
	ewin->parent = desks.desk[ewin->desktop].win;
	DesktopAddEwinToTop(ewin);
	XReparentWindow(disp, ewin->win, desks.desk[ewin->desktop].win,
			ewin->x, ewin->y);
	RaiseEwin(ewin);
	ShowEwin(ewin);
	ICCCM_Configure(ewin);
	StackDesktops();
     }
   EDBUG_RETURN_;
}

int
DekstopAt(int x, int y)
{
   int                 i;

   EDBUG(3, "DekstopAt");
   for (i = 0; i < 32; i++)
     {
	if ((x >= desks.desk[deskorder[i]].x) &&
	    (x < (desks.desk[deskorder[i]].x + root.w)) &&
	    (y >= desks.desk[deskorder[i]].y) &&
	    (y < (desks.desk[deskorder[i]].y + root.h)))
	   EDBUG_RETURN(deskorder[i]);
     }
   EDBUG_RETURN(0);
}

void
GotoDesktop(int num)
{
   int                 x, y;

   EDBUG(2, "GotoDesktop");
   desks.current = num & 0x1f;
   if ((mode.mode == MODE_RESIZE) ||
       (mode.mode == MODE_RESIZE_H) ||
       (mode.mode == MODE_RESIZE_V))
      doResizeEnd(NULL);
   else if ((mode.mode == MODE_MOVE) && (mode.movemode > 0))
     {
	if (mode.ewin)
	  {
	     x = mode.ewin->x;
	     y = mode.ewin->y;
	     mode.ewin->x = -99999;
	     mode.ewin->y = -99999;
	     DrawEwinShape(mode.ewin, mode.movemode,
			   x, y,
			   mode.ewin->client.w, mode.ewin->client.h,
			   mode.firstlast);
	  }
     }
   if (num > 0)
     {
	if (desks.slidein)
	  {
	     if (!desks.desk[num].viewable)
	       {
		  switch (desks.dragdir)
		    {
		    case 0:
		       MoveDesktop(num, root.w, 0);
		       RaiseDesktop(num);
		       SlideWindowTo(desks.desk[num].win, root.w,
				     0, 0, 0, desks.slidespeed);
		       break;
		    case 1:
		       MoveDesktop(num, -root.w, 0);
		       RaiseDesktop(num);
		       SlideWindowTo(desks.desk[num].win, -root.w,
				     0, 0, 0, desks.slidespeed);
		       break;
		    case 2:
		       MoveDesktop(num, 0, root.h);
		       RaiseDesktop(num);
		       SlideWindowTo(desks.desk[num].win, 0,
				     root.h, 0, 0, desks.slidespeed);
		       break;
		    case 3:
		       MoveDesktop(num, 0, -root.h);
		       RaiseDesktop(num);
		       SlideWindowTo(desks.desk[num].win, 0,
				     -root.h, 0, 0, desks.slidespeed);
		       break;
		    default:
		       break;
		    }
	       }
	     else
	       {
		  GetWinXY(desks.desk[num].win, &x, &y);
		  SlideWindowTo(desks.desk[num].win, desks.desk[num].x,
				desks.desk[num].y, 0, 0, desks.slidespeed);
		  RaiseDesktop(num);
	       }
	  }
	else
	   RaiseDesktop(num);
	MoveDesktop(num, 0, 0);
     }
   RaiseDesktop(num);
   if ((mode.mode == MODE_MOVE) && (mode.movemode > 0))
     {
	if (mode.ewin)
	  {
	     x = mode.ewin->x;
	     y = mode.ewin->y;
	     mode.ewin->x = -99999;
	     mode.ewin->y = -99999;
	     DrawEwinShape(mode.ewin, mode.movemode,
			   x, y,
			   mode.ewin->client.w, mode.ewin->client.h,
			   mode.firstlast);
	  }
     }
   EDBUG_RETURN_;
}

void
MoveDesktop(int num, int x, int y)
{
   int                 i;
   EWin              **lst;
   int                 n, v, dx, dy;

   EDBUG(3, "MoveDesktop");
   num &= 0x1f;
   if (num == 0)
      EDBUG_RETURN_;
   dx = x - desks.desk[num].x;
   dy = y - desks.desk[num].y;
   if ((x == 0) && (y == 0))
     {
	n = -1;
	i = 0;
	while ((n < 0) && (i < 32))
	  {
	     if (deskorder[i] == num)
		n = i;
	     i++;
	  }
	if (n >= 0)
	  {
	     for (i = n + 1; i < 32; i++)
	       {
		  desks.desk[deskorder[i]].viewable = 0;
	       }
	  }
     }
   else
     {
	n = -1;
	i = 0;
	while ((n < 0) && (i < 32))
	  {
	     if (deskorder[i] == num)
		n = i;
	     i++;
	  }
	if (n >= 0)
	  {
	     if (desks.desk[deskorder[n]].viewable)
		v = 1;
	     else
		v = 0;
	     for (i = n + 1; i < 32; i++)
	       {
		  if ((!desks.desk[deskorder[i]].viewable) && (v))
		    {
		       desks.desk[deskorder[i]].viewable = v;
		       RefreshDesktop(deskorder[i]);
		    }
		  else
		     desks.desk[deskorder[i]].viewable = v;
		  if ((desks.desk[deskorder[i]].x == 0) &&
		      (desks.desk[deskorder[i]].y == 0))
		     v = 0;
	       }
	  }
     }
   XMoveWindow(disp, desks.desk[num].win, x, y);
   if (desks.desk[num].tag)
      MovebuttonToCoord(desks.desk[num].tag,
			desks.desk[num].tag->x + dx,
			desks.desk[num].tag->y + dy);
   desks.desk[num].x = x;
   desks.desk[num].y = y;
   lst = (EWin **) ListItemType(&n, LIST_TYPE_EWIN);
   if (lst)
     {
	for (i = 0; i < n; i++)
	   if (lst[i]->desktop == num)
	      ICCCM_Configure(lst[i]);
	Efree(lst);
     }
   EDBUG_RETURN_;
}

void
RaiseDesktop(int num)
{
   int                 i;

   EDBUG(3, "RaiseDesktop");
   num &= 0x1f;
   desks.desk[num].viewable = 1;
   RefreshDesktop(num);
   MoveToDeskTop(num);
   XMapRaised(disp, desks.desk[num].win);
   if (num == 0)
     {
	for (i = 31; i > 0; i--)
	   HideDesktop(deskorder[i]);
     }
   StackDesktops();
   EDBUG_RETURN_;
}

void
LowerDesktop(int num)
{
   EDBUG(3, "LowerDesktop");
   num &= 0x1f;
   if (num == 0)
      EDBUG_RETURN_;
   MoveToDeskBottom(num);
   UncoverDesktop(deskorder[0]);
   if (deskorder[0] == 0)
     {
	HideDesktop(num);
	XSync(disp, False);
	XLowerWindow(disp, desks.desk[num].win);
	XSync(disp, False);
     }
   else
     {
	XLowerWindow(disp, desks.desk[num].win);
	XSync(disp, False);
	HideDesktop(num);
	XSync(disp, False);
     }
   EDBUG_RETURN_;
}

void
HideDesktop(int num)
{
   EDBUG(3, "HideDesktop");
   num &= 0x1f;
   if (num == 0)
      EDBUG_RETURN_;
   desks.desk[num].viewable = 0;
   XUnmapWindow(disp, desks.desk[num].win);
   EDBUG_RETURN_;
}

void
ShowDesktop(int num)
{
   int                 i;

   EDBUG(3, "ShowDesktop");
   num &= 0x1f;
   desks.desk[num].viewable = 1;
   RefreshDesktop(num);
   MoveToDeskTop(num);
   if (num == 0)
     {
	for (i = 31; i > 0; i--)
	   HideDesktop(deskorder[i]);
     }
   else
     {
	StackDesktops();
	XMapWindow(disp, desks.desk[num].win);
     }
   EDBUG_RETURN_;
}

void
StackDesktops()
{
   Window             *wl;
   int                 i, num, tot, bnum;
   EWin              **lst;
   Button            **blst;

   EDBUG(2, "StackDesktops");
   tot = 0;
   wl = NULL;
   lst = (EWin **) ListItemType(&num, LIST_TYPE_EWIN);
   blst = (Button **) ListItemType(&bnum, LIST_TYPE_BUTTON);
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if (blst[i]->sticky)
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   if (lst)
     {
	for (i = 0; i < num; i++)
	  {
	     if ((lst[i]->sticky) || (lst[i]->floating))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = lst[i]->win;
	       }
	  }
     }
   for (i = 0; i < 32; i++)
     {
	if (deskorder[i] == 0)
	   i = 32;
	else
	  {
	     tot++;
	     wl = Erealloc(wl, tot * sizeof(Window));
	     wl[tot - 1] = desks.desk[deskorder[i]].win;
	  }
     }
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if ((blst[i]->desktop == 0) && (blst[i]->ontop == 1) &&
		 (!blst[i]->sticky))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   for (i = 0; i < desks.desk[0].num; i++)
     {
	tot++;
	wl = Erealloc(wl, tot * sizeof(Window));
	wl[tot - 1] = desks.desk[0].list[i];
     }
   if (blst)
     {
	for (i = 0; i < bnum; i++)
	  {
	     if ((blst[i]->desktop == 0) && (blst[i]->ontop == -1) &&
		 (!blst[i]->sticky))
	       {
		  tot++;
		  wl = Erealloc(wl, tot * sizeof(Window));
		  wl[tot - 1] = blst[i]->win;
	       }
	  }
     }
   tot++;
   wl = Erealloc(wl, tot * sizeof(Window));
   wl[tot - 1] = desks.desk[0].win;
   if (wl)
     {
	XRestackWindows(disp, wl, tot);
	Efree(wl);
     }
   if (lst)
      Efree(lst);
   if (blst)
      Efree(blst);
   EDBUG_RETURN_;
}

void
UncoverDesktop(int num)
{
   EDBUG(3, "UncoverDesktop");
   num &= 0x1f;
   desks.desk[num].viewable = 1;
   RefreshDesktop(num);
   if (num != 0)
      XMapWindow(disp, desks.desk[num].win);
   EDBUG_RETURN_;
}

void
MoveEwinToDesktop(EWin * ewin, int num)
{
   EDBUG(3, "MoveEwinToDesktop");
   ewin->sticky = 0;
   ewin->state &= ~EWIN_STICKY;
   ewin->floating = 0;
   DesktopRemoveEwin(ewin);
   ewin->desktop = num & 0x1f;
   DesktopAddEwinToTop(ewin);
   ConformEwinToDesktop(ewin);
   EDBUG_RETURN_;
}

void
DesktopRemoveEwin(EWin * ewin)
{
   int                 i, j;

   EDBUG(5, "DesktopRemoveEwin");
   if ((ewin->desktop < 0) || (ewin->desktop > 31))
      EDBUG_RETURN_;
   for (i = 0; i < desks.desk[ewin->desktop].num; i++)
     {
	if (desks.desk[ewin->desktop].list[i] == ewin->win)
	  {
	     for (j = i; j < desks.desk[ewin->desktop].num - 1; j++)
		desks.desk[ewin->desktop].list[j] =
		   desks.desk[ewin->desktop].list[j + 1];
	     desks.desk[ewin->desktop].num--;
	     if (desks.desk[ewin->desktop].num == 0)
	       {
		  Efree(desks.desk[ewin->desktop].list);
		  desks.desk[ewin->desktop].list = NULL;
	       }
	     else
	       {
		  desks.desk[ewin->desktop].list =
		     Erealloc(desks.desk[ewin->desktop].list,
			      desks.desk[ewin->desktop].num * sizeof(Window));
	       }
	     EDBUG_RETURN_;
	  }
     }
   EDBUG_RETURN_;
}

void
DesktopAddEwinToTop(EWin * ewin)
{
   int                 i;

   EDBUG(5, "DesktopAddEwinToTop");
   if ((ewin->desktop < 0) || (ewin->desktop > 31))
      EDBUG_RETURN_;
   DesktopRemoveEwin(ewin);
   desks.desk[ewin->desktop].num++;
   desks.desk[ewin->desktop].list =
      Erealloc(desks.desk[ewin->desktop].list,
	       desks.desk[ewin->desktop].num * sizeof(Window));
   for (i = desks.desk[ewin->desktop].num - 1; i > 0; i--)
      desks.desk[ewin->desktop].list[i] =
	 desks.desk[ewin->desktop].list[i - 1];
   desks.desk[ewin->desktop].list[0] = ewin->win;
   EDBUG_RETURN_;
}

void
DesktopAddEwinToBottom(EWin * ewin)
{
   EDBUG(5, "DesktopAddEwinToBottom");
   if ((ewin->desktop < 0) || (ewin->desktop > 31))
      EDBUG_RETURN_;
   DesktopRemoveEwin(ewin);
   desks.desk[ewin->desktop].num++;
   desks.desk[ewin->desktop].list =
      Erealloc(desks.desk[ewin->desktop].list,
	       desks.desk[ewin->desktop].num * sizeof(Window));
   desks.desk[ewin->desktop].list[desks.desk[ewin->desktop].num - 1] = ewin->win;
   EDBUG_RETURN_;
}

void
MoveEwinToDesktopAt(EWin * ewin, int num, int x, int y)
{
   EDBUG(3, "MoveEwinToDesktopAt");
   ewin->sticky = 0;
   ewin->state &= ~EWIN_STICKY;
   ewin->floating = 0;
   DesktopRemoveEwin(ewin);
   ewin->desktop = num & 0x1f;
   DesktopAddEwinToTop(ewin);
   ewin->x = x;
   ewin->y = y;
   ConformEwinToDesktop(ewin);
   EDBUG_RETURN_;
}

void
FloatEwinAboveDesktops(EWin * ewin)
{
   int                 xo, yo;

   EDBUG(2, "FloatEwinAboveDesktops");
   xo = desks.desk[ewin->desktop].x;
   yo = desks.desk[ewin->desktop].y;
   ewin->desktop = 0;
   ewin->floating = 1;
   ConformEwinToDesktop(ewin);
   EDBUG_RETURN_;
}

void
DesktopAccounting()
{
   time_t              now;
   int                 i, j, num;
   Background        **lst;
   ImlibData          *imd = 0;

   EDBUG(3, "DesktopAccounting");
   now = time(NULL);
   for (i = 0; i < 32; i++)
     {
	if ((desks.desk[i].bg) && (desks.desk[i].viewable))
	   desks.desk[i].bg->last_viewed = now;
     }
   lst = (Background **) ListItemType(&num, LIST_TYPE_BACKGROUND);
   if (lst)
     {
	for (i = 0; i < num; i++)
	  {
	     if (lst[i]->pmap)
	       {
		  if ((now - lst[i]->last_viewed) > mode.desktop_bg_timeout)
		    {
		       for (j = 0; j < 32; j++)
			 {
			    if (desks.desk[j].bg == lst[i])
			      {
				 if ((ird) && (j == 0))
				    imd = ird;
				 else
				    imd = id;
				 j = 32;
			      }
			 }
		       Imlib_free_pixmap(imd, lst[i]->pmap);
		       lst[i]->pmap = 0;
		       for (j = 0; j < 32; j++)
			 {
			    if ((desks.desk[j].bg == lst[i])
				&& (!desks.desk[j].viewable))
			       SetBG(desks.desk[j].win, 0, 0);
			 }
		    }
	       }
	  }
	Efree(lst);
     }
   EDBUG_RETURN_;
}
