#include "E.h"

void
CommsSetup()
{
   char                s[1024];
   Atom                a;

   EDBUG(5, "CommsSetup");
   comms_win = XCreateSimpleWindow(disp, root.win, -100, -100, 5, 5, 0, 0, 0);
   Esnprintf(s, sizeof(s), "WINID %8x", (int)comms_win);
   a = XInternAtom(disp, "ENLIGHTENMENT_COMMS", False);
   XChangeProperty(disp, root.win, a, XA_STRING, 8, PropModeReplace, (unsigned char *)s,
		   strlen(s));
   a = XInternAtom(disp, "ENL_MSG", False);
   EDBUG_RETURN_;
}

void
CommsFindCommsWindow()
{
   unsigned char      *s;
   Atom                a, ar;
   unsigned long       num, after;
   int                 format;

   EDBUG(6, "CommsFindCommsWindow");
   a = XInternAtom(disp, "ENLIGHTENMENT_COMMS", True);
   if (a != None)
     {
	s = NULL;
	XGetWindowProperty(disp, root.win, a, 0, 14, False, AnyPropertyType, &ar,
			   &format, &num, &after, &s);
	if (s)
	   sscanf((char *)s, "%*s %x", (unsigned int *)&comms_win);
	else
	   (comms_win = 0);
	XFree(s);
     }
   EDBUG_RETURN_;
}

void
CommsSend(Client * c, char *s)
{
   char                ss[21];
   int                 i, j, k, len;
   XEvent              ev;
   Atom                a;

   EDBUG(5, "CommsSend");
   if ((!s) || (!c))
      EDBUG_RETURN_;
   len = strlen(s);
   a = XInternAtom(disp, "ENL_MSG", True);
   ev.xclient.type = ClientMessage;
   ev.xclient.serial = 0;
   ev.xclient.send_event = True;
   ev.xclient.window = c->win;
   ev.xclient.message_type = a;
   ev.xclient.format = 8;
   for (i = 0; i < len + 1; i += 12)
     {
	Esnprintf(ss, sizeof(ss), "%8x", (int)comms_win);
	for (j = 0; j < 12; j++)
	  {
	     ss[8 + j] = s[i + j];
	     if (!s[i + j])
		j = 12;
	  }
	ss[20] = 0;
	for (k = 0; k < 20; k++)
	   ev.xclient.data.b[k] = ss[k];
	XSendEvent(disp, c->win, False, 0, (XEvent *) & ev);
     }
   EDBUG_RETURN_;
}

char               *
CommsGet(Client ** c, XEvent * ev)
{
   char                s[13], s2[9], *msg, st[32];
   int                 i;
   Window              win;
   Client             *cl;

   EDBUG(5, "CommsGet");
   if ((!ev) || (!c))
      EDBUG_RETURN(NULL);
   if (ev->type != ClientMessage)
      EDBUG_RETURN(NULL);
   s[12] = 0;
   s2[8] = 0;
   msg = NULL;
   for (i = 0; i < 8; i++)
      s2[i] = ev->xclient.data.b[i];
   for (i = 0; i < 12; i++)
      s[i] = ev->xclient.data.b[i + 8];
   sscanf(s2, "%x", (int *)&win);
   cl = (Client *) FindItem(NULL, win, LIST_FINDBY_ID, LIST_TYPE_CLIENT);
   if (!cl)
     {
	cl = MakeClient(win);
	if (!cl)
	   EDBUG_RETURN(NULL);
	Esnprintf(st, sizeof(st), "%8x", (int)win);
	cl->name = duplicate(st);
	AddItem((void *)cl, st, cl->win, LIST_TYPE_CLIENT);
	XSelectInput(disp, win, StructureNotifyMask | SubstructureNotifyMask);
     }
   if (cl->msg)
     {
	/* append text to end of msg */
	cl->msg = Erealloc(cl->msg, strlen(cl->msg) + strlen(s) + 1);
	if (!cl->msg)
	   EDBUG_RETURN(NULL);
	strcat(cl->msg, s);
     }
   else
     {
	/* new msg */
	cl->msg = Emalloc(strlen(s) + 1);
	if (!cl->msg)
	   EDBUG_RETURN(NULL);
	strcpy(cl->msg, s);
     }
   if (strlen(s) < 12)
     {
	msg = cl->msg;
	cl->msg = NULL;
	*c = cl;
     }
   EDBUG_RETURN(msg);
}

void
CommsBroadcast(char *s)
{
   char              **l;
   int                 num, i;
   Client             *c;

   EDBUG(5, "CommsBroadcast");
   l = ListItems(&num, LIST_TYPE_CLIENT);
   if (!s)
      EDBUG_RETURN_;
   for (i = 0; i < num; i++)
     {
	c = (Client *) FindItem(l[i], 0, LIST_FINDBY_NAME, LIST_TYPE_CLIENT);
	if (c)
	   CommsSend(c, s);
     }
   freestrlist(l, num);
   EDBUG_RETURN_;
}

Client             *
MakeClient(Window win)
{
   Client             *c;

   EDBUG(6, "MakeClient");
   c = Emalloc(sizeof(Client));
   if (!c)
      EDBUG_RETURN(NULL);
   c->name = NULL;
   c->win = win;
   c->msg = NULL;
   c->clientname = NULL;
   c->version = NULL;
   c->author = NULL;
   c->email = NULL;
   c->web = NULL;
   c->address = NULL;
   c->info = NULL;
   c->pmap = 0;
   EDBUG_RETURN(c);
}

void
ListFreeClient(void *ptr)
{
   Client             *c;

   EDBUG(6, "ListFreeClient");
   c = (Client *) ptr;
   if (!c)
      EDBUG_RETURN_;
   if (c->name)
      Efree(c->name);
   if (c->msg)
      Efree(c->msg);
   if (c->clientname)
      Efree(c->clientname);
   if (c->version)
      Efree(c->version);
   if (c->author)
      Efree(c->author);
   if (c->email)
      Efree(c->email);
   if (c->web)
      Efree(c->web);
   if (c->address)
      Efree(c->address);
   if (c->info)
      Efree(c->info);
   Efree(c);
   EDBUG_RETURN_;
}

void
DeleteClient(Client * c)
{
   Client             *cc;

   EDBUG(6, "DeleteClient");
   cc = RemoveItem(NULL, c->win, LIST_FINDBY_ID, LIST_TYPE_CLIENT);
   ListFreeClient(cc);
   EDBUG_RETURN_;
}

void
HandleComms(XEvent * ev)
{
   Client             *c;
   char               *s, w[512], w2[512], *s1, *s2;
   char                sunknown[] = "UNKNOWN";
   int                 unknown;

   EDBUG(4, "HandleComms");
   s = CommsGet(&c, ev);
   if (!s)
      EDBUG_RETURN_;
   unknown = 0;
   s1 = NULL, s2 = NULL;
   word(s, 1, w);
   if (!strcmp(w, "set"))
     {
	word(s, 2, w);
	if (!strcmp(w, "clientname"))
	  {
	     if (c->clientname)
		Efree(c->clientname);
	     c->clientname = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "version"))
	  {
	     if (c->version)
		Efree(c->version);
	     c->version = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "author"))
	  {
	     if (c->author)
		Efree(c->author);
	     c->author = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "email"))
	  {
	     if (c->email)
		Efree(c->email);
	     c->email = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "web"))
	  {
	     if (c->web)
		Efree(c->web);
	     c->web = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "address"))
	  {
	     if (c->address)
		Efree(c->address);
	     c->address = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "info"))
	  {
	     if (c->info)
		Efree(c->info);
	     c->info = duplicate(atword(s, 3));
	  }
	else if (!strcmp(w, "pixmap"))
	  {
	     word(s, 3, w);
	     sscanf(w, "%x", (int *)&c->pmap);
	  }
	else
	   unknown = 1;
     }
   else if (!strcmp(w, "reply"))
     {
	word(s, 2, w);
	if (!strcmp(w, "imageclass"))
	  {
	     /* Reply format "reply imageclass NAME 24243" */
	     word(s, 3, w);
	     word(s, 4, w2);
	     HonorIclass(w, atoi(w2));
	  }
	else
	   unknown = 1;
     }
   else
      unknown = 1;

   if (unknown)
     {
	s1 = c->clientname;
	s2 = c->version;
	if (!s1)
	   s1 = sunknown;
	if (!s2)
	   s2 = sunknown;
	Alert("Recieved Unknown Client Message.\n"
	      "Client Name:    %s\n"
	      "Client Version: %s\n"
	      "Message Contents:\n\n"
	      "%s\n", s1, s2, s);
     }
   Efree(s);
   EDBUG_RETURN_;
}

void
DisplayClientInfo(Client * c, int onoff)
{
   EDBUG(6, "DisplayClientInfo");
   if (!c)
      EDBUG_RETURN_;

   printf("NAME ID:\n%s\n", c->name);
   printf("CLIENT COMMS WINDOW:\n%i\n", (int)c->win);
   if (onoff)
     {
	if (c->clientname)
	  {
	     printf("CLIENT NAME:\n%s\n", c->clientname);
	     if (c->version)
	       {
		  printf("VERSION:\n%s\n", c->version);
	       }
	     if (c->email)
	       {
		  printf("CONTACT EMAIL:\n%s\n", c->email);
	       }
	     if (c->web)
	       {
		  printf("CLIENT WEB PAGE:\n%s\n", c->web);
	       }
	     if (c->address)
	       {
		  printf("AUTHOR ADDRESS:\n%s\n", c->address);
	       }
	     if (c->info)
	       {
		  printf("CLIENT INFORMATION:\n%s\n", c->info);
	       }
	  }
     }
   else
     {
     }
   EDBUG_RETURN_;
}

void
HideClientInfo()
{
   EDBUG(6, "HideClientInfo");
   EDBUG_RETURN_;
}
