/***************************************
  $Header$

  HTML parser test program
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdio.h>

#include "wwwoffle.h"
#include "misc.h"

int main(int argc,char **argv)
{
 URL *Url;
 char **list,*refresh;
 int j;

 if(argc==1)
   {fprintf(stderr,"usage: test-html <URL>\n");return(1);}

 Url=SplitURL(argv[1]);

 init_buffer(0);
 ParseHTML(0,Url,1);

 if((refresh=MetaRefresh()))
    printf("Refresh = %s\n",refresh);

 if((list=ListStyleSheets()))
    for(j=0;list[j];j++)
       printf("StyleSheet = %s\n",list[j]);

 if((list=ListImages()))
    for(j=0;list[j];j++)
       printf("Image = %s\n",list[j]);

 if((list=ListFrames()))
    for(j=0;list[j];j++)
       printf("Frame = %s\n",list[j]);

 if((list=ListScripts()))
    for(j=0;list[j];j++)
       printf("Script = %s\n",list[j]);

 if((list=ListObjects()))
    for(j=0;list[j];j++)
       printf("Object = %s\n",list[j]);

 if((list=ListLinks()))
    for(j=0;list[j];j++)
       printf("Link  = %s\n",list[j]);

 FreeURL(Url);

 return(0);
}
