/***************************************
  $Header: /home/amb/wwwoffle/RCS/http.c 1.11 1998/05/31 15:43:04 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.2.
  Functions for getting URLs using HTTP.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "wwwoffle.h"
#include "errors.h"
#include "misc.h"
#include "config.h"
#include "sockets.h"
#include "proto.h"

/*+ Set to the name of the proxy if there is one. +*/
static char *proxy=NULL;

/*+ The file descriptor of the server. +*/
static int server=-1;



/*++++++++++++++++++++++++++++++++++++++
  Open a connection to get a URL using HTTP.

  char *HTTP_Open Returns NULL on success, a useful message on error.

  URL *Url The URL to open.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Open(URL *Url)
{
 char *msg=NULL;
 char *colon;
 char *server_host=NULL;
 int server_port=Protocols[Protocol_HTTP].defport;

 proxy=WhichProxy(Url->proto,Url->host);
 if(IsLocalNetHost(Url->host))
    proxy=NULL;

 if(proxy)
   {
    server_host=(char*)malloc(strlen(proxy)+1);
    strcpy(server_host,proxy);
   }
 else
   {
    server_host=(char*)malloc(strlen(Url->host)+1);
    strcpy(server_host,Url->host);
   }

 if((colon=strchr(server_host,':')))
   {
    *colon++=0;
    if(*colon)
       server_port=atoi(colon);
   }

 /* Open the connection. */

 server=OpenClientSocket(server_host,server_port);
 init_buffer(server);

 if(server==-1)
    msg=PrintMessage(Warning,"Cannot open the HTTP connection to %s port %d; [%!s].",server_host,server_port);

 free(server_host);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Write to the server to request the URL.

  char *HTTP_Request Returns NULL on success, a useful message on error.

  URL *Url The URL to get.

  char *request_head The head of the HTTP request for the URL.

  char *request_body The body of the HTTP request for the URL.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_Request(URL *Url,char *request_head,char *request_body)
{
 char *msg=NULL;
 char *new_request_head;

 if(proxy)
    new_request_head=MakeRequestAuthorised(proxy,request_head);
 else
    new_request_head=MakeRequestNonProxy(request_head);

 if(proxy)
    PrintMessage(ExtraDebug,"Outgoing Request Head (to proxy)\n%s",new_request_head);
 else
    PrintMessage(ExtraDebug,"Outgoing Request Head (to server)\n%s",new_request_head);

 if(write_string(server,new_request_head)==-1)
    msg=PrintMessage(Warning,"Failed to write to remote HTTP %s [%!s].",proxy?"proxy":"server");
 if(request_body && write_string(server,request_body)==-1)
    msg=PrintMessage(Warning,"Failed to write to remote HTTP %s [%!s].",proxy?"proxy":"server");

 if(request_head!=new_request_head)
    free(new_request_head);

 return(msg);
}


/*++++++++++++++++++++++++++++++++++++++
  Read a line from the header of the reply for the URL.

  char *HTTP_ReadHead Returns the next line of data, NULL on EOF.

  char *line The previous line read.
  ++++++++++++++++++++++++++++++++++++++*/

char *HTTP_ReadHead(char *line)
{
 return(read_line_or_timeout(server,line));
}


/*++++++++++++++++++++++++++++++++++++++
  Read bytes from the body of the reply for the URL.

  int HTTP_ReadBody Returns the number of bytes read on success, -1 on error.

  char *s A string to fill in with the information.

  int n The number of bytes to read.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_ReadBody(char *s,int n)
{
 return(read_data_or_timeout(server,s,n));
}


/*++++++++++++++++++++++++++++++++++++++
  Close a connection opened using HTTP.

  int HTTP_Close Return 0 on success, -1 on error.
  ++++++++++++++++++++++++++++++++++++++*/

int HTTP_Close(void)
{
 return(CloseSocket(server));
}
