/*
    Wn: A Server for the HTTP
    File: wn/cgi.c
    Version 2.0.4
    
    Copyright (C) 1996-8  <by John Franks>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "wn.h"
#include "version.h"
#include "cgi.h"

static void	cgi_headers();

static CGI_data	*cgip = NULL;

/*
 * sendcgi( ip)  Open pipe from "ip->filepath" command
 * and send output using CGI standards
 */

void
sendcgi( ip)
Request	*ip;
{
#ifndef FORBID_CGI
	FILE	*fp;

	register char	*cp;
	int		fdfp,
			buflen;

	char	command[MIDLEN],
		location[MIDLEN],
		cgibuf[OUT_BUFFSIZE + 4],
		buf[BIGLEN],
		*bufptr;


	exec_ok( ip);

	location[0] = '\0';
	*ip->length = '\0';  /* Don't send length of script!! */

	if ( ip->type == RTYPE_CGI_HANDLER) {
		if ( (inheadp->method != GET) && (inheadp->method != POST) ) {
			senderr( SERV_ERR, err_m[117], ip->filepath);
			return;
		}
		mystrncpy( ip->pathinfo, ip->relpath, MIDLEN);
		getfpath( buf, ip->handler, ip);
		mystrncpy( command, buf, MIDLEN - SMALLLEN);
	}
	else { /* RTYPE_CGI or RTYPE_NPH_CGI */
		if ( ip->filetype & WN_DIR ) {
			senderr( SERV_ERR, err_m[55], ip->filepath);
			return;
		}
		mystrncpy( command, ip->filepath, MIDLEN - SMALLLEN);
	}
	mystrncpy( buf, ip->filepath, MIDLEN);
	cp = strrchr( buf, '/');
	*cp = '\0';

	cgi_env( ip, FALSE);  /* Full CGI environment */

	if ( chdir( buf) != 0  )
		logerr( err_m[106], buf);

	if ( ((inheadp->method == POST) || (inheadp->method == PUT))
			&& (*inheadp->tmpfile != '\0')) {
		strcat( command, " < ");
		strcat( command, inheadp->tmpfile);
	}

	if ( !*ip->query || (strchr( ip->query, '=') != NULL)
	     		|| ( ip->type == RTYPE_CGI_HANDLER) ) {
		/* '=' in query so don't use on command line */
		if ((fp = popen( command, "r")) == (FILE *) NULL ) {
			senderr( SERV_ERR, err_m[55], ip->filepath);
			return;
		}
	} else { /* no '=' means its an isindex, ugh!  */
		www_unescape( ip->query, ' ');
		if ( (fp = safer_popen( ip->filepath, ip->query))
					== (FILE *) NULL )
			if ( (fp = popen( command, "r")) 
						== (FILE *) NULL ) {
				senderr( SERV_ERR, err_m[55], ip->filepath);
				return;
			}
	}

	fdfp = fileno( fp);

	if ( ip->type == RTYPE_NPH_CGI) {  /* CGI handles headers */
		ip->attributes |= WN_UNBUFFERED;  /* Don't buffer CGI */
		this_conp->keepalive = FALSE;

		send_out_fd( fdfp);

		pclose( fp);
		writelog( ip, log_m[7], ip->filepath);
		if ( *inheadp->tmpfile) {
			unlink( inheadp->tmpfile);
			*inheadp->tmpfile = '\0';
		}
		return; /* to end of process_url */
	}

	/* It's a standard CGI, not an nph-CGI.  We do headers */
	cgi_headers( fp, cgibuf, location, &bufptr, &buflen);
	if ( ip->status & WN_ERROR)
		return;


	if ( !*location) {

		http_prolog( );
		ip->attributes |= WN_UNBUFFERED;  /* Don't buffer CGI */
		send_out_mem( bufptr, buflen);
		send_out_fd( fdfp);

		pclose( fp);
		writelog( ip, log_m[8], ip->filepath);
		if ( *inheadp->tmpfile) {
			unlink( inheadp->tmpfile);
			*inheadp->tmpfile = '\0';
		}
		return;  /* to end of process_url */
	}
	else {
		writelog( ip, log_m[9], location);
		sprintf( ip->request, log_m[12], location);
		dolocation( location, ip, 302); /* should be 303 */
		pclose( fp);
		if ( *inheadp->tmpfile) {
			unlink( inheadp->tmpfile);
			*inheadp->tmpfile = '\0';
		}
		return; /* to end of process_url */
	}
#endif
}


/*
 * cgi_env( ip, auth) Create environment variables required for CGI.
 * Also WN_ROOT and WN_DIR_PATH.  If auth = TRUE then only do a 
 * small subset of the variables for authentication. 
 */

void
cgi_env( ip, auth)
Request	*ip;
int	auth;
{
	register char	*cp;

	if ( ip->status & WN_CGI_SET)
		return;		/* CGI environment vars already set */

	if ( cgip == NULL) {
		if ((cgip = (CGI_data *) malloc(sizeof (CGI_data))) == NULL ) {
			logerr( err_m[64], "cgi_env");
			return;
		}
	}

	bzero( (char *)cgip, sizeof( CGI_data)); 
	strcpy( cgip->method, "REQUEST_METHOD=");
	switch ( inheadp->method) {
	case GET:
		strcat( cgip->method, "GET");
		break;
	case POST:
		strcat( cgip->method, "POST");
		strcpy( cgip->postfile, "HTTP_POST_FILE=");
		mystrncat( cgip->postfile, inheadp->tmpfile, SMALLLEN);
		putenv( cgip->postfile);
		break;
	case PUT:
		strcat( cgip->method, "PUT");
		strcpy( cgip->postfile, "HTTP_PUT_FILE=");
		mystrncat( cgip->postfile, inheadp->tmpfile, SMALLLEN);
		putenv( cgip->postfile);
		break;
	default:
		break;
	}
	putenv( cgip->method);

	strcpy( cgip->dirpath, "WN_DIR_PATH=");
	mystrncat( cgip->dirpath, ip->cachepath, SMALLLEN);
	if ( (cp = strrchr( cgip->dirpath, '/')) != NULL )
		*cp = '\0';
	putenv( cgip->dirpath);

	if ( *(ip->authuser)) {
		strcpy( cgip->ruser, "REMOTE_USER=");
		mystrncat( cgip->ruser, ip->authuser, SMALLLEN);
		putenv( cgip->ruser);
	}

	if ( dir_p->authtype && *(dir_p->authtype)) {
		strcpy( cgip->authtype, "AUTH_TYPE=");
		mystrncat( cgip->authtype, dir_p->authtype, TINYLEN - 10);
		putenv( cgip->authtype);
	}

#ifdef OPEN_BIG_SECURITY_HOLE
	if ( *(inheadp->authorization)) {
		strcpy( cgip->authorization, "HTTP_AUTHORIZATION=");
		mystrncat( cgip->authorization, inheadp->authorization,
						MIDLEN - 20);
		putenv( cgip->authorization);
	}
#endif

#ifdef DIGEST_AUTHENTICATION
	if ( strncasecmp( inheadp->authorization, "Digest", 6) == 0 &&
			dir_p->authtype &&
			strcasecmp( dir_p->authtype, "Digest") == 0 ) {
		if ( !(*cgip->authorization)) {
			strcpy( cgip->authorization, "HTTP_AUTHORIZATION=");
			mystrncat( cgip->authorization, inheadp->authorization,
							MIDLEN - 20);
			putenv( cgip->authorization);
		}
		if ( (cp = strchr( outheadp->md5, ':')) != NULL ) {
			strcpy( cgip->md5, "CONTENT_MD5=");
			cp++;
			while ( isspace ( *cp))
				cp++;
			mystrncat( cgip->md5, cp, TINYLEN);
			putenv( cgip->md5);
		}
	}
#endif

	if ( *(inheadp->host_head) ) {
		strcpy( cgip->http_myhost, "HTTP_HOST=");
		mystrncat( cgip->http_myhost, inheadp->host_head, SMALLLEN);
		putenv( cgip->http_myhost);
	}

	strcpy( cgip->lochost, "SERVER_NAME=");
	strcat( cgip->lochost, hostname);
	putenv( cgip->lochost);

	strcpy( cgip->dataroot, "WN_ROOT=");
	mystrncat( cgip->dataroot, ip->rootdir, SMALLLEN - 20);
	putenv( cgip->dataroot);

	strcpy( cgip->dataroot2, "DOCUMENT_ROOT=");
	mystrncat( cgip->dataroot2, ip->rootdir, SMALLLEN - 20);
	putenv( cgip->dataroot2);

	if ( !(this_conp->con_status & WN_CON_CGI_SET)) {
		strcpy( cgip->raddr, "REMOTE_ADDR=");
		mystrncat( cgip->raddr, this_conp->remaddr, TINYLEN);
		putenv( cgip->raddr);

		sprintf( cgip->lport,"SERVER_PORT=%d", port);
		putenv( cgip->lport);
	}


	/* End of auth set of CGI variables */
	if ( auth)
		return;

	if ( !(this_conp->con_status & WN_CON_CGI_SET)) {

		this_conp->con_status |=  WN_CON_CGI_SET;

		if ( !*this_conp->remotehost )
				/* Get remote hostname if not already done */
			get_remote_info( );

		strcpy( cgip->rhost, "REMOTE_HOST=");
		mystrncat( cgip->rhost, this_conp->remotehost, MAXHOSTNAMELEN);
		putenv( cgip->rhost);

		sprintf( cgip->scheme,"URL_SCHEME=%.32s", this_conp->scheme);
		putenv( cgip->scheme);

		putenv("GATEWAY_INTERFACE=CGI/1.1");
	
		strcpy( cgip->servsoft, "SERVER_SOFTWARE=");
		strcat( cgip->servsoft, VERSION);
		putenv( cgip->servsoft);

#ifdef RFC931_TIMEOUT
		get_rfc931();
		if ( *(this_conp->rfc931name)) {
			strcpy( cgip->rident, "REMOTE_IDENT=");
			mystrncat( cgip->rident,
					this_conp->rfc931name, SMALLLEN);
			putenv( cgip->rident);
		}
#endif                    
	}

	if ( *(ip->query)) {
		strcpy( cgip->query, "QUERY_STRING=");
		mystrncat( cgip->query, ip->query, MIDLEN);
		putenv( cgip->query);
	}

	strcpy( cgip->serv_protocol, "SERVER_PROTOCOL=");
	switch ( inheadp->protocol) {
	case HTTP0_9:
		strcat(cgip->serv_protocol, "HTTP/0.9");
		break;
	case HTTP1_1:
		strcat(cgip->serv_protocol, "HTTP/1.1");
		break;
	default:
		strcat( cgip->serv_protocol, "HTTP/1.0");
		break;
	}

	putenv( cgip->serv_protocol);

	if ( *(ip->pathinfo) ) {
		strcpy( cgip->pathinfo, "PATH_INFO=");
		mystrncat( cgip->pathinfo, ip->pathinfo, MIDLEN);
		putenv( cgip->pathinfo);
	}

	strcpy( cgip->tpath, "PATH_TRANSLATED=");
	if ( *ip->pathinfo) {
		mystrncat( cgip->tpath, ip->rootdir, SMALLLEN);
		mystrncat( cgip->tpath,	ip->pathinfo, MIDLEN);
	}
	putenv( cgip->tpath);

	strcpy( cgip->scrname, "SCRIPT_NAME=");
	if ( (ip->type == RTYPE_CGI_HANDLER) && (*ip->handler)) {
		cp = strrchr( ip->handler, '/');
		if ( cp)
			mystrncat( cgip->scrname, cp+1, MIDLEN - 20);
		else 
			*(cgip->scrname) = '\0';
	}
	else {
		cp = ip->filepath + strlen( ip->rootdir);
		mystrncat( cgip->scrname, cp, MIDLEN - 20);
	}
	if ( *(cgip->scrname) )
		putenv( cgip->scrname);

	strcpy( cgip->filescrname, "SCRIPT_FILENAME=");
	if ( (ip->type == RTYPE_CGI_HANDLER) && (*ip->handler))
		mystrncat( cgip->filescrname, ip->handler, MIDLEN - 20);
	else {
		mystrncat( cgip->filescrname, ip->filepath, MIDLEN - 20);
	}
	putenv( cgip->filescrname);

	if ( *(inheadp->content) ) {
		strcpy( cgip->content, "CONTENT_TYPE=");
		mystrncat( cgip->content, inheadp->content, SMALLLEN);
		putenv( cgip->content);
	}

	if ( *(inheadp->length) ) {
		strcpy( cgip->length, "CONTENT_LENGTH=");
		mystrncat( cgip->length, inheadp->length, SMALLLEN);
		putenv( cgip->length);
	}

	if ( *(inheadp->accept) ) {
		strcpy( cgip->http_accept, "HTTP_ACCEPT=");
		mystrncat( cgip->http_accept, inheadp->accept, ACCEPTLEN);
		putenv( cgip->http_accept);
	}

	if ( *(inheadp->charset) ) {
		strcpy( cgip->http_charset, "HTTP_ACCEPT_CHARSET=");
		mystrncat( cgip->http_charset, inheadp->charset, ACCEPTLEN/4);
		putenv( cgip->http_charset);
	}

	if ( *(inheadp->lang) ) {
		strcpy( cgip->http_lang, "HTTP_ACCEPT_LANGUAGE=");
		mystrncat( cgip->http_lang, inheadp->lang, ACCEPTLEN/4);
		putenv( cgip->http_lang);
	}

	if ( *(inheadp->cookie) ) {
		strcpy( cgip->http_cookie, "HTTP_COOKIE=");
		mystrncat( cgip->http_cookie, inheadp->cookie, ACCEPTLEN);
		putenv( cgip->http_cookie);
	}

	if ( *(inheadp->range) ) {
		strcpy( cgip->range, "HTTP_RANGE=");
		mystrncat( cgip->range, inheadp->range, RANGELEN - TINYLEN);
		putenv( cgip->range);
	}

	if ( *(inheadp->referrer) ) {
		strcpy( cgip->http_referrer, "HTTP_REFERER=");
		mystrncat( cgip->http_referrer, inheadp->referrer, MIDLEN);
		putenv( cgip->http_referrer);
	}

	if ( *(inheadp->ua) ) {
		strcpy( cgip->http_ua, "HTTP_USER_AGENT=");
		mystrncat( cgip->http_ua, inheadp->ua, SMALLLEN);
		putenv( cgip->http_ua);
	}

	if ( *(inheadp->from) ) {
		strcpy( cgip->http_from, "HTTP_FROM=");
		mystrncat( cgip->http_from, inheadp->from, SMALLLEN);
		putenv( cgip->http_from);
	}

	ip->status |= WN_CGI_SET;  /* mark environment as setup */
}


static void
cgi_headers( fp, cgibuf, location, bufptr, buflen)
FILE	*fp;
char	*cgibuf,
	*location,
	**bufptr;

int	*buflen;
{
	register char	*beginl,
			*endl,
			*cp = NULL;

	int		fd,
			n,
			m;

	fd = fileno( fp);
	while ( (n = read( fd, cgibuf, OUT_BUFFSIZE )) <= 0 ) {
		if ( (n == -1) && (errno == EINTR))
			continue;
		senderr( SERV_ERR, err_m[76], "cgi_headers");
		pclose( fp);
		return;
	}

	beginl = cgibuf;
	cgibuf[n] = '\0';

	while ( TRUE) {
		if ( ( endl = strchr( beginl, '\n')) == NULL) {
			/* not all headers have been read; read more */
			n -= (beginl - cgibuf);
			mymemcpy( cgibuf, beginl, n);
			while ( (m = read( fd, cgibuf + n, OUT_BUFFSIZE - n))
								<= 0 ) {
				if ( (m == -1) && (errno == EINTR))
					continue;
				senderr( SERV_ERR, err_m[104], "");
				pclose( fp);
				return;
			}

			n += m;
			cgibuf[n] = '\0';
			beginl = cgibuf;
			continue;
		}
		if (endl > cgibuf && endl[-1] == '\r')
			endl[-1] = '\0';
		*endl++ = '\0';
		if ( *beginl == '\0' ) { 	/* blank line: end of header */
			beginl = endl;
			n -= (beginl - cgibuf);
			break;
		}

		if ( strncasecmp( "Content-type:", beginl, 13) == 0) {
			cp = beginl + 13;
			while ( isspace( *cp))
				cp++;
			mystrncpy( cgip->cgi_content_type, cp, SMALLLEN);
			this_rp->content_type = cgip->cgi_content_type;
		}
		else if ( (strncasecmp("Location:", beginl, 9) == 0)) {
			cp = beginl + 9;
			while ( isspace( *cp))
				cp++;
			mystrncpy( location, cp, MIDLEN);
		}
		else if ( (strncasecmp("Status:", beginl, 7) == 0)) {
			cp = beginl + 7;
			while ( isspace( *cp))
				cp++;
			mystrncpy( outheadp->status, cp, SMALLLEN);
		}
		else if ( (strncasecmp("Expires:", beginl, 8) == 0)) {
			mystrncpy( outheadp->expires, beginl, SMALLLEN - 2);
			strcat( outheadp->expires, "\r\n");
		}
		else {
			if (strlen(beginl) + strlen(outheadp->list) < BIGLEN) {
				strcat( outheadp->list, beginl);
				strcat( outheadp->list, "\r\n");
			}
			else {
				senderr( SERV_ERR, err_m[56], "");
				pclose( fp);
				return;
			}

		}
		beginl = endl;
	}
	*buflen = n;
	*bufptr = endl;
}
