/*************************************************************
 * WebMailFolder                                             *
 * COPYRIGHT 1998 by Norbert Kuemin <norbert.kuemin@gmx.net> *
 *************************************************************/
   
#define MAIL_FILE
#include "wmf.h"

char *Email2Html(struct MAILHEAD *mh) {
    char *tmpEmail, *tmpName;

    if (strlen(mh->SendName) > 0)
	tmpName = Text_2_Html(mh->SendName);
    else
	tmpName = dupchar(mh->SendName);

    if (config.MailCommand != NULL) {
	if (strlen(mh->SendName) == 0) {
	    tmpEmail = newchar(strlen(config.MailCommand)+
		strlen(mh->SendAddress)*2+23);
	    sprintf(tmpEmail,"<I><A HREF=\"%s%s\">%s</A></I>",config.MailCommand,
		mh->SendAddress,mh->SendAddress);
	} else {
	    tmpEmail = newchar(strlen(config.MailCommand)+
		strlen(mh->SendAddress)+strlen(tmpName)+23);
	    sprintf(tmpEmail,"<I><A HREF=\"%s%s\">%s</A></I>",config.MailCommand,
		mh->SendAddress,tmpName);
	}
    } else {
	if (strlen(mh->SendName) == 0) {
	    tmpEmail = newchar(strlen(mh->SendAddress)+8);
	    sprintf(tmpEmail,"<I>%s</I>",mh->SendAddress);
	} else {
	    tmpEmail = newchar(strlen(tmpName)+8);
	    sprintf(tmpEmail,"<I>%s</I>",tmpName);
	}
    }
    freechar(tmpName);
    return tmpEmail;
}

int IsEmailChar(char chr) {
    if ((chr >= 'A') && (chr <= 'Z')) return TRUE;
    if ((chr >= 'a') && (chr <= 'z')) return TRUE;
    if ((chr >= '0') && (chr <= '9')) return TRUE;
    if (chr == '-') return TRUE;
    if (chr == '_') return TRUE;
    return FALSE;
}


char *GetHeadData(char *line) {
    char *c;
    char *data;
    int i;

    if (config.DebugLevel & 1)
        printf(".GetHeadData(%s)\n",line);
    c = line;
    while ((c[0] != ':') && (c[0] != '\0')) c++;
    if (c[0] != '\0') c++;
    while ((c[0] == ' ') || (c[0] == '\t')) c++;
    i = 0;
    while ((c[i] != '\n') && (c[i] != '\0'))
        i++;
    if (i > 0) i--;
    while (((c[i] == ' ') || (c[i] == '\t')) && (i > 0)) i--;
    if (c[i] != '\0') i++;
    data = newchar(i+1);
    strncpy(data,c,i);
    data[i] = '\0';
    if (config.DebugLevel & 2)
        printf(".GetHeadData_Return(%s)\n",data);
    return data;
}


char *GetName(char *line) {
    char *name;
    char *c;
    int i;
        

    if (config.DebugLevel & 1)
        printf(".GetName(%s)\n",line);
    switch (line[strlen(line)-1]) {
	case '>': /* name <email> */
	    c = line;
	    /* remove spaces and special chars */
	    while ((c[0] == ' ') || (c[0] == '\"')) c++;
	    /* Calculate length */
	    i = strlen(c);
	    while ((c[i] != '<') && (i != 0))
	        i--;
	    i--;
	    /* Remove spaces at the end */
	    while ((c[i] == ' ') || (c[i] == '\"'))
	        i--;
	    i++;
            if (c[0] == '<') {
		name = newchar(1);
        	name[0] = '\0';
            } else {
		name = newchar(i+1);
		strncpy(name,c,i);
        	name[i] = '\0';
            }
	    name = newchar(i+1);
	    strncpy(name,c,i);
            name[i] = '\0';
	    break;
	case ')': /* email (name) */
	    c = line;
	    /* Start at ( */
	    while (c[0] != '(') c++;
	    c++;
	    /* remove spces and special chars */
	    while ((c[0] == ' ') || (c[0] == '\"')) c++;
	    /* Calculate length */
	    i = 0;
	    while ((c[i] != ')') && (c[i] != '\0'))
	        i++;
	    i--;
	    /* Remove spaces at the end */
	    while ((c[i] == ' ') || (c[i] == '\"'))
	        i--;
	    i++;
	    name = newchar(i+1);
	    strncpy(name,c,i);
            name[i] = '\0';
	    break;
	default: /* Email only */
	    name = "\0";
	    break;
    }
    return name;
}


char *GetEmail(char *line) {
    char *email;
    char *c;
    int i;

    if (config.DebugLevel & 1)
        printf(".GetEmail(%s)\n",line);        
    switch (line[strlen(line)-1]) {
	case '>': /* name <email> */
	    c = line;
	    while (c[0] != '<') c++;
	    c++;
	    /* Calculate length */
	    i = 0;
	    while ((c[i] != '>') && (c[i] != '\0'))
	        i++;
	    email = newchar(i+1);
	    strncpy(email,c,i);
            email[i] = '\0';
	    break;
	case ')': /* email (name) */
	    c = line;
	    /* Calculate length */
	    i = 0;
	    while ((c[i] != '(') && (c[i] != '\0'))
	        i++;
	    i--;
	    /* Remove spaces at the end */
	    while ((c[i] == ' '))
	        i--;
	    i++;
	    email = newchar(i+1);
	    strncpy(email,c,i);
            email[i] = '\0';
	    break;
	default: /* Email only */
            email = dupchar(line);
	    break;
    }
    return email;
}


char *GetMsgId(char *line) {
    char *id;
    char *c;
    int i;
        

    if (config.DebugLevel & 1)
        printf(".GetMsgId(%s)\n",line);
    c = line;
    /* Start at < */
    while (c[0] != '<') {
        if (c[0] == 0) break;
        c++;
    }
    if (c[0] != 0) c++;
    /* Calculate length */
    i = 0;
    while ((c[i] != '>') && (c[i] != '\0'))
        i++;
    id = newchar(i+1);
    strncpy(id,c,i);
    id[i] = '\0';
    return id;
}


char *AddData(char *line, char *data) {
    char *newdata;
    char *c;
    int i;
        

    if (config.DebugLevel & 1)
        printf(".AddData(%s)\n",line);
    c = line;
    /* remove spaces and tabs at start */
    while ((c[0] == ' ') || (c[0] == '\t')) c++;
    /* Calculate length */
    i = 0;
    while ((c[i] != '\n') && (c[i] != '\0'))
        i++;
    if ((line[0] == '\t') || (strncmp(line,"        ",8) == 0)) {
	newdata = newchar(i+strlen(data)+2);
    } else {
	newdata = newchar(i+strlen(data)+1);
    }
    strcpy(newdata,data);
    if ((line[0] == '\t') || (strncmp(line,"        ",8) == 0))
        strcat(newdata," ");
    strncat(newdata,c,i);
    strcat(newdata,"\0");
    return newdata;
}


struct MAILBODY *addbody(char *line, struct MAILBODY *body) {

    if (config.DebugLevel & 1)
        printf(".addbody(%s)\n",line);
    if (body->Line == NULL) {
	body->Line = dupchar(line);
	body->Next = NULL;
	return body;
    } else {
	body->Next = (struct MAILBODY *) malloc(sizeof(struct MAILBODY));
	body->Next->Line = dupchar(line);
	body->Next->Next = NULL;
	return body->Next;
    }
}


void GetMail(FILE *fd, struct MAILHEAD *mh, struct MAILBODY *mb) {
    char line[BUFSIZ];
    char *tmpFrom, *tmpTo, *tmpId, *tmpRef, *tmpstr, *tmpType, *tmpEncode;
    struct MAILBODY *body;
    int status; /* -1=Error 0=End 1=Header 2=Body */
    int lastlength;
    int lastheadcmd; /*-1=Unknown 0=None 1=From 2=To 3=Subject 4=Date
    			5=Message-Id 6=Reference 7=Xface 8=HomePage
    			9=MimeType 10=MimeEncode 11=MimeDescription*/
    
    if (config.DebugLevel & 1)
        printf(".GetMail\n");
    body = mb;
    body->Line = NULL;
    body->Next = NULL;
    lastheadcmd = 0;
    status = 1;
    lastlength = 0;
    tmpFrom = NULL;
    tmpTo = NULL;
    tmpId = NULL;
    tmpRef = NULL;
    tmpType = NULL;
    tmpEncode = NULL;
    mh->SendName = "\0";
    mh->SendAddress = "\0";
    mh->ReceiveName = "\0";
    mh->ReceiveAddress = "\0";
    mh->SentDate = "\0";
    mh->MsgId = "\0";
    mh->Subject = "\0";
    mh->Reference = "\0";
    mh->Xface = "\0";
    mh->FileName = "\0";
    mh->HomePage = "\0";
    mh->AttachFile = "\0";
    mh->MimeBoundary = "\0";
    mh->MimeDescription = "\0";
    mh->MimeType = MIME_TYPE_NONE;
    mh->MimeCharset = MIME_CHARSET_NONE;
    mh->MimeEncode = MIME_ENCODE_NONE;
    mh->InReply = FALSE;
    while (status > 0) {
        if(feof(fd) == 0) {
            fgets(line,BUFSIZ,fd);
	    if ((status == 2) && (strncmp(line,"\001\001\001\001",4) == 0))
		status = 0;
            while ((status == 1) && (strncmp(line,"\001\001\001\001",4) == 0) &&
		(feof(fd) == 0))
		fgets(line,BUFSIZ,fd);
	} else {
            status = 0;
	}
	switch (status) {
	    case 1:
	        /* Header */
		if ((strlen(line) == 0) || (line[0] == '\n')) {
		    /* An empty line indicates the end of the header */
		    status = 2;
		    if (tmpFrom != NULL) {
			mh->SendAddress = GetEmail(tmpFrom);
			mh->SendName = GetName(tmpFrom);
			freechar(tmpFrom);
		    }
		    if (tmpTo != NULL) {
			mh->ReceiveAddress = GetEmail(tmpTo);
			mh->ReceiveName = GetName(tmpTo);
			freechar(tmpTo);
		    }
		    if (tmpId != NULL) {
			mh->MsgId = GetMsgId(tmpId);
			freechar(tmpId);
		    }
		    if (tmpRef != NULL) {
			mh->Reference = GetMsgId(tmpRef);
			freechar(tmpRef);
		    }
		    if (tmpType != NULL) {
			mh->MimeType = GetContentType(tmpType);
			if (mh->MimeType == MIME_TYPE_TEXT_PLAIN)
			    mh->MimeCharset = GetCharset(tmpType);
			if ((mh->MimeType == MIME_TYPE_MULTIPART_MIXED) ||
			    (mh->MimeType == MIME_TYPE_MULTIPART_SIGNED))
			    mh->MimeBoundary = GetBoundary(tmpType);
			freechar(tmpType);
		    }
		    if (tmpEncode != NULL) {
			mh->MimeEncode = GetContentEncode(tmpEncode);
			freechar(tmpEncode);
		    }
		    if (HeaderIsMimeEncoded(mh->Subject) == TRUE) {
			tmpstr = DecodeMimeHeader(mh->Subject);
			freechar(mh->Subject);
			mh->Subject = tmpstr;
		    }
		}
		if ((line[0] == ' ') || (line[0] == '\t')) {
		    /* A space or tab means add info to previous line */
		    switch (lastheadcmd) {
			case 1:
			    tmpstr = AddData(line,tmpFrom);
			    freechar(tmpFrom);
			    tmpFrom = tmpstr;
			    break;
			case 2:
			    tmpstr = AddData(line,tmpTo);
			    freechar(tmpTo);
			    tmpTo = tmpstr;
			    break;
			case 3:
			    tmpstr = AddData(line,mh->Subject);
			    freechar(mh->Subject);
			    mh->Subject = tmpstr;
			    break;
			case 4: break; /* Unknown to handle */
			case 5:
			    tmpstr = AddData(line,tmpId);
			    freechar(tmpId);
			    tmpId = tmpstr;
			    break;
			case 6:
			    tmpstr = AddData(line,tmpRef);
			    freechar(tmpRef);
			    tmpRef = tmpstr;
			    break;
			case 7:
			    tmpstr = AddData(line,mh->Xface);
			    freechar(mh->Xface);
			    mh->Xface = tmpstr;
			    break;
			case 8:
			    tmpstr = AddData(line,mh->HomePage);
			    freechar(mh->HomePage);
			    mh->HomePage = tmpstr;
			    break;
			case 9:
			    tmpstr = AddData(line,tmpType);
			    freechar(tmpType);
			    tmpType = tmpstr;
			    break;
			case 10:
			    tmpstr = AddData(line,tmpEncode);
			    freechar(tmpEncode);
			    tmpEncode = tmpstr;
			    break;
			case 11:
			    tmpstr = AddData(line,mh->MimeDescription);
			    freechar(mh->MimeDescription);
			    mh->MimeDescription = tmpstr;
			    break;
		    }
		} else {
		    lastheadcmd = -1;
		}
		if (strncmp(line,"From:",5) == 0) {
		    tmpFrom = GetHeadData(line);
		    lastheadcmd = 1;
		}
		if (strncmp(line,"To:",3) == 0) {
		    tmpTo = GetHeadData(line);
		    lastheadcmd = 2;
		}
		if (strncmp(line,"Subject:",8) == 0) {
		    mh->Subject = GetHeadData(line);
		    lastheadcmd = 3;
		}
		if (strncmp(line,"Date:",5) == 0) {
		    mh->SentDate = GetHeadData(line);
		    lastheadcmd = 4;
		}
		if ((strncmp(line,"Message-Id:",11) == 0) ||
		    (strncmp(line,"Message-ID:",11) == 0)) {
		    tmpId = GetHeadData(line);
		    lastheadcmd = 5;
		}
		if ((strncmp(line,"In-Reply-To:",12) == 0) ||
		    (strncmp(line,"References:",11) == 0)) {
		    if (tmpRef != NULL) freechar(tmpRef);
		    tmpRef = GetHeadData(line);
		    lastheadcmd = 6;
		}
		if ((strncmp(line,"X-face:",7) == 0) ||
		    (strncmp(line,"X-Face:",7) == 0)) {
		    mh->Xface = GetHeadData(line);
		    lastheadcmd = 7;
		}
		if (strncmp(line,"X-URL:",6) == 0) {
		    mh->HomePage = GetHeadData(line);
		    lastheadcmd = 8;
		}
		if (strncmp(line,"Content-Type:",13) == 0) {
		    tmpType = GetHeadData(line);
		    lastheadcmd = 9;
		}
		if (strncmp(line,"Content-Transfer-Encoding:",26) == 0) {
		    tmpEncode = GetHeadData(line);
		    lastheadcmd = 10;
		}
		if (strncmp(line,"Content-Description:",20) == 0) {
		    mh->MimeDescription = GetHeadData(line);
		    lastheadcmd = 11;
		}
		break;
	    case 2:
	        /* Body */
		if (lastlength == 0) {
		    if (strncmp(line,"From ",5) == 0) {
			/* Next mail detected */
			status = 0;
		    } else {
			/* It was only an empty line */
			body = addbody("\n",body);
		    }
		}
		lastlength = strlen(line);
		if (line[0] == '\n') lastlength = 0;
		if ((lastlength != 0) && (status > 0) && (feof(fd) == 0)) {
		    body = addbody(line,body);
		}
		break;
	}
	if(feof(fd) != 0) status=0;
    }
}


void LineWrapper(char *Line, long Length) {
    long tmpLength, n;

    if (config.DebugLevel & 1)
        printf(".LineWrapper\n");

    tmpLength = 0;

    while (tmpLength + Length < strlen(Line)) {
	/* Search a space to break the line */
	n = tmpLength + Length;
	while (n > tmpLength) {
	    if (Line[n] == ' ') break;
	    n--;
	}

	if (Line[n] != ' ') {
	    /* No Space found, search to the end */
	    n = tmpLength + Length;
	    while (n < strlen(Line)) {
		if (Line[n] == ' ') break;
		n++;
	    }
	}

	if (Line[n] == ' ') {
	    /* Space found, replace it with a newline */
	    Line[n] = '\n';
	} else {
	    /* Sorry, but no linebreaks without spaces */
	}
	tmpLength = n;
    }
}


void WriteMailBody(char *FileName, char *Data, struct MAILHEAD *mh) {
    char *datastr, *tmpstr, *tmpmail, tmpchar;
    int tmpint, n, m;

    if (config.DebugLevel & 1)
        printf(".WriteMailBody\n");

    if ((mh->MimeType != MIME_TYPE_TEXT_HTML) && (config.BodyHtmlConvert == TRUE)) {
	if ((config.LineSize != WMF_NOVALUE) && (config.LineSize < strlen(Data))) {
	    LineWrapper(Data,config.LineSize);
	}
	datastr = Text_2_Html(Data);
    } else {
	datastr = dupchar(Data);
    }
    
    /* url hyperlinks */
    /* url never will be greater than 10 times the original length */
    if (config.BodyLinkUrl == TRUE) {
	if (config.DebugLevel & 2)
            printf("..UrlHyperlinks\n");
	tmpstr = newchar(strlen(datastr)*10);
	tmpstr[0] = '\0';
	for(n=0;n<(strlen(datastr));n++) {
	    tmpchar = 0;
	    for(m=0 ; protocols[m] != NULL ; m++) {
		if (strncmp((datastr+n),protocols[m],strlen(protocols[m])) == 0) {
		    tmpchar = 0;
	            if (n > 0) tmpchar = datastr[n-1];
		    if (tmpchar != '"') tmpchar = ' ';
		    tmpint = 0;
		    strcat(tmpstr,"<A HREF=\"");
		    for (;;) {
			if (tmpchar == '"') {
			    if (datastr[n+tmpint] == '"') break;
			} else {
			    if (IsUrlChar(datastr[n+tmpint]) == FALSE) break;
			}
			tmpint++;
		    }
		    strncat(tmpstr,datastr+n,tmpint);
		    strcat(tmpstr,"\">");
		    strncat(tmpstr,datastr+n,tmpint);
		    strcat(tmpstr,"</A>");
		    n = n + tmpint;
		}
	    }
	    if (n < strlen(datastr)) {
		tmpstr[strlen(tmpstr)+1] = '\0';
		tmpstr[strlen(tmpstr)] = datastr[n];
	    }
	}
	freechar(datastr);
	datastr = dupchar(tmpstr);
	freechar(tmpstr);
    }

    /* mail hyperlinks */
    /* mail never will be greater than 10 times the original length */
    if (config.DebugLevel & 2)
        printf("..MailHyperlinks\n");
    if ((strstr(datastr,"@") != NULL) && (config.MailCommand != NULL) &&
	(config.BodyLinkEmail == TRUE)) {
    	tmpstr = newchar(strlen(datastr)*10);
	tmpstr[0] = '\0';
	tmpmail = datastr;
	while (tmpmail != NULL) {
	    n=0;
	    while ((tmpmail[n] != '@') && (tmpmail[n] != '\0')) n++;
	    if (tmpmail[n] == '\0') {
		/* Append the rest of the line */
		strcat(tmpstr,tmpmail);
		tmpmail = NULL;
	    } else {
		/* Found a @, now check if it is an email */
		if ((n>0) && (tmpmail[n+1] != '\n')) {
		    if (IsEmailChar(tmpmail[n-1]) && IsEmailChar(tmpmail[n+1])) {
			/* Real email found */
			/* Move to the beginning */
			n--;
			while ((n>=0) && (IsEmailChar(tmpmail[n]) ||
			    (tmpmail[n]=='.'))) n--;
			n++;
			if (n > 0) {
			    strncat(tmpstr,tmpmail,n);
			    tmpmail = tmpmail + n;
			}
			/* Move to the ending */
			n = 0;
			while ((tmpmail[n] != '\0') && ((IsEmailChar(tmpmail[n]) ||
			    (tmpmail[n] == '.') || (tmpmail[n] == '@')))) n++;
			strcat(tmpstr,"<A HREF=\"");
			strcat(tmpstr,config.MailCommand);
			strncat(tmpstr,tmpmail,n);
			strcat(tmpstr,"\">");
			strncat(tmpstr,tmpmail,n);
			strcat(tmpstr,"</A>");
			tmpmail = tmpmail + n;
		    } else {
			/* Seams to be anything else */
			n++;
			strncat(tmpstr,tmpmail,n);
			tmpmail = tmpmail + n;
		    }
		} else {
		    /* Found a @ at the begin or the end of the line */
		    n++;
		    strncat(tmpstr,tmpmail,n);
		    tmpmail = tmpmail + n;
		}
	    }
	}
	freechar(datastr);
	datastr = dupchar(tmpstr);
	freechar(tmpstr);
    }

    /* Write line */
    if ((config.ReplyChars != NULL) && (strchr(config.ReplyChars,Data[0]) != NULL)) {
	if (HtmlCmd.ReplyStart != NULL) AppendFile(FileName,HtmlCmd.ReplyStart);
        mh->InReply = TRUE;
    }
    AppendFile(FileName,datastr);
    freechar(datastr);
    if (((strchr(Data,'\n') != NULL) ||(strchr(Data,'\r') != NULL)) &&
      (mh->InReply == TRUE)) {
	if (HtmlCmd.ReplyEnd != NULL) AppendFile(FileName,HtmlCmd.ReplyEnd);
        mh->InReply = FALSE;
    }
}

void WriteNavIndex(char *Filename) {
    char *tmpstr;

    tmpstr = NULL;
    AppendFile(Filename,"Index:\n");
    AppendFile(Filename,"[<A HREF=\"thread.html\">thread</A>]\n");
    AppendFile(Filename,"[<A HREF=\"date.html\">date</A>]\n");
    AppendFile(Filename,"[<A HREF=\"subject.html\">subject</A>]\n");
    AppendFile(Filename,"[<A HREF=\"author.html\">author</A>]\n");
    if (config.AboutLink != NULL) {
	tmpstr = newchar(strlen(config.AboutLink)+24);
	sprintf(tmpstr,"[<A HREF=\"%s\">about</A>]\n",config.AboutLink);
	AppendFile(Filename,tmpstr);
	freechar(tmpstr);
    }

}

void WriteMail (char *Filename, struct MAILHEAD *mh, struct MAILBODY *mb) {

    char *tmpstr, *tmpmail, *tmpname, *tmpfname, *tmpfile, *ls_subject;
    struct MAILBODY *tmpmb;
    size_t n;
    int Multipart, FileNr, tmplen, fd;

    if (config.DebugLevel & 1)
        printf(".WriteMail\n");

    /* No page without identification */
    if (strlen(mh->SendAddress) == 0) return;
     
    if ((mh->MimeType == MIME_TYPE_MULTIPART_MIXED) ||
	(mh->MimeType == MIME_TYPE_MULTIPART_SIGNED))
	Multipart = TRUE;
    else
	Multipart = FALSE;

    InitHtml(Filename);

    if (config.DebugLevel & 2)
        printf(".Write head\n");
    /* Write headdata as remark */
    WriteHtmlValue(Filename,"EmailData","Start");
    WriteHtmlValue(Filename,"Version",HTML_VERSION);
    WriteHtmlValue(Filename,"Subject",mh->Subject);
    WriteHtmlValue(Filename,"FromName",mh->SendName);
    WriteHtmlValue(Filename,"FromEmail",mh->SendAddress);
    WriteHtmlValue(Filename,"ToName",mh->ReceiveName);
    WriteHtmlValue(Filename,"ToEmail",mh->ReceiveAddress);
    WriteHtmlValue(Filename,"Date",mh->SentDate);
    WriteHtmlValue(Filename,"Id",mh->MsgId);
    WriteHtmlValue(Filename,"Reference",mh->Reference);
    WriteHtmlValue(Filename,"X-Face",mh->Xface);
    WriteHtmlValue(Filename,"X-URL",mh->HomePage);
    WriteHtmlValue(Filename,"EmailData","End");

    ls_subject = Text_2_Html(mh->Subject);

    if (config.DocStartFile != NULL) {
	IncludeFile(Filename,config.DocStartFile);
    } else {
	/* Write html head data */
	if (HtmlCmd.HeadStart == NULL)
	    AppendFile(Filename,HTMLCMD_HEAD_START);
	else
	    AppendFile(Filename,HtmlCmd.HeadStart);
	AppendFile(Filename,"\n");
	if (config.Name == NULL) {
	    tmpstr = newchar(strlen(ls_subject)+17);
	    sprintf(tmpstr,"<TITLE>%s</TITLE>\n",ls_subject);
	} else {
	    tmpstr = newchar(strlen(config.Name)+strlen(ls_subject)+19);
	    sprintf(tmpstr,"<TITLE>%s: %s</TITLE>\n",config.Name,ls_subject);
	}
	AppendFile(Filename,tmpstr);
	freechar(tmpstr);
	if (HtmlCmd.HeadEnd == NULL)
	    AppendFile(Filename,HTMLCMD_HEAD_END);
	else
	    AppendFile(Filename,HtmlCmd.HeadEnd);
	AppendFile(Filename,"\n");
	/* Write html body data */
	if (HtmlCmd.BodyStart == NULL)
	    AppendFile(Filename,HTMLCMD_BODY_START);
	else
	    AppendFile(Filename,HtmlCmd.BodyStart);
	AppendFile(Filename,"\n");
    }

    if (config.FrameSupport == FALSE) {
	WriteHtmlValue(Filename,"IndexControl1","Start");
	WriteNavIndex(Filename);
	if (HtmlCmd.HrStart == NULL)
	    AppendFile(Filename,HTMLCMD_HR_START);
	else
	    AppendFile(Filename,HtmlCmd.HrStart);
	AppendFile(Filename,"\n");
	WriteHtmlValue(Filename,"IndexControl1","End");
    }

    WriteHtmlValue(Filename,"Header","Start");
    AppendFile(Filename,"<PRE>\n");

#ifdef FACES
    /* Include face picture */
    if (config.FaceSupport == TRUE) {
	if (strlen(mh->Xface) > 0) {
	    if (config.FaceDirectory == NULL) {
		tmpstr = newchar(strlen(mh->SendAddress)+5);
		sprintf(tmpstr,"%s.xbm",mh->SendAddress);
	    } else {
		tmpstr = newchar(strlen(mh->SendAddress)+
		    strlen(config.FaceDirectory)+6);
		sprintf(tmpstr,"%s/%s.xbm",config.FaceDirectory,
		    mh->SendAddress);
	    }
	    AppendFile(Filename,"<IMG ALIGN=RIGHT SRC=\"");
	    AppendFile(Filename,tmpstr);
	    AppendFile(Filename,"\">");
	    freechar(tmpstr);
	} else {
	    if (config.NoFaceFile != NULL) {
		AppendFile(Filename,"<IMG ALIGN=RIGHT SRC=\"");
		AppendFile(Filename,config.NoFaceFile);
		AppendFile(Filename,"\">");
	    }
	}
    }
#endif

    /* From */
    tmpmail = NULL;
    tmpname = NULL;
    if (strlen(mh->SendName) > 0)
	tmpfname = Text_2_Html(mh->SendName);
    else
	tmpfname = dupchar(mh->SendName);
	
    if (config.MailCommand == NULL) {
	tmpmail = dupchar(mh->SendAddress);
    } else {
	tmpmail = newchar(strlen(mh->SendAddress)*2+
	    strlen(config.MailCommand)+16);
	sprintf(tmpmail,"<A HREF=\"%s%s\">%s</A>",
	    config.MailCommand,mh->SendAddress,mh->SendAddress);
    }
    
    if (strlen(mh->SendName) > 0) {
	if (strlen(mh->HomePage) > 0) {
	    tmpname = newchar(strlen(tmpfname)+strlen(mh->HomePage)+16);
	    sprintf(tmpname,"<A HREF=\"%s\">%s</A>",
		mh->HomePage,tmpfname);
	} else {
	    if (strlen(mh->SendName) > 0) tmpname = dupchar(tmpfname);
	}
    }
    freechar(tmpfname);

    if (strlen(mh->SendName) == 0) {
	tmpstr = newchar(strlen(tmpmail)+10);
	sprintf(tmpstr,"  From: %s",tmpmail);
	AppendFile(Filename,tmpstr);
	freechar(tmpstr);
	if (strlen(mh->HomePage) > 0) {
	    tmpstr = newchar(strlen(mh->HomePage)*2+18);
	    sprintf(tmpstr," <A HREF=\"%s\">%s</A>\n",  
		mh->HomePage,mh->HomePage);
	} else {
	    tmpstr = dupchar("\n");
	}
    } else {
        tmpstr = newchar(strlen(tmpname)+strlen(tmpmail)+26);
	sprintf(tmpstr,"  From: %s &lt;<I>%s</I>&gt;\n",tmpname,tmpmail);
	freechar(tmpname);
    }
    AppendFile(Filename,tmpstr);
    freechar(tmpstr);
    freechar(tmpmail);

    /* To */
    if (strlen(mh->SendName) > 0)
	tmpfname = Text_2_Html(mh->ReceiveName);
    else
	tmpfname = dupchar(mh->ReceiveName);
    if (config.MailCommand == NULL) {
        if (strlen(mh->ReceiveName) == 0) {
	    tmpstr = newchar(strlen(mh->ReceiveAddress)+9);
	    sprintf(tmpstr,"  To  : %s\n",mh->ReceiveAddress);
        } else {
	    tmpstr = newchar(strlen(tmpfname)+strlen(mh->ReceiveAddress)+26);
	    sprintf(tmpstr,"  To  : %s &lt;<I>%s</I>&gt;\n",tmpfname,mh->ReceiveAddress);
        }
        AppendFile(Filename,tmpstr);
        freechar(tmpstr);
    } else {
	if (strstr(mh->ReceiveAddress,",") != NULL) {
	    /* Multiple address */
	    tmpstr = newchar(strlen(mh->ReceiveAddress)*10+
		strlen(config.MailCommand)+25);
	    sprintf(tmpstr,"  To  : ");
	    tmpmail = mh->ReceiveAddress;
	    while (tmpmail != NULL) {
	        /* remove leading spaces */
	        while (tmpmail[0] == ' ') tmpmail++;
	        n=0;
		while ((tmpmail[n] != '\0') && (tmpmail[n] != ',')) n++;
		strcat(tmpstr,"<A HREF=\"");
		strcat(tmpstr,config.MailCommand);
		strncat(tmpstr,tmpmail,n);
		strcat(tmpstr,"\">");
		strncat(tmpstr,tmpmail,n);
		strcat(tmpstr,"</A>");
		if (tmpmail[n] == ',') {
		    strcat(tmpstr,", ");
		    tmpmail = tmpmail + n + 1;
		} else {
		    strcat(tmpstr,"\n");
		    tmpmail = NULL;
		}
	    }
	} else {
	    /* Single address */
	    if (strlen(mh->ReceiveName) == 0) {
		tmpstr = newchar(strlen(mh->ReceiveAddress)*2+
		    strlen(config.MailCommand)+25);
		sprintf(tmpstr,"  To  : <A HREF=\"%s%s\">%s</A>\n",
		    config.MailCommand,mh->ReceiveAddress,mh->ReceiveAddress);
 	    } else {
		tmpstr = newchar(strlen(tmpfname)+
		    strlen(mh->ReceiveAddress)*2+strlen(config.MailCommand)+41);
		sprintf(tmpstr,"  To  : %s &lt;<I><A HREF=\"%s%s\">%s</A></I>&gt;\n",
		    tmpfname,config.MailCommand,mh->ReceiveAddress,
		    mh->ReceiveAddress);
	    }
	}
        AppendFile(Filename,tmpstr);
        freechar(tmpstr);
        freechar(tmpfname);
    }
    tmpstr = newchar(strlen(mh->SentDate)+10);
    sprintf(tmpstr,"  Date: %s\n",mh->SentDate);
    AppendFile(Filename,tmpstr);
    freechar(tmpstr);
    AppendFile(Filename,"</PRE>\n");

    /* Subject as title */
    tmpstr = newchar(strlen(ls_subject)+11);
    sprintf(tmpstr,"<H1>%s</H1>\n",ls_subject);
    AppendFile(Filename,tmpstr);
    freechar(tmpstr);
    tmpstr = NULL;
    freechar(ls_subject);
    ls_subject = NULL;
    
    WriteHtmlValue(Filename,"Header","End");

    if (config.DebugLevel & 2)
        printf(".Write body\n");
    WriteHtmlValue(Filename,"Body","Start");
    AppendFile(Filename,"<PRE>\n");
    tmpmb = mb;
    if (Multipart == TRUE) {
	while ((tmpmb != NULL) && (tmpmb->Line != NULL)) {
	    if (strstr(tmpmb->Line,mh->MimeBoundary) != NULL) break;
	    tmpmb = tmpmb->Next;
	}
	while (tmpmb != NULL) {
	    /* If boundery */
	    if (strstr(tmpmb->Line,mh->MimeBoundary) != NULL) {
		if (strlen(mh->AttachFile) > 0) {
		    freechar(mh->AttachFile);
		    mh->AttachFile = "\0";
		}
		if (mh->MimeDescription[0] != '\0') {
		    freechar(mh->MimeDescription);
		    mh->MimeDescription = "\0";
		}
		mh->MimeEncode = MIME_ENCODE_NONE;
		tmpmb = tmpmb->Next;
		while (tmpmb != NULL) {
		    if ((tmpmb->Line == NULL) || (tmpmb->Line[0] == '\n')) {
			/* An empty line ends the boundery */
			tmpmb = tmpmb->Next;
			break;
		    }
		    if (strncmp(tmpmb->Line,"Content-Type:",13) == 0) {
			mh->MimeType = GetContentType(tmpmb->Line + 14);
		    }
		    if (strncmp(tmpmb->Line,"Content-Disposition:",20) == 0) {
			if (strstr(tmpmb->Line,"attachment") != NULL ) {
			    tmpstr = GetAttachmentName(tmpmb->Line + 20);
			    if (strlen(tmpstr) > 0) {
				if (strlen(mh->AttachFile) > 0) freechar(mh->AttachFile);
				mh->AttachFile = tmpstr;
			    }
			}
		    }
		    if (strncmp(tmpmb->Line,"Content-Transfer-Encoding:",26) == 0)
		        mh->MimeEncode = GetContentEncode(tmpmb->Line + 27);
		    if (strncmp(tmpmb->Line,"Content-Description:",20) == 0) {
			if (strlen(mh->MimeDescription) > 0) freechar(mh->MimeDescription);
		        mh->MimeDescription = GetHeadData(tmpmb->Line);
		    }
		    tmpmb = tmpmb->Next;
		}
		if ((mh->MimeType == MIME_TYPE_APPLICATION_OCTETSTREAM) &&
		    (strlen(mh->AttachFile) == 0)) {
		    mh->AttachFile = dupchar(mh->MimeDescription);
		}

		/* create hyperlink*/
		if (strlen(mh->AttachFile) > 0) {
		    tmpstr = newchar(10240);
		    sscanf(Filename,"%s/%d.html",tmpstr,&FileNr);
		    freechar(tmpstr);
		    switch (mh->MimeType) {
			case MIME_TYPE_IMAGE_GIF:
			    tmpfile = newchar(24 + strlen(mh->AttachFile));
			    sprintf(tmpfile,"<IMG SRC=\"%d_%s\">\n",FileNr,
				mh->AttachFile);
			    break;
			default:
			    tmpfile = newchar(28 + strlen(mh->AttachFile)*2);
			    sprintf(tmpfile,"<A HREF=\"%d_%s\">%s</A>\n",FileNr,
				mh->AttachFile,mh->AttachFile);
			    break;
		    }
		    AppendFile(Filename,tmpfile);
		    freechar(tmpfile);
		}
	    } /* End of boundery detection */
	    if (tmpmb != NULL) {
	        if (strlen(mh->AttachFile) > 0) {
		    /* There is a filename */
		    tmpstr = newchar(10240);
		    sscanf(Filename,"%s/%d.html",tmpstr,&FileNr);
		    freechar(tmpstr);
		    tmpfile = newchar(13 + strlen(config.Directory) +
			strlen(mh->AttachFile));
		    sprintf(tmpfile,"%s/%d_%s",config.Directory,FileNr,
			mh->AttachFile);
		    switch (mh->MimeEncode) {
			case MIME_ENCODE_QUOTED:
			    tmpstr = Quoted_2_Text(tmpmb->Line);
			    AppendFile(tmpfile,tmpstr);
			    freechar(tmpstr);
			    break;
			case MIME_ENCODE_UUENCODE:
			case MIME_ENCODE_BASE64:
			    NewFile(tmpfile,"");
			    fd = open(tmpfile,O_WRONLY);
			    if (fd == -1) {
				fprintf(stderr,"Warning: Couldn't open file %s for writing.\n",tmpfile);
				break;
			    }
			    for(;;) {
				tmplen = 0;
				if(strlen(tmpmb->Line) > 0) {
				    /* Cut newlines at the end */
				    if (tmpmb->Line[strlen(tmpmb->Line)-1] == '\n')
					tmpmb->Line[strlen(tmpmb->Line)-1] = '\0';
				}
				if ((mh->MimeEncode != MIME_ENCODE_UUENCODE) ||
				   (strncmp(tmpmb->Line,"begin ",6) != 0)) {
				   tmpstr = ByteConvert4to3(tmpmb->Line,&tmplen,mh->MimeEncode);
				   if (tmplen > 0) write(fd,tmpstr,tmplen);
				   freechar(tmpstr);
				}
				if (tmpmb->Next == NULL) {
				    break;
				} else {
				    if (strstr(tmpmb->Next->Line,mh->MimeBoundary) != NULL) {
					break;
				    } else {
					tmpmb = tmpmb->Next;
				    }
				}
			    }
			    close(fd);
			    break;
			default:
			    AppendFile(tmpfile,tmpmb->Line);
			    break;
		    }
		    freechar(tmpfile);
	        } else {
		    /* Normal output */
		    switch (mh->MimeEncode) {
			case MIME_ENCODE_QUOTED:
			    tmpstr = Quoted_2_Text(tmpmb->Line);
			    break;
			case MIME_ENCODE_UUENCODE:
			case MIME_ENCODE_BASE64:
			    tmpstr = ByteConvert4to3(tmpmb->Line,&tmplen,mh->MimeEncode);
			    break;
			default:
			    tmpstr = dupchar(tmpmb->Line);
			    break;
		    }
		    switch (mh->MimeType) {
			default:
			    WriteMailBody(Filename,tmpstr,mh);
			    break;
		    }
		    freechar(tmpstr);
		}
		tmpmb = tmpmb->Next;
	    }
	}
    } else {
	/* Remove leading empty lines */
	while ((tmpmb != NULL) && (tmpmb->Line != NULL) && (tmpmb->Line[0] == '\n')) {
	    tmpmb = tmpmb->Next;
	}
	while ((tmpmb != NULL) && (tmpmb->Line != NULL)) {
	    if (IfUuencode(tmpmb->Line) == TRUE) {
		/* There is a filename */
		tmpstr = newchar(10240);
		sscanf(Filename,"%s/%d.html",tmpstr,&FileNr);
		freechar(tmpstr);
		tmpstr = GetUuencodeFile(tmpmb->Line);
		tmpfile = newchar(13 + strlen(config.Directory) +
		    strlen(tmpstr));
		sprintf(tmpfile,"%s/%d_%s",config.Directory,FileNr,
		    tmpstr);
		tmpmb = tmpmb->Next;
		NewFile(tmpfile,"");
		fd = open(tmpfile,O_WRONLY);
		if (fd == -1) {
		   fprintf(stderr,"Warning: Couldn't open file %s for writing.\n",tmpfile);
		   break;
		}
		freechar(tmpfile);
		tmpfile = newchar(13 + strlen(tmpstr));
		sprintf(tmpfile,"%d_%s",FileNr,tmpstr);
		AppendFile(Filename,"<A HREF=\"");
		AppendFile(Filename,tmpfile);
		AppendFile(Filename,"\">");
		AppendFile(Filename,tmpstr);
		AppendFile(Filename,"</A>\n");
		freechar(tmpfile);
		freechar(tmpstr);
		for(;;) {
		    tmplen = 0;
		    if (tmpmb->Next == NULL) break;
		    if (strncmp(tmpmb->Line,"end",3) == 0) break;
		    tmpstr = ByteConvert4to3(tmpmb->Line,&tmplen,MIME_ENCODE_UUENCODE);
		    if (tmplen > 0) write(fd,tmpstr,tmplen);
		    freechar(tmpstr);
		    tmpmb = tmpmb->Next;
		}
		close(fd);
	    } else {
		switch (mh->MimeEncode) {
		    case MIME_ENCODE_QUOTED:
			tmpstr = Quoted_2_Text(tmpmb->Line);
			break;
		    case MIME_ENCODE_UUENCODE:
		    case MIME_ENCODE_BASE64:
			tmpstr = ByteConvert4to3(tmpmb->Line,&tmplen,mh->MimeEncode);
			break;
		    default:
			tmpstr = dupchar(tmpmb->Line);
			break;
		}
		WriteMailBody(Filename,tmpstr,mh);
		freechar(tmpstr);
	    }
	    tmpmb = tmpmb->Next;
	}
    }
    AppendFile(Filename,"</PRE>\n");
    WriteHtmlValue(Filename,"Body","End");

    if (config.FrameSupport == FALSE) {
	WriteHtmlValue(Filename,"IndexControl2","Start");
	if (HtmlCmd.HrStart == NULL)
	    AppendFile(Filename,HTMLCMD_HR_START);
	else
	    AppendFile(Filename,HtmlCmd.HrStart);
	AppendFile(Filename,"\n");
	WriteNavIndex(Filename);
	WriteHtmlValue(Filename,"IndexControl2","End");
    }

    if (config.DocEndFile != NULL) {
	IncludeFile(Filename, config.DocEndFile);
    } else {
	if (HtmlCmd.BodyEnd == NULL)
	    AppendFile(Filename,HTMLCMD_BODY_END);
	else
	    AppendFile(Filename,HtmlCmd.BodyEnd);
	AppendFile(Filename,"\n");
    }
    EndHtml(Filename);
}


void CleanMailMem(struct MAILHEAD *mh, struct MAILBODY *mb) {
    struct MAILBODY *tmpmb, *tmpmbnext;

    if (config.DebugLevel & 1)
        printf(".CleanMailMem\n");
    if (mh->SendName[0] != 0) freechar(mh->SendName);
    if (mh->SendAddress[0] != 0) freechar(mh->SendAddress);
    if (mh->ReceiveName[0] != 0) freechar(mh->ReceiveName);
    if (mh->ReceiveAddress[0] != 0) freechar(mh->ReceiveAddress);
    if (mh->SentDate[0] != 0) freechar(mh->SentDate);
    if (mh->MsgId[0] != 0) freechar(mh->MsgId);
    if (mh->Reference[0] != 0) freechar(mh->Reference);
    if (mh->Subject[0] != 0) freechar(mh->Subject);
    if (mh->Xface[0] != 0) freechar(mh->Xface);
    if (mh->HomePage[0] != 0) freechar(mh->HomePage);
    if (mh->FileName[0] != 0) freechar(mh->FileName);
    if (mh->MimeBoundary[0] != 0) freechar(mh->MimeBoundary);
    if (mh->MimeDescription[0] != 0) freechar(mh->MimeDescription);
    if (mh->AttachFile[0] != 0) freechar(mh->AttachFile);

    if (mb != NULL) {
	if (mb->Line != NULL) freechar(mb->Line);
	tmpmb = mb->Next;
	while (tmpmb != NULL) {
	    if (tmpmb->Line != NULL) freechar(tmpmb->Line);
	    tmpmbnext = tmpmb->Next;
	    free (tmpmb);
	    tmpmb = tmpmbnext;
	}
    }
}

#ifdef FACES
void WriteXFace(struct MAILHEAD *mh) {
    char buffer[4096], line[255];
    char *FileName;
    int byte1, byte2, BitmapCount, BufferCount;

    if (config.DebugLevel & 1)
        printf(".WriteXFace (%s)\n",mh->SendAddress);
    /* Calculate full filename */
    if (config.FaceDirectory == NULL) {
	FileName = newchar(strlen(config.Directory)+strlen(mh->SendAddress)+6);
	sprintf(FileName,"%s/%s.xbm",config.Directory,mh->SendAddress);
    } else {
	FileName = newchar(strlen(config.Directory)+strlen(config.FaceDirectory)+
	    strlen(mh->SendAddress)+6);
	sprintf(FileName,"%s/%s/%s.xbm",config.Directory,config.FaceDirectory,
	    mh->SendAddress);
    }

    /* Getting bitmap */
    strcpy(buffer, mh->Xface);
    switch (uncompface(buffer)) {
	case -2 :
	    fprintf(stderr,"internal compface error (%s)\n",mh->FileName);
	    return;
	    break;
	case -1 :
	    fprintf(stderr,"bad face data (%s)\n",mh->FileName);
	    return;
	    break;
	case 1 :
	    fprintf(stderr,"ignoring trailing garbage (%s)\n",mh->FileName);
	    return;
	    break;
    }

    /* Writing XBM-Header */
    sprintf(line,"#define %s_width %d\n",mh->SendAddress,WIDTH);
    NewFile(FileName,line);
    sprintf(line,"#define %s_height %d\n",mh->SendAddress,HEIGHT);
    AppendFile(FileName,line);
    sprintf(line,"static char %s_bits[] = {\n",mh->SendAddress);
    AppendFile(FileName,line);

    /* Writing data */
    BitmapCount = BufferCount = 0;
    while (buffer[BufferCount]) {
	if (sscanf (buffer + BufferCount, " 0x%2x%2x , ", &byte1, &byte2) != 2)
	    break;
	if (BitmapCount > 11) {
	    AppendFile(FileName,",\n");
	    BitmapCount = 0;
	}
        if (BitmapCount == 0) AppendFile(FileName,"   ");
        if (BitmapCount > 0) AppendFile(FileName,", ");
	while (buffer[BufferCount++] != ',');
	if (byte1 > 255 || byte2 > 255) return;
	sprintf(line,"0x%.2x, 0x%.2x",FaceConvertTable[byte1],FaceConvertTable[byte2]);
	AppendFile(FileName,line);
	BitmapCount = BitmapCount + 2;
    }

    /* Writing XBM-Foot */
    AppendFile(FileName,"};\n");
    freechar(FileName);
}
#endif


void Mail2Html(char *mbox) {
    FILE *fd;
    int FileNumber;
    struct MAILHEAD mh;
    struct MAILBODY mb;
    char *FileName;
        
    if (config.DebugLevel & 1)
        printf(".Mail2Html(%s)\n",mbox);
    if (config.WriteMode == HTML_INDEX) {
        if (config.DebugLevel & 2)
            printf("..IndexOnly -> abort\n");
        return;
    }
    if (strcmp(mbox,"-") != 0) {
        if (!FileExist(mbox)) {
            fprintf(stderr,"* file %s doesn't exist. *\n",mbox);
            return;
        }
        fd = fopen(mbox,"r");
	if (fd == NULL) {
            fprintf(stderr,"* unable to open file %s. *\n",mbox);
            return;
	}
    } else {
        fd = stdin;
    }
    if ((config.WriteMode == HTML_APPEND) ||
	(config.WriteMode == HTML_APPENDNOINDEX)) {
        FileNumber=0;
    } else {
	/* delete all files in the html-directory */
	CleanDirectory(config.Directory);
        FileNumber=-1;
    }
#ifdef DEBUG
    if (config.DebugLevel & 2)
	printf("..xAllStr=%d RelStr=%d Stats=%d\n",Debug.StrAlloc,Debug.StrDeAlloc,
	    Debug.StrAlloc-Debug.StrDeAlloc);
#endif
    while (feof(fd) == 0) {
	GetMail(fd,&mh,&mb);
	if ((config.WriteMode == HTML_APPEND) ||
	    (config.WriteMode == HTML_APPENDNOINDEX)) {
	    FileNumber = GetNextFileNumber(FileNumber);
	} else {
	    FileNumber++;
	}
        FileName = GetFileName(FileNumber);
	WriteMail(FileName,&mh,&mb);
#ifdef FACES
	if ((strlen(mh.Xface) > 0) && (config.FaceSupport == TRUE))
	    WriteXFace(&mh);
#endif
	freechar(FileName);
	CleanMailMem(&mh,&mb);
#ifdef DEBUG
	if (config.DebugLevel & 2)
	    printf("..AllStr=%d RelStr=%d Stats=%d\n",Debug.StrAlloc,
		Debug.StrDeAlloc,Debug.StrAlloc-Debug.StrDeAlloc);
#endif
    }
    if (strcmp(mbox,"-") != 0)
	fclose(fd);
}
