##############################################################################
#
# Copyright (c) 1996-1998, Digital Creations, Fredericksburg, VA, USA.
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
#   o Redistributions of source code must retain the above copyright
#     notice, this list of conditions, and the disclaimer that follows.
# 
#   o Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions, and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
#   o Neither the name of Digital Creations nor the names of its
#     contributors may be used to endorse or promote products derived
#     from this software without specific prior written permission.
# 
# 
# THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS AND CONTRIBUTORS *AS IS*
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
# TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL
# CREATIONS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# 
# If you have questions regarding this software, contact:
#
#   Digital Creations, L.C.
#   910 Princess Ann Street
#   Fredericksburge, Virginia  22401
#
#   info@digicool.com
#
#   (540) 371-6909
#
##############################################################################
__doc__='''Version 2 to version 3 file conversion routines.

$Id: SimpleDB23.py,v 1.5 1998/10/23 21:43:02 jim Exp $'''
__version__='$Revision: 1.5 $'[11:-2]

from SimpleDB import *  # I'm a lazy bum.

def convert23(file,file_name):
        import os
        dest_name=file_name+'.v3'
        dest=open(dest_name,'wb')
        convert23_(file,dest)
        file.close()
        dest.close()
        os.rename(file_name, file_name+'.v2')
        os.rename(dest_name, file_name)

def convert23_(src,dest, debug=None):
    """\
    Copy a MultipleRevision Rev 2.0 simple database

    Also getting rid of unwanted records.

    This is harder than it at first appears due to the simple format
    of the file.  I can't know till fairly late in the game whether a
    record should appear in the output.  I actually have to build up a
    list of records to be kept and then sort these before wring the
    file. :-(.
    """ #'

    kept_records=[]
    index={}
    dpos=pos=len(MultipleRevision.packed_version2)
    hs2=len(pack("iidi",0,0,0.0,0))
    sseek=src.seek
    dseek=dest.seek
    read=src.read
    write=dest.write

    while 1:
        sseek(pos)
        h=read(hs2)
        if len(h) != hs2: break
        oid,prev,start,plen=unpack("iidi",h)

        if debug: debug("r %d: %d %16.16g %d\n" %
                        (src.tell(),oid,start,plen))

        newpos=pos+hs2+plen

        if oid:
            if prev: kept_records.append(index[oid])
            index[oid]=start,pos
        pos=newpos

    kept_records=kept_records+index.values()
    index={}
    kept_records.sort()

    dseek(0)
    write(MultipleRevision.packed_version)
    for start,pos in kept_records:
        sseek(pos)
        h=read(hs2)
        oid,prev,start,plen=unpack("iidi",h)
        tlen=28+plen
        p=read(plen)
        if plen==0:
            plen=-1
        try: prev=index[oid]
        except: prev=0
        h=pack(">iidii",oid,prev,start,tlen,plen)
        dseek(dpos)
        write(h)
        write(p)
        write(h[16:20])
        dpos=dpos+tlen
    dest.flush()
