/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.application.TextParagraph;
import netscape.application.TextPositionInfo;
import netscape.application.TextView;
import netscape.application.Timer;
import netscape.util.Vector;

class TextSelection
implements Target {
    TextView _owner;
    private TextParagraph _editParagraph;
    TextPositionInfo _insertionPointInfo;
    TextPositionInfo _anchorPositionInfo;
    TextPositionInfo _endPositionInfo;
    Timer _blinkTimer;
    long _lastFlashTime;
    int _anchorPosition;
    int _endPosition;
    boolean _flashInsertionPoint;
    boolean _insertionPointShowing;
    boolean _ignoreNextFlash;
    boolean _selectionDefined = false;
    int _insertionPointDisabled;

    TextSelection() {
    }

    TextSelection(TextView textView) {
        this();
        this.init(textView);
        this._selectionDefined = false;
    }

    void init(TextView owner) {
        this._owner = owner;
    }

    void _startFlashing() {
        if (this._insertionPointDisabled != 0) {
            return;
        }
        if (!this._owner.isEditable()) {
            return;
        }
        if (!this._selectionDefined) {
            return;
        }
        if (this._blinkTimer == null) {
            this._blinkTimer = new Timer(this, "blinkCaret", 700);
        }
        if (this._owner.isEditing()) {
            this._blinkTimer.start();
        } else if (System.currentTimeMillis() - this._lastFlashTime > 350L) {
            this._ignoreNextFlash = true;
        }
        this.showInsertionPoint();
    }

    void _stopFlashing() {
        this.hideInsertionPoint();
        if (this._blinkTimer != null) {
            this._blinkTimer.stop();
            this._ignoreNextFlash = false;
        }
    }

    public void performCommand(String command, Object data) {
        if (this._owner.isEditing() && this._selectionDefined) {
            if (this._ignoreNextFlash || !this._flashInsertionPoint || this.isARange()) {
                this._ignoreNextFlash = false;
                return;
            }
            this._lastFlashTime = this._blinkTimer.timeStamp();
            this._insertionPointShowing = !this._insertionPointShowing;
            this._owner.drawInsertionPoint();
            return;
        }
        if (this._blinkTimer != null) {
            this._blinkTimer.stop();
        }
    }

    boolean isARange() {
        return this._insertionPointInfo == null && this._anchorPositionInfo != null;
    }

    void disableInsertionPoint() {
        if (this._insertionPointDisabled == 0) {
            this.hideInsertionPoint();
        }
        ++this._insertionPointDisabled;
    }

    void enableInsertionPoint() {
        --this._insertionPointDisabled;
        if (this._insertionPointDisabled == 0) {
            this.showInsertionPoint();
        }
    }

    void showInsertionPoint() {
        if (this._insertionPointDisabled != 0) {
            return;
        }
        if (!this._owner.isEditable()) {
            return;
        }
        if (!this._owner.isEditing()) {
            return;
        }
        this._flashInsertionPoint = true;
        if (this.isARange() || this._insertionPointShowing) {
            return;
        }
        this._insertionPointShowing = true;
        this._owner.drawInsertionPoint();
        this._startFlashing();
    }

    void hideInsertionPoint() {
        this._flashInsertionPoint = false;
        if (this.isARange() || !this._insertionPointShowing) {
            return;
        }
        this._insertionPointShowing = false;
        this._owner.drawInsertionPoint();
    }

    Rect insertionPointRect() {
        if (this._insertionPointInfo == null) {
            return TextView.newRect();
        }
        return TextView.newRect(this._insertionPointInfo._x - 1, this._insertionPointInfo._y, 1, this._insertionPointInfo._lineHeight);
    }

    Rect _updateRectForInfo(int oldPoint, int newPoint, TextPositionInfo oldInfo, TextPositionInfo newInfo) {
        Rect updateRect;
        if (oldPoint == newPoint) {
            return null;
        }
        if (oldInfo._y == newInfo._y) {
            updateRect = newInfo._x < oldInfo._x ? TextView.newRect(newInfo._x, newInfo._y, oldInfo._x - newInfo._x, newInfo._lineHeight) : TextView.newRect(oldInfo._x, newInfo._y, newInfo._x - oldInfo._x, newInfo._lineHeight);
        } else {
            updateRect = oldInfo.lineBounds();
            Rect tmpRect = newInfo.lineBounds();
            updateRect.unionWith(tmpRect);
            TextView.returnRect(tmpRect);
        }
        return updateRect;
    }

    void setRange(int selectionBegin, int selectionEnd, TextPositionInfo selectionEndInfo, boolean selectLineBreak, boolean fromBottom) {
        TextPositionInfo newEndInfo;
        TextPositionInfo newStartInfo;
        int newStart;
        TextPositionInfo oldEndInfo;
        TextPositionInfo oldStartInfo;
        int oldStart;
        this._selectionDefined = selectionBegin != -1 && selectionEnd != -1;
        if (this._anchorPosition != this._endPosition) {
            oldStart = this._anchorPosition < this._endPosition ? this._anchorPosition : this._endPosition;
            oldStartInfo = this._anchorPosition < this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
            int oldEnd = this._anchorPosition > this._endPosition ? this._anchorPosition : this._endPosition;
            oldEndInfo = this._anchorPosition > this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
        } else {
            int oldEnd = -1;
            oldStart = -1;
            oldEndInfo = null;
            oldStartInfo = null;
        }
        if (selectionBegin < 0) {
            selectionBegin = 0;
        } else if (selectionBegin >= this._owner._charCount) {
            selectionBegin = this._owner._charCount - 1;
        }
        if (selectionEnd < 0) {
            selectionEnd = 0;
        } else if (selectionEnd >= this._owner._charCount) {
            selectionEnd = this._owner._charCount - 1;
        }
        this._anchorPosition = selectionBegin;
        this._endPosition = selectionEnd;
        if (this._anchorPosition == this._endPosition) {
            TextParagraph nextParagraph;
            this._editParagraph = this._owner._paragraphForIndex(this._anchorPosition);
            this._insertionPointInfo = this._editParagraph.infoForPosition(this._anchorPosition, -1);
            if (fromBottom && this._insertionPointInfo._endOfLine && this._anchorPosition < this._owner.length() - 1 && (nextParagraph = this._owner._paragraphForIndex(this._anchorPosition + 1)) == this._editParagraph) {
                TextPositionInfo nextPositionInfo = this._editParagraph.infoForPosition(this._anchorPosition + 1, -1);
                if (nextPositionInfo._y > this._insertionPointInfo._y) {
                    this._insertionPointInfo = this._editParagraph.infoForPosition(this._anchorPosition, nextPositionInfo._y);
                }
            }
            this._endPositionInfo = null;
            this._anchorPositionInfo = null;
        } else {
            TextParagraph p = this._owner._paragraphForIndex(this._anchorPosition);
            this._anchorPositionInfo = p.infoForPosition(this._anchorPosition, -1);
            if (this._anchorPositionInfo._endOfLine && !selectLineBreak) {
                this._anchorPositionInfo = p.infoForPosition(this._anchorPosition, this._anchorPositionInfo.maxY());
            }
            this._endPositionInfo = selectionEndInfo == null ? this._owner._paragraphForIndex(this._endPosition).infoForPosition(this._endPosition, -1) : selectionEndInfo;
            this._insertionPointInfo = null;
            this._editParagraph = null;
        }
        if (this._anchorPosition != this._endPosition) {
            newStart = this._anchorPosition < this._endPosition ? this._anchorPosition : this._endPosition;
            newStartInfo = this._anchorPosition < this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
            int newEnd = this._anchorPosition > this._endPosition ? this._anchorPosition : this._endPosition;
            newEndInfo = this._anchorPosition > this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
        } else {
            int newEnd = -1;
            newStart = -1;
            newEndInfo = null;
            newStartInfo = null;
        }
        if (oldStart == -1) {
            if (newStart == -1) {
                this._startFlashing();
                this._updateCurrentFont();
                return;
            }
            this.dirtyRangeForSelection(this._anchorPositionInfo, this._endPositionInfo, null, null);
            this._updateCurrentFont();
            return;
        }
        if (newStart == -1) {
            this.dirtyRangeForSelection(oldStartInfo, oldEndInfo, null, null);
            this._startFlashing();
            this._updateCurrentFont();
            return;
        }
        this.dirtyRangeForSelection(newStartInfo, newEndInfo, oldStartInfo, oldEndInfo);
        this._updateCurrentFont();
    }

    void dirtyRangeForSelection(TextPositionInfo start, TextPositionInfo end, TextPositionInfo previousStart, TextPositionInfo previousEnd) {
        TextPositionInfo previousLineInfo;
        Range dirtyRange;
        Rect result = null;
        Rect bounds = this._owner.bounds();
        Range nsr = Range.rangeFromIndices(start._absPosition, end._absPosition);
        if (previousStart == null || previousEnd == null) {
            dirtyRange = nsr;
        } else {
            Range isr = Range.rangeFromIndices(previousStart._absPosition, previousEnd._absPosition);
            if (isr.equals(nsr)) {
                return;
            }
            if (nsr.index == isr.index) {
                dirtyRange = nsr.length > isr.length ? new Range(nsr.index + isr.length, nsr.length - isr.length) : new Range(nsr.index + nsr.length, isr.length - nsr.length);
            } else if (nsr.index + nsr.length == isr.index + isr.length) {
                dirtyRange = nsr.length > isr.length ? new Range(nsr.index, nsr.length - isr.length) : new Range(isr.index, isr.length - nsr.length);
            } else {
                this.dirtyRangeForSelection(start, end, null, null);
                this.dirtyRangeForSelection(previousStart, previousEnd, null, null);
                return;
            }
        }
        Vector dirtyRects = this._owner.rectsForRange(dirtyRange);
        int i = 0;
        int c = dirtyRects.count();
        while (i < c) {
            Rect rect = (Rect)dirtyRects.elementAt(i);
            rect.x = 0;
            rect.width = bounds.width;
            if (rect.height > 0) {
                if (result == null) {
                    result = new Rect(rect);
                } else {
                    result.unionWith(rect);
                }
            }
            ++i;
        }
        if (result == null) {
            return;
        }
        if (dirtyRange.contains(start._absPosition) && !result.contains(start._x, start._y) && start._absPosition > 0 && (previousLineInfo = this._owner.positionInfoForIndex(start._absPosition - 1)) != null) {
            result.y -= previousLineInfo._lineHeight;
            result.height += previousLineInfo._lineHeight;
        }
        if (dirtyRange.contains(end._absPosition) && !result.contains(end._x, end._y) && end._absPosition > 0 && (previousLineInfo = this._owner.positionInfoForIndex(end._absPosition - 1)) != null) {
            result.y -= previousLineInfo._lineHeight;
            result.height += previousLineInfo._lineHeight;
        }
        if (previousStart != null && dirtyRange.contains(previousStart._absPosition) && !result.contains(previousStart._x, previousStart._y) && previousStart._absPosition > 0 && (previousLineInfo = this._owner.positionInfoForIndex(previousStart._absPosition - 1)) != null) {
            result.y -= previousLineInfo._lineHeight;
            result.height += previousLineInfo._lineHeight;
        }
        if (previousEnd != null && dirtyRange.contains(previousEnd._absPosition) && !result.contains(previousEnd._x, previousEnd._y) && previousEnd._absPosition > 0 && (previousLineInfo = this._owner.positionInfoForIndex(previousEnd._absPosition - 1)) != null) {
            result.y -= previousLineInfo._lineHeight;
            result.height += previousLineInfo._lineHeight;
        }
        this._owner.addDirtyRect(result);
    }

    void setRange(int selectionBegin, int selectionEnd, TextPositionInfo selectionEndInfo, boolean selectLineBreak) {
        this.setRange(selectionBegin, selectionEnd, selectionEndInfo, selectLineBreak, false);
    }

    void setRange(int selectionBegin, int selectionEnd) {
        this.setRange(selectionBegin, selectionEnd, null, false, false);
    }

    void setRange(int selectionBegin, int selectionEnd, boolean fromBottom) {
        this.setRange(selectionBegin, selectionEnd, null, false, fromBottom);
    }

    void clearRange() {
        this.hideInsertionPoint();
        this.setRange(-1, -1);
        this._stopFlashing();
    }

    void setInsertionPoint(TextPositionInfo positionInfo) {
        Rect updateRect = null;
        if (positionInfo == null) {
            return;
        }
        this._selectionDefined = true;
        if (this._anchorPosition != this._endPosition) {
            updateRect = this._anchorPositionInfo.lineBounds();
            Rect endRect = this._endPositionInfo.lineBounds();
            updateRect.unionWith(endRect);
            updateRect.x = 0;
            updateRect.width = this._owner.bounds.width;
            TextView.returnRect(endRect);
        }
        this._anchorPosition = this._endPosition = positionInfo._absPosition;
        this._insertionPointInfo = positionInfo;
        this._editParagraph = this._insertionPointInfo._textRun._paragraph;
        this._endPositionInfo = null;
        this._anchorPositionInfo = null;
        if (updateRect != null) {
            this._owner.draw(updateRect);
            TextView.returnRect(updateRect);
        }
        if (this._insertionPointShowing) {
            this._startFlashing();
        }
    }

    int insertionPoint() {
        if (this.isARange()) {
            return -1;
        }
        return this._anchorPosition;
    }

    TextPositionInfo insertionPointInfo() {
        if (this.isARange()) {
            return null;
        }
        return this._insertionPointInfo;
    }

    int selectionStart() {
        if (!this._selectionDefined) {
            return -1;
        }
        if (this._anchorPosition <= this._endPosition) {
            return this._anchorPosition;
        }
        return this._endPosition;
    }

    TextPositionInfo selectionStartInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        if (this._anchorPosition <= this._endPosition) {
            return this._anchorPositionInfo;
        }
        return this._endPositionInfo;
    }

    int selectionEnd() {
        if (!this._selectionDefined) {
            return -1;
        }
        if (this._endPosition > this._anchorPosition) {
            return this._endPosition;
        }
        return this._anchorPosition;
    }

    TextPositionInfo selectionEndInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        if (this._endPosition > this._anchorPosition) {
            return this._endPositionInfo;
        }
        return this._anchorPositionInfo;
    }

    void _updateCurrentFont() {
    }

    int orderedSelectionStart() {
        if (!this._selectionDefined) {
            return -1;
        }
        return this._anchorPosition;
    }

    TextPositionInfo orderedSelectionStartInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        return this._anchorPositionInfo;
    }

    int orderedSelectionEnd() {
        if (!this._selectionDefined) {
            return -1;
        }
        return this._endPosition;
    }

    TextPositionInfo orderedSelectionEndInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        return this._endPositionInfo;
    }
}

