/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.util.StringTokenizer;
import netscape.application.FastStringBuffer;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class TextParagraphFormat
implements Cloneable,
Codable {
    int _leftIndent;
    int _leftMargin;
    int _rightMargin;
    int _lineSpacing;
    int[] _tabStops;
    int _justification;
    boolean _wrapsUnderFirstCharacter;
    static final String LEFTINDENT_KEY = "leftIndent";
    static final String LEFTMARGIN_KEY = "leftMargin";
    static final String RIGHTINDENT_KEY = "rightMargin";
    static final String LINESPACING_KEY = "lineSpacing";
    static final String TABSTOPS_KEY = "tabStops";
    static final String JUSTIFICATION_KEY = "justification";
    static final String WRAPS_UNDER_FIRST_CHARACTER_KEY = "wrapsUnderFirstCharacter";

    public Object clone() {
        try {
            Object clone = super.clone();
            TextParagraphFormat cloneFormat = (TextParagraphFormat)clone;
            if (this._tabStops != null) {
                cloneFormat.clearAllTabPositions();
                cloneFormat.setTabPositions(this._tabStops);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InconsistencyException(String.valueOf(this) + ": clone() not supported :" + e);
        }
    }

    public void setLeftMargin(int leftMargin) {
        this._leftMargin = leftMargin;
    }

    public int leftMargin() {
        return this._leftMargin;
    }

    public void setLeftIndent(int indent) {
        this._leftIndent = indent;
    }

    public int leftIndent() {
        return this._leftIndent;
    }

    public void setRightMargin(int rightMargin) {
        this._rightMargin = rightMargin;
    }

    public int rightMargin() {
        return this._rightMargin;
    }

    public void setLineSpacing(int spacing) {
        this._lineSpacing = spacing;
    }

    public int lineSpacing() {
        return this._lineSpacing;
    }

    public void setJustification(int justification) {
        if (this._justification < 0 || this._justification > 3) {
            return;
        }
        this._justification = justification;
    }

    public int justification() {
        return this._justification;
    }

    public void setWrapsUnderFirstCharacter(boolean flag) {
        this._wrapsUnderFirstCharacter = flag;
    }

    public boolean wrapsUnderFirstCharacter() {
        if (this._justification == 0) {
            return this._wrapsUnderFirstCharacter;
        }
        return false;
    }

    public void clearAllTabPositions() {
        this._tabStops = null;
    }

    public void addTabPosition(int position) {
        if (position < 0) {
            return;
        }
        if (this._tabStops == null) {
            this._growTabArrayTo(20);
            this._tabStops[0] = position;
            return;
        }
        int count = this._tabStops.length;
        if (this._tabStops[count - 1] != -1) {
            this._growTabArrayTo(this._tabStops.length + 10);
            count = this._tabStops.length;
        }
        int i = 0;
        while (i < count) {
            if (this._tabStops[i] > position) {
                return;
            }
            if (this._tabStops[i] == -1) {
                this._tabStops[i] = position;
                return;
            }
            ++i;
        }
    }

    public void setTabPositions(int[] tabArray) {
        if (tabArray == null) {
            return;
        }
        this.clearAllTabPositions();
        int count = tabArray.length;
        int i = 0;
        while (i < count) {
            this.addTabPosition(tabArray[i]);
            ++i;
        }
    }

    public int[] tabPositions() {
        int tabCount = 0;
        int i = 0;
        int c = this._tabStops.length;
        while (i < c) {
            if (this._tabStops[i] == -1) break;
            ++tabCount;
            ++i;
        }
        int[] result = new int[tabCount];
        System.arraycopy(this._tabStops, 0, result, 0, tabCount);
        return result;
    }

    public int positionForTab(int tabNumber) {
        if (this._tabStops == null || tabNumber < 0 || tabNumber >= this._tabStops.length) {
            return -1;
        }
        return this._tabStops[tabNumber];
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.TextParagraphFormat", 1);
        info.addField(LEFTINDENT_KEY, (byte)8);
        info.addField(LEFTMARGIN_KEY, (byte)8);
        info.addField(RIGHTINDENT_KEY, (byte)8);
        info.addField(LINESPACING_KEY, (byte)8);
        info.addField(TABSTOPS_KEY, (byte)16);
        info.addField(JUSTIFICATION_KEY, (byte)8);
        info.addField(WRAPS_UNDER_FIRST_CHARACTER_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(LEFTINDENT_KEY, this._leftIndent);
        encoder.encodeInt(LEFTMARGIN_KEY, this._leftMargin);
        encoder.encodeInt(RIGHTINDENT_KEY, this._rightMargin);
        encoder.encodeInt(LINESPACING_KEY, this._lineSpacing);
        if (this._tabStops != null) {
            FastStringBuffer buffer = new FastStringBuffer();
            int count = this._tabStops.length;
            int i = 0;
            while (i < count) {
                buffer.append(String.valueOf(this._tabStops[i]) + ".");
                ++i;
            }
            encoder.encodeString(TABSTOPS_KEY, buffer.toString());
        } else {
            encoder.encodeString(TABSTOPS_KEY, null);
        }
        encoder.encodeInt(JUSTIFICATION_KEY, this._justification);
        encoder.encodeBoolean(WRAPS_UNDER_FIRST_CHARACTER_KEY, this._wrapsUnderFirstCharacter);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._leftIndent = decoder.decodeInt(LEFTINDENT_KEY);
        this._leftMargin = decoder.decodeInt(LEFTMARGIN_KEY);
        this._rightMargin = decoder.decodeInt(RIGHTINDENT_KEY);
        this._lineSpacing = decoder.decodeInt(LINESPACING_KEY);
        String tabData = decoder.decodeString(TABSTOPS_KEY);
        if (tabData != null) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(tabData, ".", false);
                this.addTabPosition(Integer.parseInt(tokenizer.nextToken()));
            }
            catch (Exception exception) {
                throw new CodingException("Illegal tab stop data: \"" + tabData + "\"");
            }
        }
        this._justification = decoder.decodeInt(JUSTIFICATION_KEY);
        this._wrapsUnderFirstCharacter = decoder.decodeBoolean(WRAPS_UNDER_FIRST_CHARACTER_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    private void _growTabArrayTo(int newSize) {
        if (newSize < 1) {
            return;
        }
        if (this._tabStops != null && this._tabStops.length >= newSize) {
            return;
        }
        int[] oldArray = this._tabStops;
        int i = newSize + 5;
        this._tabStops = new int[i];
        while (i-- > 0) {
            this._tabStops[i] = -1;
        }
        if (oldArray == null) {
            return;
        }
        int count = oldArray.length;
        i = 0;
        while (i < count) {
            this._tabStops[i] = oldArray[i];
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("leftIndent = " + this._leftIndent + " " + "leftMargin = " + this._leftMargin + " " + "rightMargin = " + this._rightMargin + " " + "lineSpacing = " + this._lineSpacing + " " + "justification = " + this._justification);
        return sb.toString();
    }
}

