/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.ListItem;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ListView
extends View
implements Target,
FormElement {
    ListItem protoItem;
    ListItem anchorItem;
    ListItem origSelectedItem;
    Vector items = new Vector();
    Vector selectedItems = new Vector();
    Vector dirtyItems = new Vector();
    String command;
    String doubleCommand;
    Target target;
    Color backgroundColor = Color.lightGray;
    int rowHeight = 17;
    boolean allowsMultipleSelection;
    boolean allowsEmptySelection;
    boolean tracksMouseOutsideBounds = true;
    boolean tracking;
    boolean enabled = true;
    boolean transparent = false;
    static final String PROTOITEM_KEY = "protoItem";
    static final String ANCHORITEM_KEY = "anchorItem";
    static final String ORIGSELECTED_KEY = "origSelectedItem";
    static final String ITEMS_KEY = "items";
    static final String SELECTEDITEMS_KEY = "selectedItems";
    static final String DIRTYITEMS_KEY = "dirtyItems";
    static final String COMMAND_KEY = "command";
    static final String DOUBLECOMMAND_KEY = "doubleCommand";
    static final String TARGET_KEY = "target";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String ROWHEIGHT_KEY = "rowHeight";
    static final String MULTSELECTION_KEY = "allowsMultipleSelection";
    static final String EMPTYSELECTION_KEY = "allowsEmptySelection";
    static final String TRACKSMOUSE_KEY = "tracksMouseOutsideBounds";
    static final String ENABLED_KEY = "enabled";
    static final String TRANSPARENT_KEY = "isTransparent";
    public static String SELECT_NEXT_ITEM = "selectNext";
    public static String SELECT_PREVIOUS_ITEM = "selectPrevious";

    public ListView() {
        this(0, 0, 0, 0);
    }

    public ListView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ListView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this._setupKeyboard();
    }

    public void setPrototypeItem(ListItem item) {
        this.protoItem = item == null ? new ListItem() : item;
        if (this.protoItem.font() == null) {
            this.protoItem.setFont(Font.fontNamed("Default"));
        }
        this.protoItem.setListView(this);
    }

    public ListItem prototypeItem() {
        if (this.protoItem == null) {
            this.setPrototypeItem(null);
        }
        return this.protoItem;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean wantsAutoscrollEvents() {
        return true;
    }

    public void setAllowsMultipleSelection(boolean flag) {
        this.allowsMultipleSelection = flag;
    }

    public boolean allowsMultipleSelection() {
        return this.allowsMultipleSelection;
    }

    public void setAllowsEmptySelection(boolean flag) {
        this.allowsEmptySelection = flag;
    }

    public boolean allowsEmptySelection() {
        return this.allowsEmptySelection;
    }

    public void setTracksMouseOutsideBounds(boolean flag) {
        this.tracksMouseOutsideBounds = flag;
    }

    public boolean tracksMouseOutsideBounds() {
        return this.tracksMouseOutsideBounds;
    }

    public void setEnabled(boolean flag) {
        if (this.enabled != flag) {
            this.enabled = flag;
            this.setDirty(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setRowHeight(int height) {
        if (height > 0) {
            this.rowHeight = height;
            return;
        }
        this.rowHeight = this.minItemHeight();
    }

    public int rowHeight() {
        if (this.rowHeight > 0) {
            return this.rowHeight;
        }
        this.setRowHeight(this.minItemHeight());
        return this.rowHeight;
    }

    public int minItemHeight() {
        int minHeight = 0;
        int count = this.items.size();
        int i = 0;
        while (i < count) {
            ListItem item = (ListItem)this.items.elementAt(i);
            int height = item.minHeight();
            if (height > minHeight) {
                minHeight = height;
            }
            ++i;
        }
        return minHeight;
    }

    public int minItemWidth() {
        int minWidth = 0;
        int count = this.items.size();
        int i = 0;
        while (i < count) {
            ListItem item = (ListItem)this.items.elementAt(i);
            int width = item.minWidth();
            if (width > minWidth) {
                minWidth = width;
            }
            ++i;
        }
        return minWidth;
    }

    public Size minSize() {
        return new Size(this.bounds.width, this.count() * this.rowHeight());
    }

    public ListItem itemForPoint(int x, int y) {
        int count = this.items.size();
        if (this.rowHeight == 0) {
            return null;
        }
        if (count == 0) {
            return null;
        }
        if (!this.tracksMouseOutsideBounds && !Rect.contains(0, 0, this.width(), this.height(), x, y)) {
            return null;
        }
        int index = y / this.rowHeight;
        if (index < 0) {
            index = 0;
        } else if (index >= count) {
            index = count - 1;
        }
        return this.itemAt(index);
    }

    public ListItem itemAt(int index) {
        return (ListItem)this.items.elementAt(index);
    }

    public int indexOfItem(ListItem item) {
        return this.items.indexOf(item);
    }

    public Rect rectForItem(ListItem item) {
        if (item == null) {
            return null;
        }
        return this.rectForItemAt(this.items.indexOf(item));
    }

    public Rect rectForItemAt(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return new Rect(0, this.rowHeight * index, this.bounds.width, this.rowHeight);
    }

    public boolean multipleItemsSelected() {
        return this.selectedItems.size() > 1;
    }

    public int selectedIndex() {
        ListItem item = this.selectedItem();
        if (item == null) {
            return -1;
        }
        return this.items.indexOf(item);
    }

    public ListItem selectedItem() {
        if (this.selectedItems.size() > 0) {
            return (ListItem)this.selectedItems.elementAt(0);
        }
        return null;
    }

    public Vector selectedItems() {
        return this.selectedItems;
    }

    public int count() {
        return this.items.size();
    }

    public ListItem addItem() {
        return this.insertItemAt(this.items.size());
    }

    public ListItem addItem(ListItem item) {
        if (item.font() == null) {
            item.setFont(Font.defaultFont());
        }
        item.setListView(this);
        return this.insertItemAt(item, this.items.size());
    }

    public ListItem insertItemAt(ListItem item, int index) {
        if (item.font() == null) {
            item.setFont(Font.defaultFont());
        }
        item.setListView(this);
        this.items.insertElementAt(item, index);
        if (!this.allowsEmptySelection && this.selectedItems.isEmpty()) {
            this.selectItem(item);
        }
        return item;
    }

    public ListItem insertItemAt(int index) {
        ListItem newItem = (ListItem)this.prototypeItem().clone();
        this.items.insertElementAt(newItem, index);
        if (!this.allowsEmptySelection && this.selectedItems.isEmpty()) {
            this.selectItem(newItem);
        }
        return newItem;
    }

    public void removeItemAt(int index) {
        ListItem item = (ListItem)this.items.elementAt(index);
        this.items.removeElementAt(index);
        this.selectedItems.removeElement(item);
        if (!this.allowsEmptySelection && this.selectedItems.size() == 0 && this.items.size() > 0) {
            if (--index < 0) {
                index = 0;
            }
            this.selectItem(this.itemAt(index));
        }
    }

    public void removeItem(ListItem item) {
        this.removeItemAt(this.items.indexOf(item));
    }

    public void removeAllItems() {
        this.items.removeAllElements();
        this.selectItem(null);
    }

    public void selectItem(ListItem item) {
        if (item != null && !item.isEnabled()) {
            item = null;
        }
        if (item == null) {
            ListItem selectedItem;
            int count = this.selectedItems.size();
            if (count > 0 && !this.allowsEmptySelection) {
                selectedItem = (ListItem)this.selectedItems.elementAt(count - 1);
                this.selectedItems.removeElementAt(count - 1);
                --count;
            } else {
                selectedItem = null;
            }
            int i = 0;
            while (i < count) {
                ListItem nextItem = (ListItem)this.selectedItems.elementAt(i);
                nextItem.setSelected(false);
                this.markDirty(nextItem);
                ++i;
            }
            this.selectedItems.removeAllElements();
            if (selectedItem != null) {
                this.selectedItems.addElement(selectedItem);
            }
        } else if (!this.selectedItems.contains(item)) {
            ListItem selectedItem;
            if (!this.allowsMultipleSelection && (selectedItem = this.selectedItem()) != null) {
                selectedItem.setSelected(false);
                this.selectedItems.removeElement(selectedItem);
                this.markDirty(selectedItem);
            }
            item.setSelected(true);
            this.selectedItems.addElement(item);
            this.markDirty(item);
        }
        this.drawDirtyItems();
    }

    public void selectItemAt(int index) {
        this.selectItem((ListItem)this.items.elementAt(index));
    }

    public void selectOnly(ListItem item) {
        boolean itemAlreadySelected = false;
        if (!item.isEnabled()) {
            return;
        }
        int count = this.selectedItems.size();
        if (count == 1 && item == this.selectedItems.elementAt(0)) {
            return;
        }
        int i = 0;
        while (i < count) {
            ListItem nextItem = (ListItem)this.selectedItems.elementAt(i);
            if (nextItem != item) {
                nextItem.setSelected(false);
                this.markDirty(nextItem);
            } else {
                itemAlreadySelected = true;
            }
            ++i;
        }
        this.selectedItems.removeAllElements();
        this.selectedItems.addElement(item);
        if (!itemAlreadySelected) {
            item.setSelected(true);
            this.markDirty(item);
        }
        this.drawDirtyItems();
    }

    public void deselectItem(ListItem item) {
        if (item == null || this.selectedItems.size() == 1 && !this.allowsEmptySelection) {
            return;
        }
        if (!this.items.contains(item) || !this.selectedItems.contains(item)) {
            return;
        }
        this.selectedItems.removeElement(item);
        item.setSelected(false);
        this.markDirty(item);
        this.drawDirtyItems();
    }

    public void scrollItemAtToVisible(int index) {
        this.scrollRectToVisible(this.rectForItemAt(index));
    }

    public void scrollItemToVisible(ListItem item) {
        this.scrollRectToVisible(this.rectForItem(item));
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.enabled) {
            return false;
        }
        this.tracking = true;
        this.origSelectedItem = this.selectedItem();
        ListItem clickedItem = this.itemForPoint(event.x, event.y);
        if (clickedItem == null) {
            return true;
        }
        if (this.anchorItem != clickedItem && event.clickCount > 1) {
            event.setClickCount(1);
        }
        this.selectOnly(clickedItem);
        this.anchorItem = clickedItem;
        if (event.clickCount == 2) {
            this.sendDoubleCommand();
            return false;
        }
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        if (!this.tracking) {
            return;
        }
        this.disableDrawing();
        ListItem newItem = this.itemForPoint(event.x, event.y);
        if (!this.tracksMouseOutsideBounds && !Rect.contains(0, 0, this.width(), this.height(), event.x, event.y)) {
            newItem = null;
        }
        if (!this.allowsMultipleSelection) {
            if (newItem != this.selectedItem() && (this.allowsEmptySelection || newItem != null)) {
                this.anchorItem = newItem;
                this.selectItem(newItem);
            }
        } else {
            ListItem nextItem;
            int endIndex;
            int startIndex;
            int newIndex;
            int anchorIndex = this.items.indexOf(this.anchorItem);
            if (anchorIndex < (newIndex = newItem != null ? this.items.indexOf(newItem) : (this.pointCompare(0, this.height(), event.y) < 0 ? 0 : this.items.size() - 1))) {
                startIndex = anchorIndex;
                endIndex = newIndex;
            } else {
                startIndex = newIndex;
                endIndex = anchorIndex;
            }
            int i = this.selectedItems.size();
            while (i-- > 0) {
                nextItem = (ListItem)this.selectedItems.elementAt(i);
                int nextIndex = this.items.indexOf(nextItem);
                if (nextItem.isSelected() && (nextIndex < startIndex || nextIndex > endIndex)) {
                    this.deselectItem(nextItem);
                    continue;
                }
                if (nextItem.isSelected() || nextIndex < startIndex || nextIndex > endIndex) continue;
                this.selectItem(nextItem);
            }
            if (startIndex != -1 && endIndex != -1) {
                i = startIndex;
                while (i <= endIndex) {
                    nextItem = (ListItem)this.items.elementAt(i);
                    if (!nextItem.isSelected()) {
                        this.selectItem(nextItem);
                    }
                    ++i;
                }
            }
        }
        this.reenableDrawing();
        this.autoscroll(event);
    }

    public void mouseUp(MouseEvent event) {
        if (event.clickCount == 1) {
            this.sendCommand();
        }
        this.tracking = false;
    }

    private int pointCompare(int y, int height, int pointY) {
        if (pointY < y) {
            return -1;
        }
        if (pointY >= y + height) {
            return 1;
        }
        return 0;
    }

    private int rectCompare(Rect containingRect, Rect otherRect) {
        if (otherRect.maxY() <= containingRect.y) {
            return -1;
        }
        if (otherRect.y >= containingRect.maxY()) {
            return 1;
        }
        return 0;
    }

    private void autoscroll(MouseEvent event) {
        Rect visibleRect = Rect.newRect();
        this.computeVisibleRect(visibleRect);
        this.drawDirtyItems();
        if (!visibleRect.contains(event.x, event.y)) {
            if (event.y < visibleRect.y) {
                Rect tmpRect = Rect.newRect(visibleRect.x, event.y, visibleRect.width, this.rowHeight);
                this.scrollRectToVisible(tmpRect);
                Rect.returnRect(tmpRect);
            } else if (event.y > visibleRect.maxY()) {
                Rect tmpRect = Rect.newRect(visibleRect.x, event.y - this.rowHeight, visibleRect.width, this.rowHeight);
                this.scrollRectToVisible(tmpRect);
                Rect.returnRect(tmpRect);
            }
        }
        Rect.returnRect(visibleRect);
    }

    private void markDirty(ListItem item) {
        if (this.dirtyItems.contains(item)) {
            return;
        }
        this.dirtyItems.addElement(item);
    }

    private void drawDirtyItems() {
        if (!this.canDraw()) {
            return;
        }
        int count = this.dirtyItems.size();
        if (count == 0) {
            return;
        }
        Vector tmpVector = this.dirtyItems;
        this.dirtyItems = null;
        Rect clipRect = Rect.newRect(0, 0, this.bounds.width, this.rowHeight);
        int totalCount = this.count();
        int i = 0;
        while (i < count) {
            int itemIndex = this.items.indexOf(tmpVector.elementAt(i));
            if (itemIndex >= 0 && itemIndex < totalCount) {
                clipRect.y = itemIndex * this.rowHeight;
                clipRect.height = this.rowHeight;
                if (i < count - 1) {
                    int nextIndex = this.items.indexOf(tmpVector.elementAt(i + 1));
                    if (nextIndex == itemIndex + 1) {
                        clipRect.height += this.rowHeight;
                        ++i;
                    } else if (nextIndex == itemIndex - 1) {
                        clipRect.height += this.rowHeight;
                        clipRect.y -= this.rowHeight;
                        ++i;
                    }
                }
                this.draw(clipRect);
            }
            ++i;
        }
        Rect.returnRect(clipRect);
        this.dirtyItems = tmpVector;
        this.dirtyItems.removeAllElements();
    }

    public void drawItemAt(int index) {
        Rect r = this.rectForItemAt(index);
        this.draw(r);
    }

    public void drawViewBackground(Graphics g, int x, int y, int width, int height) {
        if (!this.isTransparent() && this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(x, y, width, height);
        }
    }

    public void drawView(Graphics g) {
        int remainingHeight;
        if (this.dirtyItems != null) {
            this.dirtyItems.removeAllElements();
        }
        if (this.rowHeight <= 0) {
            this.drawViewBackground(g, 0, 0, this.bounds.width, this.bounds.height);
            return;
        }
        Rect clipRect = Rect.newRect(g.clipRect());
        int count = this.items.size();
        int i = clipRect.y / this.rowHeight;
        if (i < 0 || i >= count) {
            this.drawViewBackground(g, 0, 0, this.bounds.width, this.bounds.height);
            Rect.returnRect(clipRect);
            return;
        }
        Rect itemRect = this.rectForItemAt(i);
        boolean itemIsVisible = this.rectCompare(clipRect, itemRect) == 0;
        while (i < count && itemIsVisible) {
            g.pushState();
            g.setClipRect(itemRect);
            ListItem nextItem = (ListItem)this.items.elementAt(i);
            if (!this.isTransparent() && nextItem.isTransparent()) {
                this.drawViewBackground(g, itemRect.x, itemRect.y, this.bounds.width, this.rowHeight);
            }
            nextItem.drawInRect(g, itemRect);
            g.popState();
            ++i;
            itemRect.moveBy(0, this.rowHeight);
            boolean bl = itemIsVisible = this.rectCompare(clipRect, itemRect) == 0;
        }
        if (itemIsVisible && (remainingHeight = this.bounds.height - itemRect.y) > 0 && !this.isTransparent()) {
            this.drawViewBackground(g, itemRect.x, itemRect.y, this.bounds.width, remainingHeight);
        }
        Rect.returnRect(clipRect);
    }

    public void setTarget(Target newTarget) {
        this.target = newTarget;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String newCommand) {
        this.command = newCommand;
    }

    public String command() {
        return this.command;
    }

    public void setDoubleCommand(String newCommand) {
        this.doubleCommand = newCommand;
    }

    public String doubleCommand() {
        return this.doubleCommand;
    }

    public void sendCommand() {
        if (this.target != null) {
            String realCommand = null;
            ListItem selectedItem = this.selectedItem();
            if (selectedItem != null) {
                realCommand = selectedItem.command();
            }
            if (realCommand == null) {
                realCommand = this.command;
            }
            this.target.performCommand(realCommand, this);
        }
    }

    public void sendDoubleCommand() {
        if (this.target != null && this.doubleCommand != null) {
            this.target.performCommand(this.doubleCommand, this);
        }
    }

    public void performCommand(String aCommand, Object anObject) {
        if (SELECT_NEXT_ITEM.equals(aCommand)) {
            this.selectNextItem(true);
            return;
        }
        if (SELECT_PREVIOUS_ITEM.equals(aCommand)) {
            this.selectNextItem(false);
        }
    }

    void selectNextItem(boolean forward) {
        int si = this.selectedIndex();
        int count = this.count();
        if (forward) {
            if (si < count - 1) {
                this.selectItemAt(si + 1);
                this.sendCommand();
                return;
            }
        } else if (si > 0) {
            this.selectItemAt(si - 1);
            this.sendCommand();
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ListView", 2);
        info.addField(PROTOITEM_KEY, (byte)18);
        info.addField(ANCHORITEM_KEY, (byte)18);
        info.addField(ORIGSELECTED_KEY, (byte)18);
        info.addField(ITEMS_KEY, (byte)18);
        info.addField(SELECTEDITEMS_KEY, (byte)18);
        info.addField(DIRTYITEMS_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
        info.addField(DOUBLECOMMAND_KEY, (byte)16);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        info.addField(ROWHEIGHT_KEY, (byte)8);
        info.addField(MULTSELECTION_KEY, (byte)0);
        info.addField(EMPTYSELECTION_KEY, (byte)0);
        info.addField(TRACKSMOUSE_KEY, (byte)0);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(PROTOITEM_KEY, this.protoItem);
        encoder.encodeObject(ANCHORITEM_KEY, this.anchorItem);
        encoder.encodeObject(ORIGSELECTED_KEY, this.origSelectedItem);
        encoder.encodeObject(ITEMS_KEY, this.items);
        encoder.encodeObject(SELECTEDITEMS_KEY, this.selectedItems);
        encoder.encodeObject(DIRTYITEMS_KEY, this.dirtyItems);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(DOUBLECOMMAND_KEY, this.doubleCommand);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this.backgroundColor);
        encoder.encodeInt(ROWHEIGHT_KEY, this.rowHeight);
        encoder.encodeBoolean(MULTSELECTION_KEY, this.allowsMultipleSelection);
        encoder.encodeBoolean(EMPTYSELECTION_KEY, this.allowsEmptySelection);
        encoder.encodeBoolean(TRACKSMOUSE_KEY, this.tracksMouseOutsideBounds);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.protoItem = (ListItem)decoder.decodeObject(PROTOITEM_KEY);
        this.anchorItem = (ListItem)decoder.decodeObject(ANCHORITEM_KEY);
        this.origSelectedItem = (ListItem)decoder.decodeObject(ORIGSELECTED_KEY);
        this.items = (Vector)decoder.decodeObject(ITEMS_KEY);
        this.selectedItems = (Vector)decoder.decodeObject(SELECTEDITEMS_KEY);
        this.dirtyItems = (Vector)decoder.decodeObject(DIRTYITEMS_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.doubleCommand = decoder.decodeString(DOUBLECOMMAND_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this.rowHeight = decoder.decodeInt(ROWHEIGHT_KEY);
        this.allowsMultipleSelection = decoder.decodeBoolean(MULTSELECTION_KEY);
        this.allowsEmptySelection = decoder.decodeBoolean(EMPTYSELECTION_KEY);
        this.tracksMouseOutsideBounds = decoder.decodeBoolean(TRACKSMOUSE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        if (decoder.versionForClassName("netscape.application.ListView") > 1) {
            this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
            return;
        }
        this.transparent = false;
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SELECT_NEXT_ITEM, 1005, 0);
        this.setCommandForKey(SELECT_PREVIOUS_ITEM, 1004, 0);
    }

    public boolean canBecomeSelectedView() {
        return this.isEnabled();
    }

    public String formElementText() {
        if (this.selectedItem() != null) {
            return this.selectedItem().title();
        }
        return "";
    }
}

